/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.mailjdbc.tasks;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.derbyTesting.system.mailjdbc.MailJdbc;
import org.apache.derbyTesting.system.mailjdbc.utils.DbTasks;
import org.apache.derbyTesting.system.mailjdbc.utils.LogFile;

public class Refresh
extends Thread {
    private boolean isRunning = false;
    private DbTasks dbtasks = new DbTasks();
    private Connection conn = null;

    public Refresh(String name) throws Exception {
        this.setName(name);
        this.conn = DbTasks.getConnection("REFRESH", "Refresh");
    }

    @Override
    public void run() {
        try {
            this.grantRevoke(this.conn, this.getName());
            while (true) {
                this.doWork();
                try {
                    Thread.sleep(150000L);
                }
                catch (InterruptedException ie) {
                    MailJdbc.logAct.logMsg("#### " + this.getName() + "...Interrupted");
                    this.conn.commit();
                    MailJdbc.logAct.logMsg("#### " + this.getName() + "...commit connection...");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MailJdbc.logAct.logMsg(LogFile.ERROR + "Error while sleeping the thread in refresh: " + e.getMessage());
            return;
        }
    }

    private void doWork() {
        this.isRunning = true;
        try {
            this.insertMail(this.conn, this.getName());
            Thread.sleep(60000L);
        }
        catch (Exception e) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + "insertMail() failed " + e.getMessage());
        }
        try {
            MailJdbc.logAct.logMsg(LogFile.INFO + "Deleting mail by Refresh Thread : ");
            this.deleteMailByRefresh(this.conn, this.getName());
        }
        catch (Exception e) {
            MailJdbc.logAct.logMsg(LogFile.ERROR + "deleteMailByRefresh() failed " + e.getMessage());
            try {
                this.conn.rollback();
            }
            catch (SQLException se) {
                MailJdbc.logAct.logMsg(LogFile.ERROR + "rollback connection on Refresh failed..." + se.getMessage());
            }
            MailJdbc.logAct.logMsg("#### " + this.getName() + "...rollback connection after deleteMailByRefresh...");
        }
        MailJdbc.logAct.logMsg(LogFile.INFO + "Refresh doWork() completed");
        this.isRunning = false;
    }

    public void grantRevoke(Connection conn, String thread_name) throws Exception {
        this.dbtasks.grantRevoke(conn, thread_name);
    }

    public void insertMail(Connection conn, String thread_name) throws Exception {
        this.dbtasks.insertMail(conn, thread_name);
    }

    public void deleteMailByRefresh(Connection conn, String thread_name) throws Exception {
        this.dbtasks.deleteMailByThread(conn, thread_name);
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

