/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util.corruptio;

import java.io.File;
import java.io.IOException;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.derbyTesting.functionTests.util.corruptio.CorruptibleIo;

public class CorruptRandomAccessFile
implements StorageRandomAccessFile {
    private StorageRandomAccessFile realRaf;
    private CorruptibleIo cbio;
    private File realFile;

    CorruptRandomAccessFile(StorageRandomAccessFile raf, File realFile) {
        this.realRaf = raf;
        this.cbio = CorruptibleIo.getInstance();
        this.realFile = realFile;
    }

    public CorruptRandomAccessFile clone() {
        return new CorruptRandomAccessFile(this.realRaf.clone(), this.realFile);
    }

    public void close() throws IOException {
        this.realRaf.close();
    }

    public long getFilePointer() throws IOException {
        return this.realRaf.getFilePointer();
    }

    public long length() throws IOException {
        return this.realRaf.length();
    }

    public void seek(long newFilePointer) throws IOException {
        this.realRaf.seek(newFilePointer);
    }

    public void setLength(long newLength) throws IOException {
        this.realRaf.setLength(newLength);
    }

    public void sync() throws IOException {
        this.realRaf.sync();
    }

    public void readFully(byte[] b) throws IOException {
        this.realRaf.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.realRaf.readFully(b, off, len);
    }

    public int skipBytes(int nBytes) throws IOException {
        return this.realRaf.skipBytes(nBytes);
    }

    public boolean readBoolean() throws IOException {
        return this.realRaf.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.realRaf.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.realRaf.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.realRaf.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.realRaf.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.realRaf.readChar();
    }

    public int readInt() throws IOException {
        return this.realRaf.readInt();
    }

    public long readLong() throws IOException {
        return this.realRaf.readLong();
    }

    public float readFloat() throws IOException {
        return this.realRaf.readFloat();
    }

    public double readDouble() throws IOException {
        return this.realRaf.readDouble();
    }

    public String readLine() throws IOException {
        return this.realRaf.readLine();
    }

    public String readUTF() throws IOException {
        return this.realRaf.readUTF();
    }

    public void write(int b) throws IOException {
        this.realRaf.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.realRaf.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.cbio.isCorruptibleFile(this.realFile)) {
            this.cbio.corrupt(b, off, len);
        }
        this.realRaf.write(b, off, len);
    }

    public void writeBoolean(boolean value) throws IOException {
        this.realRaf.writeBoolean(value);
    }

    public void writeByte(int value) throws IOException {
        this.realRaf.writeByte(value);
    }

    public void writeShort(int value) throws IOException {
        this.realRaf.writeShort(value);
    }

    public void writeChar(int value) throws IOException {
        this.realRaf.writeChar(value);
    }

    public void writeInt(int value) throws IOException {
        this.realRaf.writeInt(value);
    }

    public void writeLong(long value) throws IOException {
        this.realRaf.writeLong(value);
    }

    public void writeFloat(float value) throws IOException {
        this.realRaf.writeFloat(value);
    }

    public void writeDouble(double value) throws IOException {
        this.realRaf.writeDouble(value);
    }

    public void writeBytes(String str) throws IOException {
        this.realRaf.writeBytes(str);
    }

    public void writeChars(String str) throws IOException {
        this.realRaf.writeChars(str);
    }

    public void writeUTF(String str) throws IOException {
        this.realRaf.writeUTF(str);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.realRaf.read(b, off, len);
    }
}

