/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UDAPermsTest
extends GeneratedColumnsHelper {
    private static final String TEST_DBO = "TEST_DBO";
    private static final String RUTH = "RUTH";
    private static final String ALICE = "ALICE";
    private static final String FRANK = "FRANK";
    private static final String TONY = "TONY";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "ALICE", "RUTH", "FRANK", "TONY"};
    private static final String MISSING_ROUTINE = "42Y03";
    private static final String IMPLICIT_CAST_ERROR = "42Y22";
    private static final String PARSE_ERROR = "42X01";
    private static final String BAD_DISTINCT = "42XAS";

    public UDAPermsTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = (BaseTestSuite)TestConfiguration.embeddedSuite(UDAPermsTest.class);
        CleanDatabaseTestSetup cleanTest = new CleanDatabaseTestSetup((Test)suite);
        Test authenticatedTest = DatabasePropertyTestSetup.builtinAuthentication((Test)cleanTest, LEGAL_USERS, "udaPermissions");
        Test authorizedTest = TestConfiguration.sqlAuthorizationDecorator(authenticatedTest);
        return authorizedTest;
    }

    public void test_001_basicGrant() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        Connection aliceConnection = this.openUserConnection(ALICE);
        this.goodStatement(ruthConnection, "create derby aggregate mode_01 for int\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.ModeAggregate'\n");
        this.goodStatement(ruthConnection, "create table mode_inputs_01( a int, b int )\n");
        this.goodStatement(ruthConnection, "insert into mode_inputs_01( a, b ) values ( 1, 1 ), ( 1, 2 ), ( 1, 2 ), ( 1, 2 ), ( 2, 3 ), ( 2, 3 ), ( 2, 4 )\n");
        this.goodStatement(ruthConnection, "grant select on mode_inputs_01 to public\n");
        this.expectExecutionError(aliceConnection, "42504", "select a, ruth.mode_01( b ) from ruth.mode_inputs_01 group by a\n");
        this.expectExecutionError(aliceConnection, "42504", "create view v_alice_01( a, modeOfA ) as select a, ruth.mode_01( b ) from ruth.mode_inputs_01 group by a\n");
        this.assertResults(dboConnection, "select a, ruth.mode_01( b ) from ruth.mode_inputs_01 group by a", new String[][]{{"1", "2"}, {"2", "3"}}, false);
        this.goodStatement(dboConnection, "create view v_dbo_01( a, modeOfA ) as select a, ruth.mode_01( b ) from ruth.mode_inputs_01 group by a\n");
        this.assertResults(dboConnection, "select * from v_dbo_01", new String[][]{{"1", "2"}, {"2", "3"}}, false);
        this.goodStatement(ruthConnection, "grant usage on derby aggregate mode_01 to public\n");
        this.assertResults(aliceConnection, "select a, ruth.mode_01( b ) from ruth.mode_inputs_01 group by a", new String[][]{{"1", "2"}, {"2", "3"}}, false);
        this.goodStatement(aliceConnection, "create view v_alice_01( a, modeOfA ) as select a, ruth.mode_01( b ) from ruth.mode_inputs_01 group by a\n");
        this.assertResults(aliceConnection, "select * from v_alice_01", new String[][]{{"1", "2"}, {"2", "3"}}, false);
    }

    public void test_002_basicRevoke() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        Connection aliceConnection = this.openUserConnection(ALICE);
        this.goodStatement(ruthConnection, "create derby aggregate mode_02 for int\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.ModeAggregate'\n");
        this.goodStatement(ruthConnection, "create table mode_inputs_02( a int, b int )\n");
        this.goodStatement(ruthConnection, "grant select on mode_inputs_02 to public\n");
        this.goodStatement(ruthConnection, "insert into mode_inputs_02( a, b ) values ( 1, 1 ), ( 1, 2 ), ( 1, 2 ), ( 1, 2 ), ( 2, 3 ), ( 2, 3 ), ( 2, 4 )\n");
        this.expectCompilationError(ruthConnection, PARSE_ERROR, "revoke usage on derby aggregate mode_02 from ruth\n");
        this.expectCompilationError(ruthConnection, "42509", "revoke usage on derby aggregate mode_02 from ruth restrict\n");
        String grantUsage = "grant usage on derby aggregate mode_02 to alice\n";
        String revokeUsage = "revoke usage on derby aggregate mode_02 from alice restrict\n";
        String createStatement = "create view v_alice_02( a, modeOfA ) as select a, ruth.mode_02( b ) from ruth.mode_inputs_02 group by a";
        String dropStatement = "drop view v_alice_02\n";
        String badRevokeSQLState = "X0Y23";
        this.verifyRevokePrivilege(ruthConnection, aliceConnection, grantUsage, revokeUsage, createStatement, dropStatement, badRevokeSQLState);
        this.goodStatement(aliceConnection, "create table t_source_02( a int )\n");
        this.goodStatement(aliceConnection, "create table t_target_02( a int )\n");
        createStatement = "create trigger t_insert_trigger_02\nafter insert on t_source_02\nfor each row\ninsert into t_target_02( a ) select ruth.mode_02( b ) from ruth.mode_inputs_02\n";
        dropStatement = "drop trigger t_insert_trigger_02\n";
        badRevokeSQLState = "X0Y25";
        this.verifyRevokePrivilege(ruthConnection, aliceConnection, grantUsage, revokeUsage, createStatement, dropStatement, badRevokeSQLState);
    }

    public void test_003_typePrivs() throws Exception {
        Connection ruthConnection = this.openUserConnection(RUTH);
        Connection aliceConnection = this.openUserConnection(ALICE);
        this.goodStatement(ruthConnection, "create type Price external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java");
        String grantUsage = "grant usage on type Price to public";
        String revokeUsage = "revoke usage on type Price from public restrict";
        String createStatement = "create derby aggregate priceMode for ruth.Price\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GenericMode'\n";
        String dropStatement = "drop derby aggregate priceMode restrict";
        String badRevokeSQLState = "X0Y30";
        this.verifyRevokePrivilege(ruthConnection, aliceConnection, grantUsage, revokeUsage, createStatement, dropStatement, badRevokeSQLState);
        this.goodStatement(ruthConnection, "create type Price_input external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java");
        this.goodStatement(ruthConnection, "create type Price_return external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java");
        this.goodStatement(ruthConnection, "grant usage on type Price_return to public");
        grantUsage = "grant usage on type Price_input to public";
        revokeUsage = "revoke usage on type Price_input from public restrict";
        createStatement = "create derby aggregate priceMode for ruth.Price_input returns ruth.Price_return\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GenericMode'\n";
        dropStatement = "drop derby aggregate priceMode restrict";
        badRevokeSQLState = "X0Y30";
        this.verifyRevokePrivilege(ruthConnection, aliceConnection, grantUsage, revokeUsage, createStatement, dropStatement, badRevokeSQLState);
        this.goodStatement(ruthConnection, "create type Price_input_2 external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java");
        this.goodStatement(ruthConnection, "create type Price_return_2 external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java");
        this.goodStatement(ruthConnection, "grant usage on type Price_input_2 to public");
        grantUsage = "grant usage on type Price_return_2 to public";
        revokeUsage = "revoke usage on type Price_return_2 from public restrict";
        createStatement = "create derby aggregate priceMode for ruth.Price_input_2 returns ruth.Price_return_2\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GenericMode'\n";
        dropStatement = "drop derby aggregate priceMode restrict";
        badRevokeSQLState = "X0Y30";
        this.verifyRevokePrivilege(ruthConnection, aliceConnection, grantUsage, revokeUsage, createStatement, dropStatement, badRevokeSQLState);
    }

    public void test_004_emptySchema() throws Exception {
        Connection tonyConnection = this.openUserConnection(TONY);
        this.expectCompilationError(tonyConnection, MISSING_ROUTINE, "values toString( 100 )");
    }

    public void test_005_builtinAggregators() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection ruthConnection = this.openUserConnection(RUTH);
        this.createSchema_005(ruthConnection);
        this.vetStatsBuiltins_005(dboConnection);
        this.vetStatsBuiltins_005(ruthConnection);
        this.dropSchema_005(ruthConnection);
    }

    private void vetStatsBuiltins_005(Connection conn) throws Exception {
        this.vetBuiltinAgg_005(conn, "var_pop", new String[][]{{"8.079999999999991"}}, (String[][])new String[][]{{"8.0"}});
        this.vetBuiltinAgg_005(conn, "var_samp", new String[][]{{"10.099999999999994"}}, (String[][])new String[][]{{"10.0"}});
        this.vetBuiltinAgg_005(conn, "stddev_pop", new String[][]{{"2.8425340807103776"}}, (String[][])new String[][]{{"2.8284271247461903"}});
        this.vetBuiltinAgg_005(conn, "stddev_samp", new String[][]{{"3.1780497164141397"}}, (String[][])new String[][]{{"3.1622776601683795"}});
    }

    private void vetBuiltinAgg_005(Connection conn, String aggName, String[][] expectedInexactResults, String[][] expectedExactResults) throws Exception {
        this.vetBuiltinAgg_005(conn, aggName, "doubles", expectedInexactResults);
        this.vetBuiltinAgg_005(conn, aggName, "floats", expectedInexactResults);
        this.vetBuiltinAgg_005(conn, aggName, "bigints", expectedExactResults);
        this.vetBuiltinAgg_005(conn, aggName, "ints", expectedExactResults);
        this.vetBuiltinAgg_005(conn, aggName, "smallints", expectedExactResults);
        this.vetBuiltinNegative_005(conn, aggName);
    }

    private void vetBuiltinAgg_005(Connection conn, String aggName, String tableName, String[][] expectedResults) throws Exception {
        this.assertResults(conn, "select " + aggName + "( a ) from ruth." + tableName, expectedResults, false);
    }

    private void vetBuiltinNegative_005(Connection conn, String aggName) throws Exception {
        this.expectCompilationError(conn, IMPLICIT_CAST_ERROR, "select " + aggName + "( a ) from ruth.varchars");
        this.expectCompilationError(conn, MISSING_ROUTINE, "select sys." + aggName + "( a ) from ruth.doubles");
        this.expectCompilationError(conn, PARSE_ERROR, "select " + aggName + "( all a ) from ruth.doubles");
        this.expectCompilationError(conn, BAD_DISTINCT, "select " + aggName + "( distinct a ) from ruth.doubles");
    }

    private void createSchema_005(Connection ruthConnection) throws Exception {
        this.goodStatement(ruthConnection, "create table doubles( a double )");
        this.goodStatement(ruthConnection, "insert into doubles values ( 1.2 ), ( 3.4 ), (5.6), (7.8), (9.0)");
        this.goodStatement(ruthConnection, "create table floats( a double )");
        this.goodStatement(ruthConnection, "insert into floats values ( 1.2 ), ( 3.4 ), (5.6), (7.8), (9.0)");
        this.goodStatement(ruthConnection, "create table bigints( a bigint )");
        this.goodStatement(ruthConnection, "insert into bigints values ( 1 ), ( 3 ), (5), (7), (9)");
        this.goodStatement(ruthConnection, "create table ints( a bigint )");
        this.goodStatement(ruthConnection, "insert into ints values ( 1 ), ( 3 ), (5), (7), (9)");
        this.goodStatement(ruthConnection, "create table smallints( a bigint )");
        this.goodStatement(ruthConnection, "insert into smallints values ( 1 ), ( 3 ), (5), (7), (9)");
        this.goodStatement(ruthConnection, "create table varchars( a varchar( 10 ) )");
        this.goodStatement(ruthConnection, "insert into varchars values ( '1' ), ( '3' ), ( '5' ), ( '7' ), ( '9' )");
    }

    private void dropSchema_005(Connection ruthConnection) throws Exception {
        this.goodStatement(ruthConnection, "drop table varchars");
        this.goodStatement(ruthConnection, "drop table smallints");
        this.goodStatement(ruthConnection, "drop table ints");
        this.goodStatement(ruthConnection, "drop table bigints");
        this.goodStatement(ruthConnection, "drop table floats");
        this.goodStatement(ruthConnection, "drop table doubles");
    }
}

