/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.documentation.velocity;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.matchers.AbstractMatcherContainer;
import org.apache.rat.config.parameters.ComponentType;
import org.apache.rat.config.parameters.Description;
import org.apache.rat.config.parameters.DescriptionBuilder;
import org.apache.rat.configuration.XMLConfig;

public class Matcher {
    private final Description desc;
    private final IHeaderMatcher self;
    private final Enclosed enclosed;
    private final Set<Attribute> attributes;

    Matcher(Matcher matcher) {
        this.desc = matcher.desc;
        this.self = matcher.self;
        this.enclosed = matcher.enclosed;
        this.attributes = matcher.attributes;
    }

    Matcher(IHeaderMatcher self) {
        this(DescriptionBuilder.buildMap(self.getClass()), self);
    }

    Matcher(Description desc, IHeaderMatcher self) {
        Objects.requireNonNull(desc);
        this.desc = desc;
        this.self = self;
        Enclosed enclosed = null;
        this.attributes = new TreeSet<Attribute>(Comparator.comparing(Attribute::getName));
        for (Description child : desc.childrenOfType(ComponentType.PARAMETER)) {
            if (XMLConfig.isInlineNode(desc.getCommonName(), child.getCommonName())) {
                enclosed = new Enclosed(child);
                continue;
            }
            this.attributes.add(new Attribute(child));
        }
        this.enclosed = enclosed;
    }

    public String getName() {
        return this.desc.getCommonName();
    }

    public String getDescription() {
        return StringUtils.defaultIfEmpty(this.desc.getDescription(), "");
    }

    public Enclosed getEnclosed() {
        return this.enclosed;
    }

    public Collection<Attribute> getAttributes() {
        return this.attributes;
    }

    Collection<Matcher> getChildren() {
        if (this.self != null && this.enclosed != null && IHeaderMatcher.class.equals(this.enclosed.desc.getChildType())) {
            if (this.self instanceof AbstractMatcherContainer) {
                AbstractMatcherContainer matcherContainer = (AbstractMatcherContainer)this.self;
                return matcherContainer.getEnclosed().stream().map(Matcher::new).collect(Collectors.toList());
            }
            try {
                IHeaderMatcher matcher = (IHeaderMatcher)this.enclosed.desc.getter(this.self.getClass()).invoke((Object)this.self, new Object[0]);
                return Collections.singleton(new Matcher(matcher));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.emptyList();
    }

    public final class Enclosed {
        private final Description desc;

        Enclosed(Description desc) {
            this.desc = desc;
        }

        public String getRequired() {
            return this.desc.isRequired() ? "required" : "optional";
        }

        public String getCollection() {
            return this.desc.isCollection() ? "or more " : "";
        }

        public String getType() {
            return this.desc.getChildType().getSimpleName();
        }

        public Object getValue() {
            if (Matcher.this.self != null) {
                try {
                    Object value = this.desc.getter(Matcher.this.self.getClass()).invoke((Object)Matcher.this.self, new Object[0]);
                    return value instanceof String ? StringUtils.normalizeSpace((String)value) : value;
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }

        Class<?> getChildType() {
            return this.desc.getChildType();
        }
    }

    public final class Attribute {
        private final Description description;

        Attribute(Description description) {
            this.description = description;
        }

        public String getName() {
            return this.description.getCommonName();
        }

        public String getRequired() {
            return this.description.isRequired() ? "required" : "optional";
        }

        public String getType() {
            return this.description.getChildType().getSimpleName();
        }

        public String getDescription() {
            return StringUtils.defaultIfEmpty(this.description.getDescription(), "");
        }

        public String getValue() {
            if (Matcher.this.self != null) {
                try {
                    Object value = this.description.getter(Matcher.this.self.getClass()).invoke((Object)Matcher.this.self, new Object[0]);
                    if (value != null) {
                        String result = value.toString();
                        if (this.description.getCommonName().equals("id")) {
                            try {
                                UUID.fromString(result);
                                return null;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                        return result;
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }
    }
}

