/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.config.exclusion.fileProcessors;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.api.EnvVar;
import org.apache.rat.config.exclusion.ExclusionUtils;
import org.apache.rat.config.exclusion.MatcherSet;
import org.apache.rat.config.exclusion.fileProcessors.AbstractFileProcessorBuilder;
import org.apache.rat.config.exclusion.plexus.MatchPatterns;
import org.apache.rat.document.DocumentName;
import org.apache.rat.document.DocumentNameMatcher;

public class GitIgnoreBuilder
extends AbstractFileProcessorBuilder {
    private static final String IGNORE_FILE = ".gitignore";
    private static final String COMMENT_PREFIX = "#";
    private static final String ESCAPED_COMMENT = "\\#";
    private static final String ESCAPED_NEGATION = "\\!";
    private static final String SLASH = "/";

    public GitIgnoreBuilder() {
        super(IGNORE_FILE, COMMENT_PREFIX, true);
    }

    private MatcherSet processGlobalIgnore(Consumer<MatcherSet> matcherSetConsumer, DocumentName root, DocumentName globalGitIgnore) {
        MatcherSet.Builder matcherSetBuilder = new MatcherSet.Builder();
        ArrayList<String> iterable = new ArrayList<String>();
        ExclusionUtils.asIterator(globalGitIgnore.asFile(), this.commentFilter).map(entry -> this.modifyEntry(matcherSetConsumer, globalGitIgnore, (String)entry).orElse(null)).filter(Objects::nonNull).map(entry -> ExclusionUtils.qualifyPattern(root, entry)).forEachRemaining(iterable::add);
        HashSet<String> included = new HashSet<String>();
        HashSet<String> excluded = new HashSet<String>();
        MatcherSet.Builder.segregateList(excluded, included, iterable);
        DocumentName displayName = DocumentName.builder(root).setName("global gitignore").build();
        matcherSetBuilder.addExcluded(displayName, excluded);
        matcherSetBuilder.addIncluded(displayName, included);
        return matcherSetBuilder.build();
    }

    @Override
    protected MatcherSet process(Consumer<MatcherSet> matcherSetConsumer, DocumentName root, DocumentName documentName) {
        if (root.equals(documentName.getBaseDocumentName())) {
            Optional<File> globalGitIgnore = this.globalGitIgnore();
            ArrayList<MatcherSet> matcherSets = new ArrayList<MatcherSet>();
            matcherSets.add(super.process(matcherSetConsumer, root, documentName));
            if (globalGitIgnore.isPresent()) {
                AbstractFileProcessorBuilder.LevelBuilder levelBuilder = this.getLevelBuilder(Integer.MAX_VALUE);
                DocumentName ignore = DocumentName.builder(globalGitIgnore.get()).build();
                matcherSets.add(this.processGlobalIgnore(levelBuilder::add, root, ignore));
            }
            return MatcherSet.merge(matcherSets);
        }
        return super.process(matcherSetConsumer, root, documentName);
    }

    @Override
    protected Optional<String> modifyEntry(Consumer<MatcherSet> matcherSetConsumer, DocumentName documentName, String entry) {
        boolean prefix = entry.startsWith("!");
        String pattern = prefix || entry.startsWith(ESCAPED_COMMENT) || entry.startsWith(ESCAPED_NEGATION) ? entry.substring(1) : entry;
        int slashPos = pattern.indexOf(SLASH);
        if (slashPos == -1 || slashPos == pattern.length() - 1) {
            pattern = "**/" + pattern;
        }
        if (slashPos == 0) {
            pattern = pattern.substring(1);
        }
        if (pattern.endsWith(SLASH)) {
            pattern = pattern.substring(0, pattern.length() - 1);
            String name = prefix ? "!" + pattern : pattern;
            DocumentName matcherPattern = DocumentName.builder(documentName).setName(name.replace(SLASH, documentName.getDirectorySeparator())).build();
            DocumentNameMatcher matcher = DocumentNameMatcher.and(new DocumentNameMatcher("isDirectory", File::isDirectory), new DocumentNameMatcher(name, MatchPatterns.from(matcherPattern.localized(documentName.getDirectorySeparator()), new String[0])));
            MatcherSet.Builder builder = new MatcherSet.Builder();
            if (prefix) {
                builder.addIncluded(matcher);
            } else {
                builder.addExcluded(matcher);
            }
            matcherSetConsumer.accept(builder.build());
            return Optional.empty();
        }
        return Optional.of(prefix ? "!" + pattern : pattern);
    }

    protected Optional<File> globalGitIgnore() {
        String filename;
        if (EnvVar.RAT_NO_GIT_GLOBAL_IGNORE.isSet()) {
            return Optional.empty();
        }
        String xdgConfigHome = EnvVar.XDG_CONFIG_HOME.getValue();
        if (xdgConfigHome != null && !xdgConfigHome.isEmpty()) {
            filename = xdgConfigHome + File.separator + "git" + File.separator + "ignore";
        } else {
            String home = StringUtils.defaultIfEmpty(EnvVar.HOME.getValue(), "");
            filename = home + File.separator + ".config" + File.separator + "git" + File.separator + "ignore";
        }
        File file = new File(filename);
        if (file.exists()) {
            return Optional.of(file);
        }
        return Optional.empty();
    }
}

