/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.routines.CodeValidator;
import org.apache.commons.validator.routines.CreditCardValidator;
import org.apache.commons.validator.routines.RegexValidator;
import org.apache.commons.validator.routines.checkdigit.LuhnCheckDigit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CreditCardValidatorTest {
    private static final String VALID_VISA = "4417123456789113";
    private static final String ERROR_VISA = "4417123456789112";
    private static final String VALID_SHORT_VISA = "4222222222222";
    private static final String ERROR_SHORT_VISA = "4222222222229";
    private static final String VALID_AMEX = "378282246310005";
    private static final String ERROR_AMEX = "378282246310001";
    private static final String VALID_MASTERCARD = "5105105105105100";
    private static final String ERROR_MASTERCARD = "5105105105105105";
    private static final String VALID_DISCOVER = "6011000990139424";
    private static final String ERROR_DISCOVER = "6011000990139421";
    private static final String VALID_DISCOVER65 = "6534567890123458";
    private static final String ERROR_DISCOVER65 = "6534567890123450";
    private static final String VALID_DINERS = "30569309025904";
    private static final String ERROR_DINERS = "30569309025901";
    private static final String VALID_VPAY = "4370000000000061";
    private static final String VALID_VPAY2 = "4370000000000012";
    private static final String ERROR_VPAY = "4370000000000069";
    private static final String[] VALID_CARDS = new String[]{"4417123456789113", "4222222222222", "378282246310005", "5105105105105100", "6011000990139424", "6534567890123458", "30569309025904", "4370000000000061", "4370000000000012", "60115564485789458"};
    private static final String[] ERROR_CARDS = new String[]{"4417123456789112", "4222222222229", "378282246310001", "5105105105105105", "6011000990139421", "6534567890123450", "30569309025901", "4370000000000069", "", "12345678901", "12345678901234567890", "4417123456789112"};

    CreditCardValidatorTest() {
    }

    @Test
    void testAddAllowedCardType() {
        CreditCardValidator ccv = new CreditCardValidator(0L);
        Assertions.assertFalse((boolean)ccv.isValid(VALID_VISA));
        Assertions.assertFalse((boolean)ccv.isValid(VALID_AMEX));
        Assertions.assertFalse((boolean)ccv.isValid(VALID_MASTERCARD));
        Assertions.assertFalse((boolean)ccv.isValid(VALID_DISCOVER));
        Assertions.assertFalse((boolean)ccv.isValid(VALID_DINERS));
    }

    @Test
    void testAmexOption() {
        CreditCardValidator validator = new CreditCardValidator(1L);
        Assertions.assertFalse((boolean)validator.isValid(ERROR_AMEX), (String)"Invalid");
        Assertions.assertNull((Object)validator.validate(ERROR_AMEX), (String)"validate()");
        Assertions.assertEquals((Object)VALID_AMEX, (Object)validator.validate(VALID_AMEX));
        Assertions.assertTrue((boolean)validator.isValid(VALID_AMEX), (String)"Amex");
        Assertions.assertFalse((boolean)validator.isValid(VALID_DINERS), (String)"Diners");
        Assertions.assertFalse((boolean)validator.isValid(VALID_DISCOVER), (String)"Discover");
        Assertions.assertFalse((boolean)validator.isValid(VALID_MASTERCARD), (String)"Mastercard");
        Assertions.assertFalse((boolean)validator.isValid(VALID_VISA), (String)"Visa");
        Assertions.assertFalse((boolean)validator.isValid(VALID_SHORT_VISA), (String)"Visa Short");
    }

    @Test
    void testAmexValidator() {
        CodeValidator validator = CreditCardValidator.AMEX_VALIDATOR;
        RegexValidator regex = validator.getRegexValidator();
        Assertions.assertFalse((boolean)regex.isValid("343456789012"), (String)"Length 12");
        Assertions.assertFalse((boolean)regex.isValid("3434567890123"), (String)"Length 13");
        Assertions.assertFalse((boolean)regex.isValid("34345678901234"), (String)"Length 14");
        Assertions.assertTrue((boolean)regex.isValid("343456789012345"), (String)"Length 15");
        Assertions.assertFalse((boolean)regex.isValid("3434567890123456"), (String)"Length 16");
        Assertions.assertFalse((boolean)regex.isValid("34345678901234567"), (String)"Length 17");
        Assertions.assertFalse((boolean)regex.isValid("343456789012345678"), (String)"Length 18");
        Assertions.assertFalse((boolean)regex.isValid("333456789012345"), (String)"Prefix 33");
        Assertions.assertTrue((boolean)regex.isValid("343456789012345"), (String)"Prefix 34");
        Assertions.assertFalse((boolean)regex.isValid("353456789012345"), (String)"Prefix 35");
        Assertions.assertFalse((boolean)regex.isValid("363456789012345"), (String)"Prefix 36");
        Assertions.assertTrue((boolean)regex.isValid("373456789012345"), (String)"Prefix 37");
        Assertions.assertFalse((boolean)regex.isValid("383456789012345"), (String)"Prefix 38");
        Assertions.assertFalse((boolean)regex.isValid("413456789012345"), (String)"Prefix 41");
        Assertions.assertFalse((boolean)regex.isValid("3434567x9012345"), (String)"Invalid Char");
        Assertions.assertTrue((boolean)regex.isValid(ERROR_AMEX), (String)"Valid regex");
        Assertions.assertFalse((boolean)validator.isValid(ERROR_AMEX), (String)"Invalid");
        Assertions.assertNull((Object)validator.validate(ERROR_AMEX), (String)"validate()");
        Assertions.assertEquals((Object)VALID_AMEX, (Object)validator.validate(VALID_AMEX));
        Assertions.assertTrue((boolean)validator.isValid(VALID_AMEX), (String)"Amex");
        Assertions.assertFalse((boolean)validator.isValid(VALID_DINERS), (String)"Diners");
        Assertions.assertFalse((boolean)validator.isValid(VALID_DISCOVER), (String)"Discover");
        Assertions.assertFalse((boolean)validator.isValid(VALID_MASTERCARD), (String)"Mastercard");
        Assertions.assertFalse((boolean)validator.isValid(VALID_VISA), (String)"Visa");
        Assertions.assertFalse((boolean)validator.isValid(VALID_SHORT_VISA), (String)"Visa Short");
        Assertions.assertTrue((boolean)validator.isValid("371449635398431"), (String)"Valid-A");
        Assertions.assertTrue((boolean)validator.isValid("340000000000009"), (String)"Valid-B");
        Assertions.assertTrue((boolean)validator.isValid("370000000000002"), (String)"Valid-C");
        Assertions.assertTrue((boolean)validator.isValid("378734493671000"), (String)"Valid-D");
    }

    @Test
    void testArrayConstructor() {
        CreditCardValidator ccv = new CreditCardValidator(new CodeValidator[]{CreditCardValidator.VISA_VALIDATOR, CreditCardValidator.AMEX_VALIDATOR});
        Assertions.assertTrue((boolean)ccv.isValid(VALID_VISA));
        Assertions.assertTrue((boolean)ccv.isValid(VALID_SHORT_VISA));
        Assertions.assertTrue((boolean)ccv.isValid(VALID_AMEX));
        Assertions.assertFalse((boolean)ccv.isValid(VALID_MASTERCARD));
        Assertions.assertFalse((boolean)ccv.isValid(VALID_DISCOVER));
        Assertions.assertFalse((boolean)ccv.isValid(ERROR_VISA));
        Assertions.assertFalse((boolean)ccv.isValid(ERROR_SHORT_VISA));
        Assertions.assertFalse((boolean)ccv.isValid(ERROR_AMEX));
        Assertions.assertFalse((boolean)ccv.isValid(ERROR_MASTERCARD));
        Assertions.assertFalse((boolean)ccv.isValid(ERROR_DISCOVER));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CreditCardValidator((CodeValidator[])null));
    }

    @Test
    void testDinersOption() {
        CreditCardValidator validator = new CreditCardValidator(16L);
        Assertions.assertFalse((boolean)validator.isValid(ERROR_DINERS), (String)"Invalid");
        Assertions.assertNull((Object)validator.validate(ERROR_DINERS), (String)"validate()");
        Assertions.assertEquals((Object)VALID_DINERS, (Object)validator.validate(VALID_DINERS));
        Assertions.assertFalse((boolean)validator.isValid(VALID_AMEX), (String)"Amex");
        Assertions.assertTrue((boolean)validator.isValid(VALID_DINERS), (String)"Diners");
        Assertions.assertFalse((boolean)validator.isValid(VALID_DISCOVER), (String)"Discover");
        Assertions.assertFalse((boolean)validator.isValid(VALID_MASTERCARD), (String)"Mastercard");
        Assertions.assertFalse((boolean)validator.isValid(VALID_VISA), (String)"Visa");
        Assertions.assertFalse((boolean)validator.isValid(VALID_SHORT_VISA), (String)"Visa Short");
    }

    @Test
    void testDinersValidator() {
        CodeValidator validator = CreditCardValidator.DINERS_VALIDATOR;
        RegexValidator regex = validator.getRegexValidator();
        Assertions.assertFalse((boolean)regex.isValid("300456789012"), (String)"Length 12-300");
        Assertions.assertFalse((boolean)regex.isValid("363456789012"), (String)"Length 12-36");
        Assertions.assertFalse((boolean)regex.isValid("3004567890123"), (String)"Length 13-300");
        Assertions.assertFalse((boolean)regex.isValid("3634567890123"), (String)"Length 13-36");
        Assertions.assertTrue((boolean)regex.isValid("30045678901234"), (String)"Length 14-300");
        Assertions.assertTrue((boolean)regex.isValid("36345678901234"), (String)"Length 14-36");
        Assertions.assertFalse((boolean)regex.isValid("300456789012345"), (String)"Length 15-300");
        Assertions.assertFalse((boolean)regex.isValid("363456789012345"), (String)"Length 15-36");
        Assertions.assertFalse((boolean)regex.isValid("3004567890123456"), (String)"Length 16-300");
        Assertions.assertFalse((boolean)regex.isValid("3634567890123456"), (String)"Length 16-36");
        Assertions.assertFalse((boolean)regex.isValid("30045678901234567"), (String)"Length 17-300");
        Assertions.assertFalse((boolean)regex.isValid("36345678901234567"), (String)"Length 17-36");
        Assertions.assertFalse((boolean)regex.isValid("300456789012345678"), (String)"Length 18-300");
        Assertions.assertFalse((boolean)regex.isValid("363456789012345678"), (String)"Length 18-36");
        Assertions.assertTrue((boolean)regex.isValid("30045678901234"), (String)"Prefix 300");
        Assertions.assertTrue((boolean)regex.isValid("30145678901234"), (String)"Prefix 301");
        Assertions.assertTrue((boolean)regex.isValid("30245678901234"), (String)"Prefix 302");
        Assertions.assertTrue((boolean)regex.isValid("30345678901234"), (String)"Prefix 303");
        Assertions.assertTrue((boolean)regex.isValid("30445678901234"), (String)"Prefix 304");
        Assertions.assertTrue((boolean)regex.isValid("30545678901234"), (String)"Prefix 305");
        Assertions.assertFalse((boolean)regex.isValid("30645678901234"), (String)"Prefix 306");
        Assertions.assertFalse((boolean)regex.isValid("30945678901234"), (String)"Prefix 3094");
        Assertions.assertTrue((boolean)regex.isValid("30955678901234"), (String)"Prefix 3095");
        Assertions.assertFalse((boolean)regex.isValid("30965678901234"), (String)"Prefix 3096");
        Assertions.assertFalse((boolean)regex.isValid("35345678901234"), (String)"Prefix 35");
        Assertions.assertTrue((boolean)regex.isValid("36345678901234"), (String)"Prefix 36");
        Assertions.assertFalse((boolean)regex.isValid("37345678901234"), (String)"Prefix 37");
        Assertions.assertTrue((boolean)regex.isValid("38345678901234"), (String)"Prefix 38");
        Assertions.assertTrue((boolean)regex.isValid("39345678901234"), (String)"Prefix 39");
        Assertions.assertFalse((boolean)regex.isValid("3004567x901234"), (String)"Invalid Char-A");
        Assertions.assertFalse((boolean)regex.isValid("3634567x901234"), (String)"Invalid Char-B");
        Assertions.assertTrue((boolean)regex.isValid(ERROR_DINERS), (String)"Valid regex");
        Assertions.assertFalse((boolean)validator.isValid(ERROR_DINERS), (String)"Invalid");
        Assertions.assertNull((Object)validator.validate(ERROR_DINERS), (String)"validate()");
        Assertions.assertEquals((Object)VALID_DINERS, (Object)validator.validate(VALID_DINERS));
        Assertions.assertFalse((boolean)validator.isValid(VALID_AMEX), (String)"Amex");
        Assertions.assertTrue((boolean)validator.isValid(VALID_DINERS), (String)"Diners");
        Assertions.assertFalse((boolean)validator.isValid(VALID_DISCOVER), (String)"Discover");
        Assertions.assertFalse((boolean)validator.isValid(VALID_MASTERCARD), (String)"Mastercard");
        Assertions.assertFalse((boolean)validator.isValid(VALID_VISA), (String)"Visa");
        Assertions.assertFalse((boolean)validator.isValid(VALID_SHORT_VISA), (String)"Visa Short");
        Assertions.assertTrue((boolean)validator.isValid("30000000000004"), (String)"Valid-A");
        Assertions.assertTrue((boolean)validator.isValid("30123456789019"), (String)"Valid-B");
        Assertions.assertTrue((boolean)validator.isValid("36432685260294"), (String)"Valid-C");
    }

    @Test
    void testDiscoverOption() {
        CreditCardValidator validator = new CreditCardValidator(8L);
        Assertions.assertFalse((boolean)validator.isValid(ERROR_DISCOVER), (String)"Invalid");
        Assertions.assertFalse((boolean)validator.isValid(ERROR_DISCOVER65), (String)"Invalid65");
        Assertions.assertNull((Object)validator.validate(ERROR_DISCOVER), (String)"validate()");
        Assertions.assertEquals((Object)VALID_DISCOVER, (Object)validator.validate(VALID_DISCOVER));
        Assertions.assertEquals((Object)VALID_DISCOVER65, (Object)validator.validate(VALID_DISCOVER65));
        Assertions.assertFalse((boolean)validator.isValid(VALID_AMEX), (String)"Amex");
        Assertions.assertFalse((boolean)validator.isValid(VALID_DINERS), (String)"Diners");
        Assertions.assertTrue((boolean)validator.isValid(VALID_DISCOVER), (String)"Discover");
        Assertions.assertTrue((boolean)validator.isValid(VALID_DISCOVER65), (String)"Discover");
        Assertions.assertFalse((boolean)validator.isValid(VALID_MASTERCARD), (String)"Mastercard");
        Assertions.assertFalse((boolean)validator.isValid(VALID_VISA), (String)"Visa");
        Assertions.assertFalse((boolean)validator.isValid(VALID_SHORT_VISA), (String)"Visa Short");
    }

    @Test
    void testDiscoverValidator() {
        CodeValidator validator = CreditCardValidator.DISCOVER_VALIDATOR;
        RegexValidator regex = validator.getRegexValidator();
        Assertions.assertFalse((boolean)regex.isValid("601156789012"), (String)"Length 12-6011");
        Assertions.assertFalse((boolean)regex.isValid("653456789012"), (String)"Length 12-65");
        Assertions.assertFalse((boolean)regex.isValid("6011567890123"), (String)"Length 13-6011");
        Assertions.assertFalse((boolean)regex.isValid("6534567890123"), (String)"Length 13-65");
        Assertions.assertFalse((boolean)regex.isValid("60115678901234"), (String)"Length 14-6011");
        Assertions.assertFalse((boolean)regex.isValid("65345678901234"), (String)"Length 14-65");
        Assertions.assertFalse((boolean)regex.isValid("601156789012345"), (String)"Length 15-6011");
        Assertions.assertFalse((boolean)regex.isValid("653456789012345"), (String)"Length 15-65");
        Assertions.assertTrue((boolean)regex.isValid("6011567890123456"), (String)"Length 16-6011");
        Assertions.assertTrue((boolean)regex.isValid("6444567890123456"), (String)"Length 16-644");
        Assertions.assertTrue((boolean)regex.isValid("6484567890123456"), (String)"Length 16-648");
        Assertions.assertTrue((boolean)regex.isValid("6534567890123456"), (String)"Length 16-65");
        Assertions.assertFalse((boolean)regex.isValid("65345678901234567"), (String)"Length 17-65");
        Assertions.assertFalse((boolean)regex.isValid("601156789012345678"), (String)"Length 18-6011");
        Assertions.assertFalse((boolean)regex.isValid("653456789012345678"), (String)"Length 18-65");
        Assertions.assertFalse((boolean)regex.isValid("6404567890123456"), (String)"Prefix 640");
        Assertions.assertFalse((boolean)regex.isValid("6414567890123456"), (String)"Prefix 641");
        Assertions.assertFalse((boolean)regex.isValid("6424567890123456"), (String)"Prefix 642");
        Assertions.assertFalse((boolean)regex.isValid("6434567890123456"), (String)"Prefix 643");
        Assertions.assertFalse((boolean)regex.isValid("6010567890123456"), (String)"Prefix 6010");
        Assertions.assertFalse((boolean)regex.isValid("6012567890123456"), (String)"Prefix 6012");
        Assertions.assertFalse((boolean)regex.isValid("6011567x90123456"), (String)"Invalid Char");
        Assertions.assertTrue((boolean)regex.isValid(ERROR_DISCOVER), (String)"Valid regex");
        Assertions.assertTrue((boolean)regex.isValid(ERROR_DISCOVER65), (String)"Valid regex65");
        Assertions.assertFalse((boolean)validator.isValid(ERROR_DISCOVER), (String)"Invalid");
        Assertions.assertFalse((boolean)validator.isValid(ERROR_DISCOVER65), (String)"Invalid65");
        Assertions.assertNull((Object)validator.validate(ERROR_DISCOVER), (String)"validate()");
        Assertions.assertEquals((Object)VALID_DISCOVER, (Object)validator.validate(VALID_DISCOVER));
        Assertions.assertEquals((Object)VALID_DISCOVER65, (Object)validator.validate(VALID_DISCOVER65));
        Assertions.assertFalse((boolean)validator.isValid(VALID_AMEX), (String)"Amex");
        Assertions.assertFalse((boolean)validator.isValid(VALID_DINERS), (String)"Diners");
        Assertions.assertTrue((boolean)validator.isValid(VALID_DISCOVER), (String)"Discover");
        Assertions.assertTrue((boolean)validator.isValid(VALID_DISCOVER65), (String)"Discover");
        Assertions.assertFalse((boolean)validator.isValid(VALID_MASTERCARD), (String)"Mastercard");
        Assertions.assertFalse((boolean)validator.isValid(VALID_VISA), (String)"Visa");
        Assertions.assertFalse((boolean)validator.isValid(VALID_SHORT_VISA), (String)"Visa Short");
        Assertions.assertTrue((boolean)validator.isValid("6011111111111117"), (String)"Valid-A");
        Assertions.assertTrue((boolean)validator.isValid("6011000000000004"), (String)"Valid-B");
        Assertions.assertTrue((boolean)validator.isValid("6011000000000012"), (String)"Valid-C");
    }

    @Test
    void testDisjointRange() {
        CreditCardValidator ccv = new CreditCardValidator(new CreditCardValidator.CreditCardRange[]{new CreditCardValidator.CreditCardRange("305", "4", new int[]{13, 16})});
        Assertions.assertEquals((int)13, (int)VALID_SHORT_VISA.length());
        Assertions.assertEquals((int)16, (int)VALID_VISA.length());
        Assertions.assertEquals((int)14, (int)VALID_DINERS.length());
        Assertions.assertTrue((boolean)ccv.isValid(VALID_SHORT_VISA));
        Assertions.assertTrue((boolean)ccv.isValid(VALID_VISA));
        Assertions.assertFalse((boolean)ccv.isValid(ERROR_SHORT_VISA));
        Assertions.assertFalse((boolean)ccv.isValid(ERROR_VISA));
        Assertions.assertFalse((boolean)ccv.isValid(VALID_DINERS));
        ccv = new CreditCardValidator(new CreditCardValidator.CreditCardRange[]{new CreditCardValidator.CreditCardRange("305", "4", new int[]{13, 14, 16})});
        Assertions.assertTrue((boolean)ccv.isValid(VALID_DINERS));
    }

    @Test
    void testGeneric() {
        CreditCardValidator ccv = CreditCardValidator.genericCreditCardValidator();
        for (String s : VALID_CARDS) {
            Assertions.assertTrue((boolean)ccv.isValid(s), (String)s);
        }
        for (String s : ERROR_CARDS) {
            Assertions.assertFalse((boolean)ccv.isValid(s), (String)s);
        }
    }

    @Test
    public void testGenericValidatorCircularDependency() {
        CreditCardValidator ccv = new CreditCardValidator();
        GenericValidator.isCreditCard((String)"1234567890");
    }

    @Test
    void testIsValid() {
        CreditCardValidator ccv = new CreditCardValidator();
        Assertions.assertNull((Object)ccv.validate(null));
        Assertions.assertFalse((boolean)ccv.isValid(null));
        Assertions.assertFalse((boolean)ccv.isValid(""));
        Assertions.assertFalse((boolean)ccv.isValid("123456789012"));
        Assertions.assertFalse((boolean)ccv.isValid("12345678901234567890"));
        Assertions.assertFalse((boolean)ccv.isValid(ERROR_VISA));
        Assertions.assertFalse((boolean)ccv.isValid("4417q23456w89113"));
        Assertions.assertTrue((boolean)ccv.isValid(VALID_VISA));
        Assertions.assertTrue((boolean)ccv.isValid(VALID_SHORT_VISA));
        Assertions.assertTrue((boolean)ccv.isValid(VALID_AMEX));
        Assertions.assertTrue((boolean)ccv.isValid(VALID_MASTERCARD));
        Assertions.assertTrue((boolean)ccv.isValid(VALID_DISCOVER));
        Assertions.assertTrue((boolean)ccv.isValid(VALID_DISCOVER65));
        Assertions.assertFalse((boolean)ccv.isValid(ERROR_VISA));
        Assertions.assertFalse((boolean)ccv.isValid(ERROR_SHORT_VISA));
        Assertions.assertFalse((boolean)ccv.isValid(ERROR_AMEX));
        Assertions.assertFalse((boolean)ccv.isValid(ERROR_MASTERCARD));
        Assertions.assertFalse((boolean)ccv.isValid(ERROR_DISCOVER));
        Assertions.assertFalse((boolean)ccv.isValid(ERROR_DISCOVER65));
        ccv = new CreditCardValidator(1L);
        Assertions.assertFalse((boolean)ccv.isValid(VALID_VISA));
    }

    @Test
    void testMastercardOption() {
        CreditCardValidator validator = new CreditCardValidator(4L);
        Assertions.assertFalse((boolean)validator.isValid(ERROR_MASTERCARD), (String)"Invalid");
        Assertions.assertNull((Object)validator.validate(ERROR_MASTERCARD), (String)"validate()");
        Assertions.assertEquals((Object)VALID_MASTERCARD, (Object)validator.validate(VALID_MASTERCARD));
        Assertions.assertFalse((boolean)validator.isValid(VALID_AMEX), (String)"Amex");
        Assertions.assertFalse((boolean)validator.isValid(VALID_DINERS), (String)"Diners");
        Assertions.assertFalse((boolean)validator.isValid(VALID_DISCOVER), (String)"Discover");
        Assertions.assertTrue((boolean)validator.isValid(VALID_MASTERCARD), (String)"Mastercard");
        Assertions.assertFalse((boolean)validator.isValid(VALID_VISA), (String)"Visa");
        Assertions.assertFalse((boolean)validator.isValid(VALID_SHORT_VISA), (String)"Visa Short");
    }

    @Test
    void testMastercardUsingSeparators() {
        String masterCardRegExSep = "^(5[1-5]\\d{2})(?:[- ])?(\\d{4})(?:[- ])?(\\d{4})(?:[- ])?(\\d{4})$";
        CodeValidator validator = new CodeValidator("^(5[1-5]\\d{2})(?:[- ])?(\\d{4})(?:[- ])?(\\d{4})(?:[- ])?(\\d{4})$", LuhnCheckDigit.LUHN_CHECK_DIGIT);
        RegexValidator regex = validator.getRegexValidator();
        Assertions.assertEquals((Object)"5134567890123456", (Object)regex.validate("5134567890123456"), (String)"Number");
        Assertions.assertEquals((Object)"5134567890123456", (Object)regex.validate("5134-5678-9012-3456"), (String)"Hyphen");
        Assertions.assertEquals((Object)"5134567890123456", (Object)regex.validate("5134 5678 9012 3456"), (String)"Space");
        Assertions.assertEquals((Object)"5134567890123456", (Object)regex.validate("5134-5678 9012-3456"), (String)"MixedA");
        Assertions.assertEquals((Object)"5134567890123456", (Object)regex.validate("5134 5678-9012 3456"), (String)"MixedB");
        Assertions.assertFalse((boolean)regex.isValid("5134.5678.9012.3456"), (String)"Invalid Separator A");
        Assertions.assertFalse((boolean)regex.isValid("5134_5678_9012_3456"), (String)"Invalid Separator B");
        Assertions.assertFalse((boolean)regex.isValid("513-45678-9012-3456"), (String)"Invalid Grouping A");
        Assertions.assertFalse((boolean)regex.isValid("5134-567-89012-3456"), (String)"Invalid Grouping B");
        Assertions.assertFalse((boolean)regex.isValid("5134-5678-901-23456"), (String)"Invalid Grouping C");
        Assertions.assertEquals((Object)"5500000000000004", (Object)validator.validate("5500-0000-0000-0004"), (String)"Valid-A");
        Assertions.assertEquals((Object)"5424000000000015", (Object)validator.validate("5424 0000 0000 0015"), (String)"Valid-B");
        Assertions.assertEquals((Object)"5301250070000191", (Object)validator.validate("5301-250070000191"), (String)"Valid-C");
        Assertions.assertEquals((Object)"5123456789012346", (Object)validator.validate("5123456789012346"), (String)"Valid-D");
    }

    @Test
    void testMastercardValidator() {
        CodeValidator validator = CreditCardValidator.MASTERCARD_VALIDATOR;
        RegexValidator regex = validator.getRegexValidator();
        Assertions.assertFalse((boolean)regex.isValid("513456789012"), (String)"Length 12");
        Assertions.assertFalse((boolean)regex.isValid("5134567890123"), (String)"Length 13");
        Assertions.assertFalse((boolean)regex.isValid("51345678901234"), (String)"Length 14");
        Assertions.assertFalse((boolean)regex.isValid("513456789012345"), (String)"Length 15");
        Assertions.assertTrue((boolean)regex.isValid("5134567890123456"), (String)"Length 16");
        Assertions.assertFalse((boolean)regex.isValid("51345678901234567"), (String)"Length 17");
        Assertions.assertFalse((boolean)regex.isValid("513456789012345678"), (String)"Length 18");
        Assertions.assertFalse((boolean)regex.isValid("4134567890123456"), (String)"Prefix 41");
        Assertions.assertFalse((boolean)regex.isValid("5034567890123456"), (String)"Prefix 50");
        Assertions.assertTrue((boolean)regex.isValid("5134567890123456"), (String)"Prefix 51");
        Assertions.assertTrue((boolean)regex.isValid("5234567890123456"), (String)"Prefix 52");
        Assertions.assertTrue((boolean)regex.isValid("5334567890123456"), (String)"Prefix 53");
        Assertions.assertTrue((boolean)regex.isValid("5434567890123456"), (String)"Prefix 54");
        Assertions.assertTrue((boolean)regex.isValid("5534567890123456"), (String)"Prefix 55");
        Assertions.assertFalse((boolean)regex.isValid("5634567890123456"), (String)"Prefix 56");
        Assertions.assertFalse((boolean)regex.isValid("6134567890123456"), (String)"Prefix 61");
        Assertions.assertFalse((boolean)regex.isValid("5134567x90123456"), (String)"Invalid Char");
        Assertions.assertTrue((boolean)regex.isValid(ERROR_MASTERCARD), (String)"Valid regex");
        Assertions.assertFalse((boolean)validator.isValid(ERROR_MASTERCARD), (String)"Invalid");
        Assertions.assertNull((Object)validator.validate(ERROR_MASTERCARD), (String)"validate()");
        Assertions.assertEquals((Object)VALID_MASTERCARD, (Object)validator.validate(VALID_MASTERCARD));
        Assertions.assertFalse((boolean)validator.isValid(VALID_AMEX), (String)"Amex");
        Assertions.assertFalse((boolean)validator.isValid(VALID_DINERS), (String)"Diners");
        Assertions.assertFalse((boolean)validator.isValid(VALID_DISCOVER), (String)"Discover");
        Assertions.assertTrue((boolean)validator.isValid(VALID_MASTERCARD), (String)"Mastercard");
        Assertions.assertFalse((boolean)validator.isValid(VALID_VISA), (String)"Visa");
        Assertions.assertFalse((boolean)validator.isValid(VALID_SHORT_VISA), (String)"Visa Short");
        Assertions.assertTrue((boolean)validator.isValid("5500000000000004"), (String)"Valid-A");
        Assertions.assertTrue((boolean)validator.isValid("5424000000000015"), (String)"Valid-B");
        Assertions.assertTrue((boolean)validator.isValid("5301250070000191"), (String)"Valid-C");
        Assertions.assertTrue((boolean)validator.isValid("5123456789012346"), (String)"Valid-D");
        Assertions.assertTrue((boolean)validator.isValid("5555555555554444"), (String)"Valid-E");
        RegexValidator rev = validator.getRegexValidator();
        String pad = "0000000000";
        Assertions.assertFalse((boolean)rev.isValid("2220990000000000"), (String)"222099");
        for (int i = 222100; i <= 272099; ++i) {
            String j = Integer.toString(i) + "0000000000";
            Assertions.assertTrue((boolean)rev.isValid(j), (String)j);
        }
        Assertions.assertFalse((boolean)rev.isValid("2721000000000000"), (String)"272100");
    }

    @Test
    void testRangeGenerator() {
        CreditCardValidator ccv = new CreditCardValidator(new CodeValidator[]{CreditCardValidator.AMEX_VALIDATOR, CreditCardValidator.VISA_VALIDATOR, CreditCardValidator.MASTERCARD_VALIDATOR, CreditCardValidator.DISCOVER_VALIDATOR}, new CreditCardValidator.CreditCardRange[]{new CreditCardValidator.CreditCardRange("300", "305", 14, 14), new CreditCardValidator.CreditCardRange("3095", null, 14, 14), new CreditCardValidator.CreditCardRange("36", null, 14, 14), new CreditCardValidator.CreditCardRange("38", "39", 14, 14)});
        for (String s : VALID_CARDS) {
            Assertions.assertTrue((boolean)ccv.isValid(s), (String)s);
        }
        for (String s : ERROR_CARDS) {
            Assertions.assertFalse((boolean)ccv.isValid(s), (String)s);
        }
    }

    @Test
    void testRangeGeneratorNoLuhn() {
        CodeValidator cv = CreditCardValidator.createRangeValidator((CreditCardValidator.CreditCardRange[])new CreditCardValidator.CreditCardRange[]{new CreditCardValidator.CreditCardRange("1", null, 6, 7), new CreditCardValidator.CreditCardRange("644", "65", 8, 8)}, null);
        Assertions.assertTrue((boolean)cv.isValid("1990000"));
        Assertions.assertTrue((boolean)cv.isValid("199000"));
        Assertions.assertFalse((boolean)cv.isValid("000000"));
        Assertions.assertFalse((boolean)cv.isValid("099999"));
        Assertions.assertFalse((boolean)cv.isValid("200000"));
        Assertions.assertFalse((boolean)cv.isValid("64399999"));
        Assertions.assertTrue((boolean)cv.isValid("64400000"));
        Assertions.assertTrue((boolean)cv.isValid("64900000"));
        Assertions.assertTrue((boolean)cv.isValid("65000000"));
        Assertions.assertTrue((boolean)cv.isValid("65999999"));
        Assertions.assertFalse((boolean)cv.isValid("66000000"));
    }

    @Test
    void testValidLength() {
        Assertions.assertTrue((boolean)CreditCardValidator.validLength((int)14, (CreditCardValidator.CreditCardRange)new CreditCardValidator.CreditCardRange("", "", 14, 14)));
        Assertions.assertFalse((boolean)CreditCardValidator.validLength((int)15, (CreditCardValidator.CreditCardRange)new CreditCardValidator.CreditCardRange("", "", 14, 14)));
        Assertions.assertFalse((boolean)CreditCardValidator.validLength((int)13, (CreditCardValidator.CreditCardRange)new CreditCardValidator.CreditCardRange("", "", 14, 14)));
        Assertions.assertFalse((boolean)CreditCardValidator.validLength((int)14, (CreditCardValidator.CreditCardRange)new CreditCardValidator.CreditCardRange("", "", 15, 17)));
        Assertions.assertTrue((boolean)CreditCardValidator.validLength((int)15, (CreditCardValidator.CreditCardRange)new CreditCardValidator.CreditCardRange("", "", 15, 17)));
        Assertions.assertTrue((boolean)CreditCardValidator.validLength((int)16, (CreditCardValidator.CreditCardRange)new CreditCardValidator.CreditCardRange("", "", 15, 17)));
        Assertions.assertTrue((boolean)CreditCardValidator.validLength((int)17, (CreditCardValidator.CreditCardRange)new CreditCardValidator.CreditCardRange("", "", 15, 17)));
        Assertions.assertFalse((boolean)CreditCardValidator.validLength((int)18, (CreditCardValidator.CreditCardRange)new CreditCardValidator.CreditCardRange("", "", 15, 17)));
        Assertions.assertFalse((boolean)CreditCardValidator.validLength((int)14, (CreditCardValidator.CreditCardRange)new CreditCardValidator.CreditCardRange("", "", new int[]{15, 17})));
        Assertions.assertTrue((boolean)CreditCardValidator.validLength((int)15, (CreditCardValidator.CreditCardRange)new CreditCardValidator.CreditCardRange("", "", new int[]{15, 17})));
        Assertions.assertFalse((boolean)CreditCardValidator.validLength((int)16, (CreditCardValidator.CreditCardRange)new CreditCardValidator.CreditCardRange("", "", new int[]{15, 17})));
        Assertions.assertTrue((boolean)CreditCardValidator.validLength((int)17, (CreditCardValidator.CreditCardRange)new CreditCardValidator.CreditCardRange("", "", new int[]{15, 17})));
        Assertions.assertFalse((boolean)CreditCardValidator.validLength((int)18, (CreditCardValidator.CreditCardRange)new CreditCardValidator.CreditCardRange("", "", new int[]{15, 17})));
    }

    @Test
    void testVisaOption() {
        CreditCardValidator validator = new CreditCardValidator(2L);
        Assertions.assertFalse((boolean)validator.isValid(ERROR_VISA), (String)"Invalid");
        Assertions.assertFalse((boolean)validator.isValid(ERROR_SHORT_VISA), (String)"Invalid-S");
        Assertions.assertNull((Object)validator.validate(ERROR_VISA), (String)"validate()");
        Assertions.assertEquals((Object)VALID_VISA, (Object)validator.validate(VALID_VISA));
        Assertions.assertEquals((Object)VALID_SHORT_VISA, (Object)validator.validate(VALID_SHORT_VISA));
        Assertions.assertFalse((boolean)validator.isValid(VALID_AMEX), (String)"Amex");
        Assertions.assertFalse((boolean)validator.isValid(VALID_DINERS), (String)"Diners");
        Assertions.assertFalse((boolean)validator.isValid(VALID_DISCOVER), (String)"Discover");
        Assertions.assertFalse((boolean)validator.isValid(VALID_MASTERCARD), (String)"Mastercard");
        Assertions.assertTrue((boolean)validator.isValid(VALID_VISA), (String)"Visa");
        Assertions.assertTrue((boolean)validator.isValid(VALID_SHORT_VISA), (String)"Visa Short");
    }

    @Test
    void testVisaValidator() {
        CodeValidator validator = CreditCardValidator.VISA_VALIDATOR;
        RegexValidator regex = validator.getRegexValidator();
        Assertions.assertFalse((boolean)regex.isValid("423456789012"), (String)"Length 12");
        Assertions.assertTrue((boolean)regex.isValid("4234567890123"), (String)"Length 13");
        Assertions.assertFalse((boolean)regex.isValid("42345678901234"), (String)"Length 14");
        Assertions.assertFalse((boolean)regex.isValid("423456789012345"), (String)"Length 15");
        Assertions.assertTrue((boolean)regex.isValid("4234567890123456"), (String)"Length 16");
        Assertions.assertFalse((boolean)regex.isValid("42345678901234567"), (String)"Length 17");
        Assertions.assertFalse((boolean)regex.isValid("423456789012345678"), (String)"Length 18");
        Assertions.assertFalse((boolean)regex.isValid("3234567890123"), (String)"Invalid Pref-A");
        Assertions.assertFalse((boolean)regex.isValid("3234567890123456"), (String)"Invalid Pref-B");
        Assertions.assertFalse((boolean)regex.isValid("4234567x90123"), (String)"Invalid Char-A");
        Assertions.assertFalse((boolean)regex.isValid("4234567x90123456"), (String)"Invalid Char-B");
        Assertions.assertTrue((boolean)regex.isValid(ERROR_VISA), (String)"Valid regex");
        Assertions.assertTrue((boolean)regex.isValid(ERROR_SHORT_VISA), (String)"Valid regex-S");
        Assertions.assertFalse((boolean)validator.isValid(ERROR_VISA), (String)"Invalid");
        Assertions.assertFalse((boolean)validator.isValid(ERROR_SHORT_VISA), (String)"Invalid-S");
        Assertions.assertNull((Object)validator.validate(ERROR_VISA), (String)"validate()");
        Assertions.assertEquals((Object)VALID_VISA, (Object)validator.validate(VALID_VISA));
        Assertions.assertEquals((Object)VALID_SHORT_VISA, (Object)validator.validate(VALID_SHORT_VISA));
        Assertions.assertFalse((boolean)validator.isValid(VALID_AMEX), (String)"Amex");
        Assertions.assertFalse((boolean)validator.isValid(VALID_DINERS), (String)"Diners");
        Assertions.assertFalse((boolean)validator.isValid(VALID_DISCOVER), (String)"Discover");
        Assertions.assertFalse((boolean)validator.isValid(VALID_MASTERCARD), (String)"Mastercard");
        Assertions.assertTrue((boolean)validator.isValid(VALID_VISA), (String)"Visa");
        Assertions.assertTrue((boolean)validator.isValid(VALID_SHORT_VISA), (String)"Visa Short");
        Assertions.assertTrue((boolean)validator.isValid("4111111111111111"), (String)"Valid-A");
        Assertions.assertTrue((boolean)validator.isValid("4543059999999982"), (String)"Valid-C");
        Assertions.assertTrue((boolean)validator.isValid("4462000000000003"), (String)"Valid-B");
        Assertions.assertTrue((boolean)validator.isValid("4508750000000009"), (String)"Valid-D");
        Assertions.assertTrue((boolean)validator.isValid("4012888888881881"), (String)"Valid-E");
    }

    @Test
    void testVPayOption() {
        CreditCardValidator validator = new CreditCardValidator(32L);
        Assertions.assertTrue((boolean)validator.isValid(VALID_VPAY), (String)"Valid");
        Assertions.assertTrue((boolean)validator.isValid(VALID_VPAY2), (String)"Valid");
        Assertions.assertFalse((boolean)validator.isValid(ERROR_VPAY), (String)"Invalid");
        Assertions.assertEquals((Object)VALID_VPAY, (Object)validator.validate(VALID_VPAY));
        Assertions.assertEquals((Object)VALID_VPAY2, (Object)validator.validate(VALID_VPAY2));
        Assertions.assertFalse((boolean)validator.isValid(VALID_AMEX), (String)"Amex");
        Assertions.assertFalse((boolean)validator.isValid(VALID_DINERS), (String)"Diners");
        Assertions.assertFalse((boolean)validator.isValid(VALID_DISCOVER), (String)"Discover");
        Assertions.assertFalse((boolean)validator.isValid(VALID_MASTERCARD), (String)"Mastercard");
        Assertions.assertTrue((boolean)validator.isValid(VALID_VISA), (String)"Visa");
        Assertions.assertTrue((boolean)validator.isValid(VALID_SHORT_VISA), (String)"Visa Short");
    }
}

