/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.arrays;

import org.apache.commons.numbers.arrays.UpdatingInterval;

final class KeyUpdatingInterval
implements UpdatingInterval {
    private static final int SCAN_SIZE = 256;
    private final int[] keys;
    private int l;
    private int r;

    KeyUpdatingInterval(int[] indices, int n) {
        this(indices, 0, n - 1);
    }

    private KeyUpdatingInterval(int[] indices, int l, int r) {
        this.keys = indices;
        this.l = l;
        this.r = r;
    }

    @Override
    public int left() {
        return this.keys[this.l];
    }

    @Override
    public int right() {
        return this.keys[this.r];
    }

    @Override
    public int updateLeft(int k) {
        int i = this.l;
        while (this.keys[++i] < k) {
        }
        this.l = i;
        return this.keys[i];
    }

    @Override
    public int updateRight(int k) {
        int i = this.r;
        while (this.keys[--i] > k) {
        }
        this.r = i;
        return this.keys[i];
    }

    @Override
    public UpdatingInterval splitLeft(int ka, int kb) {
        int i;
        if (this.r - this.l < 256) {
            i = this.r;
            while (this.keys[--i] > kb) {
            }
        } else {
            i = KeyUpdatingInterval.searchLessOrEqual(this.keys, this.l, this.r, kb);
        }
        int lowerLeft = this.l;
        this.l = i + 1;
        while (this.keys[i] >= ka) {
            --i;
        }
        return new KeyUpdatingInterval(this.keys, lowerLeft, i);
    }

    int size() {
        return this.r - this.l + 1;
    }

    static int searchLessOrEqual(int[] a, int left, int right, int k) {
        int l = left;
        int r = right;
        while (l <= r) {
            int m = l + r >>> 1;
            int v = a[m];
            if (v < k) {
                l = m + 1;
                continue;
            }
            if (v > k) {
                r = m - 1;
                continue;
            }
            return m;
        }
        return r;
    }
}

