/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.combinatorics;

import org.apache.commons.numbers.combinatorics.BinomialCoefficient;
import org.apache.commons.numbers.combinatorics.CombinatoricsException;
import org.apache.commons.numbers.combinatorics.Factorial;

public final class Stirling {
    private static final String S1_ERROR_FORMAT = "s(n=%d, k=%d)";
    private static final String S2_ERROR_FORMAT = "S(n=%d, k=%d)";
    private static final int S1_OVERFLOW_K_EQUALS_1 = 21;
    private static final int S1_OVERFLOW_K_EQUALS_NM2 = 92682;
    private static final int S1_OVERFLOW_K_EQUALS_NM3 = 2761;
    private static final int S2_OVERFLOW_K_EQUALS_NM2 = 92683;
    private static final int S2_OVERFLOW_K_EQUALS_NM3 = 2762;

    private Stirling() {
    }

    public static long stirlingS1(int n, int k) {
        int n0;
        Stirling.checkArguments(n, k);
        if (n < 21) {
            return StirlingS1Cache.S1[n][k];
        }
        if (k == 0) {
            return 0L;
        }
        if (k == n) {
            return 1L;
        }
        if (k == 1) {
            Stirling.checkN(n, k, 21, S1_ERROR_FORMAT);
            return Factorial.value(n - 1);
        }
        if (k == n - 1) {
            return -BinomialCoefficient.value(n, 2);
        }
        if (k == n - 2) {
            Stirling.checkN(n, k, 92682, S1_ERROR_FORMAT);
            return Stirling.productOver4(3L * (long)n - 1L, BinomialCoefficient.value(n, 3));
        }
        if (k == n - 3) {
            Stirling.checkN(n, k, 2761, S1_ERROR_FORMAT);
            return -BinomialCoefficient.value(n, 2) * BinomialCoefficient.value(n, 4);
        }
        int reduction = Math.min(n - 21, k - 2) + 1;
        int k0 = k - reduction;
        long sum = Stirling.stirlingS1(n0, k0);
        for (n0 = n - reduction; n0 < n; ++n0) {
            sum = Math.subtractExact(sum, Math.multiplyExact((long)n0, Stirling.stirlingS1(n0, ++k0)));
        }
        return sum;
    }

    public static long stirlingS2(int n, int k) {
        int n0;
        Stirling.checkArguments(n, k);
        if (n < 26) {
            return StirlingS2Cache.S2[n][k];
        }
        if (k == 0) {
            return 0L;
        }
        if (k == 1 || k == n) {
            return 1L;
        }
        if (k == 2) {
            Stirling.checkN(n, k, 64, S2_ERROR_FORMAT);
            return (1L << n - 1) - 1L;
        }
        if (k == n - 1) {
            return BinomialCoefficient.value(n, 2);
        }
        if (k == n - 2) {
            Stirling.checkN(n, k, 92683, S2_ERROR_FORMAT);
            return Stirling.productOver4(3L * (long)n - 5L, BinomialCoefficient.value(n, 3));
        }
        if (k == n - 3) {
            Stirling.checkN(n, k, 2762, S2_ERROR_FORMAT);
            return BinomialCoefficient.value(n - 2, 2) * BinomialCoefficient.value(n, 4);
        }
        int reduction = Math.min(n - 26, k - 3) + 1;
        int k0 = k - reduction;
        long sum = Stirling.stirlingS2(n0, k0);
        for (n0 = n - reduction; n0 < n; ++n0) {
            sum = Math.addExact(Math.multiplyExact((long)(++k0), Stirling.stirlingS2(n0, k0)), sum);
        }
        return sum;
    }

    private static void checkArguments(int n, int k) {
        if ((n | k | n - k) < 0) {
            if (n < 0) {
                throw new CombinatoricsException("Number %s is negative", n);
            }
            throw new CombinatoricsException("Number %s is out of range [%s, %s]", k, 0, n);
        }
    }

    private static void checkN(int n, int k, int threshold, String msgFormat) {
        if (n > threshold) {
            throw new ArithmeticException(String.format(msgFormat, n, k));
        }
    }

    private static long productOver4(long a, long b) {
        return (b & 1L) == 0L ? (b >>> 1) * a >>> 1 : (a >>> 1) * b >>> 1;
    }

    private static final class StirlingS2Cache {
        static final int MAX_N = 26;
        static final long[][] S2 = new long[26][];

        private StirlingS2Cache() {
        }

        static {
            StirlingS2Cache.S2[0] = new long[]{1L};
            for (int n = 1; n < S2.length; ++n) {
                StirlingS2Cache.S2[n] = new long[n + 1];
                StirlingS2Cache.S2[n][0] = 0L;
                StirlingS2Cache.S2[n][1] = 1L;
                StirlingS2Cache.S2[n][n] = 1L;
                for (int k = 2; k < n; ++k) {
                    StirlingS2Cache.S2[n][k] = (long)k * S2[n - 1][k] + S2[n - 1][k - 1];
                }
            }
        }
    }

    private static final class StirlingS1Cache {
        static final int MAX_N = 21;
        static final long[][] S1 = new long[21][];

        private StirlingS1Cache() {
        }

        static {
            StirlingS1Cache.S1[0] = new long[]{1L};
            StirlingS1Cache.S1[1] = new long[]{0L, 1L};
            for (int n = 2; n < S1.length; ++n) {
                StirlingS1Cache.S1[n] = new long[n + 1];
                StirlingS1Cache.S1[n][0] = 0L;
                StirlingS1Cache.S1[n][n] = 1L;
                for (int k = 1; k < n; ++k) {
                    StirlingS1Cache.S1[n][k] = S1[n - 1][k - 1] - (long)(n - 1) * S1[n - 1][k];
                }
            }
        }
    }
}

