/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.combinatorics;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.numbers.combinatorics.BinomialCoefficient;
import org.apache.commons.numbers.combinatorics.CombinatoricsException;
import org.apache.commons.numbers.core.ArithmeticUtils;

public final class Combinations
implements Iterable<int[]> {
    private final int n;
    private final int k;

    private Combinations(int n, int k) {
        BinomialCoefficient.checkBinomial(n, k);
        this.n = n;
        this.k = k;
    }

    public static Combinations of(int n, int k) {
        return new Combinations(n, k);
    }

    public int getN() {
        return this.n;
    }

    public int getK() {
        return this.k;
    }

    @Override
    public Iterator<int[]> iterator() {
        return this.k == 0 || this.k == this.n ? new SingletonIterator(this.k) : new LexicographicIterator(this.n, this.k);
    }

    public Comparator<int[]> comparator() {
        return new LexicographicComparator(this.n, this.k);
    }

    private static class LexicographicComparator
    implements Comparator<int[]>,
    Serializable {
        private static final long serialVersionUID = 20170520L;
        private final int n;
        private final int k;

        LexicographicComparator(int n, int k) {
            this.n = n;
            this.k = k;
        }

        @Override
        public int compare(int[] c1, int[] c2) {
            if (c1.length != this.k) {
                throw new CombinatoricsException("Expected %s but was %s", this.k, c1.length);
            }
            if (c2.length != this.k) {
                throw new CombinatoricsException("Expected %s but was %s", this.k, c2.length);
            }
            int[] c1s = Arrays.copyOf(c1, this.k);
            int[] c2s = Arrays.copyOf(c2, this.k);
            Arrays.sort(c1s);
            Arrays.sort(c2s);
            long v1 = this.lexNorm(c1s);
            long v2 = this.lexNorm(c2s);
            return Long.compare(v1, v2);
        }

        private long lexNorm(int[] c) {
            long ret = 0L;
            for (int i = 0; i < c.length; ++i) {
                int digit = c[i];
                if (digit < 0 || digit >= this.n) {
                    throw new CombinatoricsException("Number %s is out of range [%s, %s]", digit, 0, this.n - 1);
                }
                ret += (long)c[i] * ArithmeticUtils.pow((long)this.n, (int)i);
            }
            return ret;
        }
    }

    private static class SingletonIterator
    implements Iterator<int[]> {
        private final int n;
        private boolean more = true;

        SingletonIterator(int n) {
            this.n = n;
        }

        @Override
        public boolean hasNext() {
            return this.more;
        }

        @Override
        public int[] next() {
            if (this.more) {
                this.more = false;
                int[] s = new int[this.n];
                for (int i = 0; i < this.n; ++i) {
                    s[i] = i;
                }
                return s;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class LexicographicIterator
    implements Iterator<int[]> {
        private final int k;
        private final int[] c;
        private boolean more = true;
        private int j;

        LexicographicIterator(int n, int k) {
            this.k = k;
            this.c = new int[k + 3];
            for (int i = 1; i <= k; ++i) {
                this.c[i] = i - 1;
            }
            this.c[k + 1] = n;
            this.c[k + 2] = 0;
            this.j = k;
        }

        @Override
        public boolean hasNext() {
            return this.more;
        }

        @Override
        public int[] next() {
            if (!this.more) {
                throw new NoSuchElementException();
            }
            int[] ret = new int[this.k];
            System.arraycopy(this.c, 1, ret, 0, this.k);
            int x = 0;
            if (this.j > 0) {
                this.c[this.j] = x = this.j;
                --this.j;
                return ret;
            }
            if (this.c[1] + 1 < this.c[2]) {
                this.c[1] = this.c[1] + 1;
                return ret;
            }
            this.j = 2;
            boolean stepDone = false;
            while (!stepDone) {
                this.c[this.j - 1] = this.j - 2;
                x = this.c[this.j] + 1;
                if (x == this.c[this.j + 1]) {
                    ++this.j;
                    continue;
                }
                stepDone = true;
            }
            if (this.j > this.k) {
                this.more = false;
                return ret;
            }
            this.c[this.j] = x;
            --this.j;
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

