/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.arrays;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

public enum SortInPlace {
    ASCENDING((o1, o2) -> Double.compare(o1.key(), o2.key())),
    DESCENDING((o1, o2) -> Double.compare(o2.key(), o1.key()));

    private final Comparator<PairDoubleInteger> comparator;

    private SortInPlace(Comparator<PairDoubleInteger> comparator) {
        this.comparator = comparator;
    }

    public void apply(double[] x, double[] ... yList) {
        int yListLen = yList.length;
        int len = x.length;
        for (int j = 0; j < yListLen; ++j) {
            double[] y = yList[j];
            if (y.length == len) continue;
            throw new IllegalArgumentException("Size mismatch: " + y.length + " != " + len);
        }
        ArrayList<PairDoubleInteger> list = new ArrayList<PairDoubleInteger>(len);
        for (int i = 0; i < len; ++i) {
            list.add(new PairDoubleInteger(x[i], i));
        }
        Collections.sort(list, this.comparator);
        int[] indices = new int[len];
        for (int i = 0; i < len; ++i) {
            PairDoubleInteger e = (PairDoubleInteger)list.get(i);
            x[i] = e.key();
            indices[i] = e.value();
        }
        for (int j = 0; j < yListLen; ++j) {
            double[] yInPlace = yList[j];
            double[] yOrig = Arrays.copyOf(yInPlace, len);
            for (int i = 0; i < len; ++i) {
                yInPlace[i] = yOrig[indices[i]];
            }
        }
    }

    private static class PairDoubleInteger {
        private final double key;
        private final int value;

        PairDoubleInteger(double key, int value) {
            this.key = key;
            this.value = value;
        }

        double key() {
            return this.key;
        }

        int value() {
            return this.value;
        }
    }
}

