/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.vector.jacobian;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathUnsupportedOperationException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.optim.InitialGuess;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointVectorValuePair;
import org.apache.commons.math3.optim.SimpleBounds;
import org.apache.commons.math3.optim.nonlinear.vector.ModelFunction;
import org.apache.commons.math3.optim.nonlinear.vector.ModelFunctionJacobian;
import org.apache.commons.math3.optim.nonlinear.vector.Target;
import org.apache.commons.math3.optim.nonlinear.vector.Weight;
import org.apache.commons.math3.optim.nonlinear.vector.jacobian.AbstractLeastSquaresOptimizer;
import org.apache.commons.math3.optim.nonlinear.vector.jacobian.AbstractLeastSquaresOptimizerAbstractTest;
import org.apache.commons.math3.optim.nonlinear.vector.jacobian.CircleProblem;
import org.apache.commons.math3.optim.nonlinear.vector.jacobian.CircleVectorial;
import org.apache.commons.math3.optim.nonlinear.vector.jacobian.LevenbergMarquardtOptimizer;
import org.apache.commons.math3.optim.nonlinear.vector.jacobian.RandomCirclePointGenerator;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class LevenbergMarquardtOptimizerTest
extends AbstractLeastSquaresOptimizerAbstractTest {
    public AbstractLeastSquaresOptimizer createOptimizer() {
        return new LevenbergMarquardtOptimizer();
    }

    @Test(expected=MathUnsupportedOperationException.class)
    public void testConstraintsUnsupported() {
        this.createOptimizer().optimize(new OptimizationData[]{new MaxEval(100), new Target(new double[]{2.0}), new Weight(new double[]{1.0}), new InitialGuess(new double[]{1.0, 2.0}), new SimpleBounds(new double[]{-10.0, 0.0}, new double[]{20.0, 30.0})});
    }

    @Test(expected=SingularMatrixException.class)
    public void testNonInvertible() {
        AbstractLeastSquaresOptimizerAbstractTest.LinearProblem problem = new AbstractLeastSquaresOptimizerAbstractTest.LinearProblem(new double[][]{{1.0, 2.0, -3.0}, {2.0, 1.0, 3.0}, {-3.0, 0.0, -9.0}}, new double[]{1.0, 1.0, 1.0});
        AbstractLeastSquaresOptimizer optimizer = this.createOptimizer();
        PointVectorValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(100), problem.getModelFunction(), problem.getModelFunctionJacobian(), problem.getTarget(), new Weight(new double[]{1.0, 1.0, 1.0}), new InitialGuess(new double[]{0.0, 0.0, 0.0})});
        Assert.assertTrue((FastMath.sqrt((double)optimizer.getTargetSize()) * optimizer.getRMS() > 0.6 ? 1 : 0) != 0);
        optimizer.computeCovariances(optimum.getPoint(), 1.5E-14);
    }

    @Test
    public void testControlParameters() {
        CircleVectorial circle = new CircleVectorial();
        circle.addPoint(30.0, 68.0);
        circle.addPoint(50.0, -6.0);
        circle.addPoint(110.0, -20.0);
        circle.addPoint(35.0, 15.0);
        circle.addPoint(45.0, 97.0);
        this.checkEstimate(circle.getModelFunction(), circle.getModelFunctionJacobian(), 0.1, 10, 1.0E-14, 1.0E-16, 1.0E-10, false);
        this.checkEstimate(circle.getModelFunction(), circle.getModelFunctionJacobian(), 0.1, 10, 1.0E-15, 1.0E-17, 1.0E-10, true);
        this.checkEstimate(circle.getModelFunction(), circle.getModelFunctionJacobian(), 0.1, 5, 1.0E-15, 1.0E-16, 1.0E-10, true);
        circle.addPoint(300.0, -300.0);
        this.checkEstimate(circle.getModelFunction(), circle.getModelFunctionJacobian(), 0.1, 20, 1.0E-18, 1.0E-16, 1.0E-10, true);
    }

    private void checkEstimate(ModelFunction problem, ModelFunctionJacobian problemJacobian, double initialStepBoundFactor, int maxCostEval, double costRelativeTolerance, double parRelativeTolerance, double orthoTolerance, boolean shouldFail) {
        try {
            LevenbergMarquardtOptimizer optimizer = new LevenbergMarquardtOptimizer(initialStepBoundFactor, costRelativeTolerance, parRelativeTolerance, orthoTolerance, Precision.SAFE_MIN);
            optimizer.optimize(new OptimizationData[]{new MaxEval(maxCostEval), problem, problemJacobian, new Target(new double[]{0.0, 0.0, 0.0, 0.0, 0.0}), new Weight(new double[]{1.0, 1.0, 1.0, 1.0, 1.0}), new InitialGuess(new double[]{98.68, 47.345})});
            Assert.assertTrue((!shouldFail ? 1 : 0) != 0);
        }
        catch (DimensionMismatchException ee) {
            Assert.assertTrue((boolean)shouldFail);
        }
        catch (TooManyEvaluationsException ee) {
            Assert.assertTrue((boolean)shouldFail);
        }
    }

    @Test
    public void testBevington() {
        int i;
        double[][] dataPoints = new double[][]{{15.0, 30.0, 45.0, 60.0, 75.0, 90.0, 105.0, 120.0, 135.0, 150.0, 165.0, 180.0, 195.0, 210.0, 225.0, 240.0, 255.0, 270.0, 285.0, 300.0, 315.0, 330.0, 345.0, 360.0, 375.0, 390.0, 405.0, 420.0, 435.0, 450.0, 465.0, 480.0, 495.0, 510.0, 525.0, 540.0, 555.0, 570.0, 585.0, 600.0, 615.0, 630.0, 645.0, 660.0, 675.0, 690.0, 705.0, 720.0, 735.0, 750.0, 765.0, 780.0, 795.0, 810.0, 825.0, 840.0, 855.0, 870.0, 885.0}, {775.0, 479.0, 380.0, 302.0, 185.0, 157.0, 137.0, 119.0, 110.0, 89.0, 74.0, 61.0, 66.0, 68.0, 48.0, 54.0, 51.0, 46.0, 55.0, 29.0, 28.0, 37.0, 49.0, 26.0, 35.0, 29.0, 31.0, 24.0, 25.0, 35.0, 24.0, 30.0, 26.0, 28.0, 21.0, 18.0, 20.0, 27.0, 17.0, 17.0, 14.0, 17.0, 24.0, 11.0, 22.0, 17.0, 12.0, 10.0, 13.0, 16.0, 9.0, 9.0, 14.0, 21.0, 17.0, 13.0, 12.0, 18.0, 10.0}};
        BevingtonProblem problem = new BevingtonProblem();
        int len = dataPoints[0].length;
        double[] weights = new double[len];
        for (int i2 = 0; i2 < len; ++i2) {
            problem.addPoint(dataPoints[0][i2], dataPoints[1][i2]);
            weights[i2] = 1.0 / dataPoints[1][i2];
        }
        LevenbergMarquardtOptimizer optimizer = new LevenbergMarquardtOptimizer();
        PointVectorValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(100), problem.getModelFunction(), problem.getModelFunctionJacobian(), new Target(dataPoints[1]), new Weight(weights), new InitialGuess(new double[]{10.0, 900.0, 80.0, 27.0, 225.0})});
        double[] solution = optimum.getPoint();
        double[] expectedSolution = new double[]{10.4, 958.3, 131.4, 33.9, 205.0};
        double[][] covarMatrix = optimizer.computeCovariances(solution, 1.0E-14);
        double[][] expectedCovarMatrix = new double[][]{{3.38, -3.69, 27.98, -2.34, -49.24}, {-3.69, 2492.26, 81.89, -69.21, -8.9}, {27.98, 81.89, 468.99, -44.22, -615.44}, {-2.34, -69.21, -44.22, 6.39, 53.8}, {-49.24, -8.9, -615.44, 53.8, 929.45}};
        int numParams = expectedSolution.length;
        for (i = 0; i < numParams; ++i) {
            double error = FastMath.sqrt((double)expectedCovarMatrix[i][i]);
            Assert.assertEquals((String)("Parameter " + i), (double)expectedSolution[i], (double)solution[i], (double)error);
        }
        for (i = 0; i < numParams; ++i) {
            for (int j = 0; j < numParams; ++j) {
                Assert.assertEquals((String)("Covariance matrix [" + i + "][" + j + "]"), (double)expectedCovarMatrix[i][j], (double)covarMatrix[i][j], (double)FastMath.abs((double)(0.1 * expectedCovarMatrix[i][j])));
            }
        }
    }

    @Test
    public void testCircleFitting2() {
        double xCenter = 123.456;
        double yCenter = 654.321;
        double xSigma = 10.0;
        double ySigma = 15.0;
        double radius = 111.111;
        long seed = 59421061L;
        RandomCirclePointGenerator factory = new RandomCirclePointGenerator(123.456, 654.321, 111.111, 10.0, 15.0, 59421061L);
        CircleProblem circle = new CircleProblem(10.0, 15.0);
        int numPoints = 10;
        for (Vector2D p : factory.generate(10)) {
            circle.addPoint(p.getX(), p.getY());
        }
        double[] init = new double[]{90.0, 659.0, 115.0};
        LevenbergMarquardtOptimizer optimizer = new LevenbergMarquardtOptimizer();
        PointVectorValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(100), circle.getModelFunction(), circle.getModelFunctionJacobian(), new Target(circle.target()), new Weight(circle.weight()), new InitialGuess(init)});
        double[] paramFound = optimum.getPoint();
        double[] asymptoticStandardErrorFound = optimizer.computeSigma(paramFound, 1.0E-14);
        Assert.assertEquals((double)123.456, (double)paramFound[0], (double)asymptoticStandardErrorFound[0]);
        Assert.assertEquals((double)654.321, (double)paramFound[1], (double)asymptoticStandardErrorFound[1]);
        Assert.assertEquals((double)111.111, (double)paramFound[2], (double)asymptoticStandardErrorFound[2]);
    }

    private static class BevingtonProblem {
        private List<Double> time = new ArrayList<Double>();
        private List<Double> count = new ArrayList<Double>();

        public void addPoint(double t, double c) {
            this.time.add(t);
            this.count.add(c);
        }

        public ModelFunction getModelFunction() {
            return new ModelFunction(new MultivariateVectorFunction(){

                public double[] value(double[] params) {
                    double[] values = new double[BevingtonProblem.this.time.size()];
                    for (int i = 0; i < values.length; ++i) {
                        double t = (Double)BevingtonProblem.this.time.get(i);
                        values[i] = params[0] + params[1] * FastMath.exp((double)(-t / params[3])) + params[2] * FastMath.exp((double)(-t / params[4]));
                    }
                    return values;
                }
            });
        }

        public ModelFunctionJacobian getModelFunctionJacobian() {
            return new ModelFunctionJacobian(new MultivariateMatrixFunction(){

                public double[][] value(double[] params) {
                    double[][] jacobian = new double[BevingtonProblem.this.time.size()][5];
                    for (int i = 0; i < jacobian.length; ++i) {
                        double t = (Double)BevingtonProblem.this.time.get(i);
                        jacobian[i][0] = 1.0;
                        double p3 = params[3];
                        double p4 = params[4];
                        double tOp3 = t / p3;
                        double tOp4 = t / p4;
                        jacobian[i][1] = FastMath.exp((double)(-tOp3));
                        jacobian[i][2] = FastMath.exp((double)(-tOp4));
                        jacobian[i][3] = params[1] * FastMath.exp((double)(-tOp3)) * tOp3 / p3;
                        jacobian[i][4] = params[2] * FastMath.exp((double)(-tOp4)) * tOp4 / p4;
                    }
                    return jacobian;
                }
            });
        }
    }
}

