/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArrayLiteralTest
extends JexlTestCase {
    public ArrayLiteralTest() {
        super("ArrayLiteralTest");
    }

    @Test
    public void testChangeThroughVariables() throws Exception {
        MapContext jc = new MapContext();
        JexlExpression e147 = this.JEXL.createExpression("quux = [one, two]");
        jc.set("one", (Object)1);
        jc.set("two", (Object)2);
        int[] o1 = (int[])e147.evaluate((JexlContext)jc);
        Assertions.assertEquals((int)1, (int)o1[0]);
        Assertions.assertEquals((int)2, (int)o1[1]);
        jc.set("one", (Object)10);
        jc.set("two", (Object)20);
        int[] o2 = (int[])e147.evaluate((JexlContext)jc);
        Assertions.assertEquals((int)10, (int)o2[0]);
        Assertions.assertEquals((int)20, (int)o2[1]);
    }

    @Test
    public void testEmptyArrayLiteral() throws Exception {
        MapContext jc = new MapContext();
        Object o = this.JEXL.createExpression("[]").evaluate((JexlContext)jc);
        Assertions.assertInstanceOf(Object[].class, (Object)o);
        Assertions.assertEquals((int)0, (int)((Object[])o).length);
        o = this.JEXL.createExpression("[...]").evaluate((JexlContext)jc);
        Assertions.assertInstanceOf(List.class, (Object)o);
        Assertions.assertEquals((int)0, (int)((List)o).size());
        Assertions.assertThrows(JexlException.Parsing.class, () -> this.JEXL.createExpression("[ , ]"));
        Assertions.assertThrows(JexlException.Parsing.class, () -> this.JEXL.createExpression("[ ... , ]"));
    }

    @Test
    public void testLiteralWithElipsis() throws Exception {
        JexlExpression e = this.JEXL.createExpression("[ 'foo' , 'bar', ... ]");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Object[] check = new Object[]{"foo", "bar"};
        Assertions.assertEquals(Arrays.asList(check), (Object)o);
        Assertions.assertEquals((int)2, (int)((List)o).size());
        Assertions.assertThrows(JexlException.Parsing.class, () -> this.JEXL.createExpression("[ 'foo' , 'bar', ... , ]"));
    }

    @Test
    public void testLiteralWithIntegers() throws Exception {
        JexlExpression e = this.JEXL.createExpression("[ 5 , 10 ]");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        int[] check = new int[]{5, 10};
        Assertions.assertArrayEquals((int[])check, (int[])((int[])o));
    }

    @Test
    public void testLiteralWithNulls() throws Exception {
        String[] exprs = new String[]{"[ null , 10 ]", "[ 10 , null ]", "[ 10 , null , 10]", "[ '10' , null ]", "[ null, '10' , null ]"};
        Object[][] checks = new Object[][]{{null, 10}, {10, null}, {10, null, 10}, {"10", null}, {null, "10", null}};
        MapContext jc = new MapContext();
        for (int t = 0; t < exprs.length; ++t) {
            JexlExpression e = this.JEXL.createExpression(exprs[t]);
            Object o = e.evaluate((JexlContext)jc);
            Assertions.assertArrayEquals((Object[])checks[t], (Object[])((Object[])o), (String)exprs[t]);
        }
    }

    @Test
    public void testLiteralWithNumbers() throws Exception {
        JexlExpression e = this.JEXL.createExpression("[ 5.0 , 10 ]");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Object[] check = new Object[]{5.0, 10};
        Assertions.assertArrayEquals((Object[])check, (Object[])((Object[])o));
        Assertions.assertTrue((o.getClass().isArray() && o.getClass().getComponentType().equals(Number.class) ? 1 : 0) != 0);
    }

    @Test
    public void testLiteralWithOneEntry() throws Exception {
        Object[] check = new Object[]{"foo"};
        List<String> sources = Arrays.asList("[ 'foo']", "[ 'foo' , ]");
        for (String src : sources) {
            JexlExpression e = this.JEXL.createExpression(src);
            Object o = e.evaluate(null);
            Assertions.assertArrayEquals((Object[])check, (Object[])((Object[])o));
        }
    }

    @Test
    public void testLiteralWithStrings() throws Exception {
        Object[] check = new Object[]{"foo", "bar"};
        List<String> sources = Arrays.asList("[ 'foo' , 'bar' ]", "[ 'foo' , 'bar', ]");
        for (String src : sources) {
            JexlExpression e = this.JEXL.createExpression(src);
            Object o = e.evaluate(null);
            Assertions.assertArrayEquals((Object[])check, (Object[])((Object[])o));
        }
    }

    @Test
    public void testNotEmptySimpleArrayLiteral() throws Exception {
        JexlExpression e = this.JEXL.createExpression("empty([ 'foo' , 'bar' ])");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Assertions.assertFalse((boolean)((Boolean)o));
    }

    @Test
    public void testNotestCallingMethodsOnNewMapLiteral() throws Exception {
        JexlExpression e = this.JEXL.createExpression("size({ 'foo' : 'bar' }.values())");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)1, (Object)o);
    }

    @Test
    public void testSizeOfSimpleArrayLiteral() throws Exception {
        JexlExpression e = this.JEXL.createExpression("size([ 'foo' , 'bar' ])");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)2, (Object)o);
    }
}

