/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlArithmetic;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlTestCase;
import org.apache.commons.jexl2.MapContext;

public class AssignTest
extends JexlTestCase {
    private static final JexlArithmetic ARITH = new JexlArithmetic(false);
    private static final JexlEngine ENGINE = new JexlEngine(null, ARITH, null, null);

    public AssignTest(String testName) {
        super(testName);
    }

    public void testAntish() throws Exception {
        Expression assign = ENGINE.createExpression("froboz.value = 10");
        Expression check = ENGINE.createExpression("froboz.value");
        MapContext jc = new MapContext();
        Object o = assign.evaluate((JexlContext)jc);
        AssignTest.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
        o = check.evaluate((JexlContext)jc);
        AssignTest.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
    }

    public void testAntishInteger() throws Exception {
        Expression assign = ENGINE.createExpression("froboz.0 = 10");
        Expression check = ENGINE.createExpression("froboz.0");
        MapContext jc = new MapContext();
        Object o = assign.evaluate((JexlContext)jc);
        AssignTest.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
        o = check.evaluate((JexlContext)jc);
        AssignTest.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
    }

    public void testBeanish() throws Exception {
        Expression assign = ENGINE.createExpression("froboz.value = 10");
        Expression check = ENGINE.createExpression("froboz.value");
        MapContext jc = new MapContext();
        Froboz froboz = new Froboz(-169);
        jc.set("froboz", (Object)froboz);
        Object o = assign.evaluate((JexlContext)jc);
        AssignTest.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
        o = check.evaluate((JexlContext)jc);
        AssignTest.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAmbiguous() throws Exception {
        Expression assign = ENGINE.createExpression("froboz.nosuchbean = 10");
        MapContext jc = new MapContext();
        Froboz froboz = new Froboz(-169);
        jc.set("froboz", (Object)froboz);
        Object o = null;
        try {
            o = assign.evaluate((JexlContext)jc);
        }
        catch (RuntimeException xrt) {
            String str = xrt.toString();
            AssignTest.assertTrue((boolean)str.contains("nosuchbean"));
            return;
        }
        finally {
            AssignTest.assertEquals((String)"Should have failed", null, (Object)o);
        }
    }

    public void testArray() throws Exception {
        Expression assign = ENGINE.createExpression("froboz[\"value\"] = 10");
        Expression check = ENGINE.createExpression("froboz[\"value\"]");
        MapContext jc = new MapContext();
        Froboz froboz = new Froboz(0);
        jc.set("froboz", (Object)froboz);
        Object o = assign.evaluate((JexlContext)jc);
        AssignTest.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
        o = check.evaluate((JexlContext)jc);
        AssignTest.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
    }

    public void testMore() throws Exception {
        MapContext jc = new MapContext();
        jc.set("quuxClass", Quux.class);
        Expression create = ENGINE.createExpression("quux = new(quuxClass, 'xuuq', 100)");
        Expression assign = ENGINE.createExpression("quux.froboz.value = 10");
        Expression check = ENGINE.createExpression("quux[\"froboz\"].value");
        Quux quux = (Quux)create.evaluate((JexlContext)jc);
        AssignTest.assertNotNull((String)"quux is null", (Object)quux);
        Object o = assign.evaluate((JexlContext)jc);
        AssignTest.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
        o = check.evaluate((JexlContext)jc);
        AssignTest.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
    }

    public void testUtil() throws Exception {
        Quux quux = (Quux)ENGINE.newInstance(Quux.class, new Object[]{"xuuq", 100});
        ENGINE.setProperty((Object)quux, "froboz.value", (Object)100);
        Object o = ENGINE.getProperty((Object)quux, "froboz.value");
        AssignTest.assertEquals((String)"Result is not 100", (Object)new Integer(100), (Object)o);
        ENGINE.setProperty((Object)quux, "['froboz'].value", (Object)1000);
        o = ENGINE.getProperty((Object)quux, "['froboz']['value']");
        AssignTest.assertEquals((String)"Result is not 1000", (Object)new Integer(1000), (Object)o);
    }

    static {
        ENGINE.setSilent(false);
    }

    public static class Quux {
        String str;
        Froboz froboz;

        public Quux(String str, int fro) {
            this.str = str;
            this.froboz = new Froboz(fro);
        }

        public Froboz getFroboz() {
            return this.froboz;
        }

        public void setFroboz(Froboz froboz) {
            this.froboz = froboz;
        }

        public String getStr() {
            return this.str;
        }

        public void setStr(String str) {
            this.str = str;
        }
    }

    public static class Froboz {
        int value;

        public Froboz(int v) {
            this.value = v;
        }

        public void setValue(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }
    }
}

