/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.io.function.IOIterator;
import org.apache.commons.io.function.IOPredicate;
import org.apache.commons.io.function.IORunnable;
import org.apache.commons.io.function.IOStream;
import org.apache.commons.io.function.TestConstants;
import org.apache.commons.io.function.TestUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IOStreamTest {
    private static final boolean AT_LEAST_JAVA_11 = SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11);
    private static final boolean AT_LEAST_JAVA_17 = SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17);

    IOStreamTest() {
    }

    private void compareAndSetIO(AtomicReference<String> ref, String expected, String update) throws IOException {
        TestUtils.compareAndSetThrowsIO(ref, expected, update);
    }

    private void compareAndSetRE(AtomicReference<String> ref, String expected, String update) {
        TestUtils.compareAndSetThrowsRE(ref, expected, update);
    }

    private void ioExceptionOnNull(Object test) throws IOException {
        if (test == null) {
            throw new IOException("Unexpected");
        }
    }

    @Test
    void testAdapt() {
        Assertions.assertEquals((long)0L, (long)IOStream.adapt((Stream)null).count());
        Assertions.assertEquals((long)0L, (long)IOStream.adapt(Stream.empty()).count());
        Assertions.assertEquals((long)1L, (long)IOStream.adapt(Stream.of("A")).count());
    }

    @Test
    void testAdaptAsParallel() {
        Assertions.assertEquals((long)0L, (long)((IOStream)IOStream.adapt((Stream)null).parallel()).count());
        Assertions.assertEquals((long)0L, (long)((IOStream)IOStream.adapt(Stream.empty()).parallel()).count());
        Assertions.assertEquals((long)1L, (long)((IOStream)IOStream.adapt(Stream.of("A")).parallel()).count());
    }

    @Test
    void testAdaptParallelAndCount() {
        IOStream adaptedObj = IOStream.adapt((Stream)((Stream)Stream.empty().parallel()));
        Assertions.assertTrue((boolean)adaptedObj.isParallel());
        Assertions.assertEquals((long)0L, (long)adaptedObj.count());
        IOStream adaptedStr = IOStream.adapt((Stream)((Stream)Stream.of("A").parallel()));
        Assertions.assertTrue((boolean)adaptedObj.isParallel());
        Assertions.assertEquals((long)1L, (long)adaptedStr.count());
    }

    @Test
    void testAllMatch() throws IOException {
        Assertions.assertThrows(IOException.class, () -> IOStream.of((Object[])new String[]{"A", "B"}).allMatch(TestConstants.THROWING_IO_PREDICATE));
        Assertions.assertTrue((boolean)IOStream.of((Object[])new String[]{"A", "B"}).allMatch(IOPredicate.alwaysTrue()));
        Assertions.assertFalse((boolean)IOStream.of((Object[])new String[]{"A", "B"}).allMatch(IOPredicate.alwaysFalse()));
    }

    @Test
    void testAnyMatch() throws IOException {
        Assertions.assertThrows(IOException.class, () -> IOStream.of((Object[])new String[]{"A", "B"}).anyMatch(TestConstants.THROWING_IO_PREDICATE));
        Assertions.assertTrue((boolean)IOStream.of((Object[])new String[]{"A", "B"}).anyMatch(IOPredicate.alwaysTrue()));
        Assertions.assertFalse((boolean)IOStream.of((Object[])new String[]{"A", "B"}).anyMatch(IOPredicate.alwaysFalse()));
    }

    @Test
    void testClose() {
        IOStream.of((Object[])new String[]{"A", "B"}).close();
    }

    @Test
    void testCollectCollectorOfQsuperTAR() {
        IOStream.of((Object[])new String[]{"A", "B"}).collect(Collectors.toList());
    }

    @Test
    void testCollectSupplierOfRBiConsumerOfRQsuperTBiConsumerOfRR() throws IOException {
        IOStream.of((Object[])new String[]{"A", "B"}).collect(() -> "A", (t, u) -> {}, (t, u) -> {});
        Assertions.assertEquals((Object)"AB", (Object)Stream.of("A", "B").collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString());
        Assertions.assertEquals((Object)"AB", (Object)((StringBuilder)IOStream.of((Object[])new String[]{"A", "B"}).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append)).toString());
        Assertions.assertThrows(IOException.class, () -> IOStream.of((Object[])new String[]{"A", "B"}).collect(TestUtils.throwingIOSupplier(), (t, u) -> {}, (t, u) -> {}));
        Assertions.assertThrows(IOException.class, () -> IOStream.of((Object[])new String[]{"A", "B"}).collect(() -> "A", TestUtils.throwingIOBiConsumer(), (t, u) -> {}));
    }

    @Test
    void testCount() {
        Assertions.assertEquals((long)0L, (long)IOStream.of((Object[])new Object[0]).count());
        Assertions.assertEquals((long)1L, (long)IOStream.of((Object)"A").count());
        Assertions.assertEquals((long)2L, (long)IOStream.of((Object[])new String[]{"A", "B"}).count());
        Assertions.assertEquals((long)3L, (long)IOStream.of((Object[])new String[]{"A", "B", "C"}).count());
        Assertions.assertEquals((long)3L, (long)IOStream.of((Object[])new String[]{"A", "A", "A"}).count());
    }

    @Test
    void testDistinct() {
        Assertions.assertEquals((long)0L, (long)IOStream.of((Object[])new Object[0]).distinct().count());
        Assertions.assertEquals((long)1L, (long)IOStream.of((Object)"A").distinct().count());
        Assertions.assertEquals((long)2L, (long)IOStream.of((Object[])new String[]{"A", "B"}).distinct().count());
        Assertions.assertEquals((long)3L, (long)IOStream.of((Object[])new String[]{"A", "B", "C"}).distinct().count());
        Assertions.assertEquals((long)1L, (long)IOStream.of((Object[])new String[]{"A", "A", "A"}).distinct().count());
    }

    @Test
    void testEmpty() throws IOException {
        Assertions.assertEquals((long)0L, (long)Stream.empty().count());
        Assertions.assertEquals((long)0L, (long)IOStream.empty().count());
        IOStream.empty().forEach(TestUtils.throwingIOConsumer());
    }

    @Test
    void testFilter() throws IOException {
        IOStream.of((Object)"A").filter(TestConstants.THROWING_IO_PREDICATE);
        Assertions.assertThrows(IOException.class, () -> IOStream.of((Object)"A").filter(TestConstants.THROWING_IO_PREDICATE).count());
        Assertions.assertThrows(IOException.class, () -> IOStream.of((Object)"A").filter(e -> {
            throw new IOException("Failure");
        }).count());
    }

    @Test
    void testFindAny() throws IOException {
        Assertions.assertThrows(IOException.class, () -> IOStream.of((Object)"A").filter(TestConstants.THROWING_IO_PREDICATE).findAny());
        Assertions.assertThrows(IOException.class, () -> IOStream.of((Object)"A").filter(e -> {
            throw new IOException("Failure");
        }).findAny());
        Assertions.assertTrue((boolean)IOStream.of((Object[])new String[]{"A", "B"}).filter(IOPredicate.alwaysTrue()).findAny().isPresent());
        Assertions.assertFalse((boolean)IOStream.of((Object[])new String[]{"A", "B"}).filter(IOPredicate.alwaysFalse()).findAny().isPresent());
    }

    @Test
    void testFindFirst() throws IOException {
        Assertions.assertThrows(IOException.class, () -> IOStream.of((Object)"A").filter(TestConstants.THROWING_IO_PREDICATE).findFirst());
        Assertions.assertThrows(IOException.class, () -> IOStream.of((Object)"A").filter(e -> {
            throw new IOException("Failure");
        }).findAny());
        Assertions.assertTrue((boolean)IOStream.of((Object[])new String[]{"A", "B"}).filter(IOPredicate.alwaysTrue()).findFirst().isPresent());
        Assertions.assertFalse((boolean)IOStream.of((Object[])new String[]{"A", "B"}).filter(IOPredicate.alwaysFalse()).findFirst().isPresent());
    }

    @Test
    void testFlatMap() throws IOException {
        Assertions.assertEquals(Arrays.asList("A", "B", "C", "D"), (Object)IOStream.of((Object[])new IOStream[]{IOStream.of((Object[])new String[]{"A", "B"}), IOStream.of((Object[])new String[]{"C", "D"})}).flatMap(IOFunction.identity()).collect(Collectors.toList()));
    }

    @Test
    void testFlatMapToDouble() throws IOException {
        Assertions.assertEquals((double)131.0, (double)IOStream.of((Object[])new String[]{"A", "B"}).flatMapToDouble(e -> DoubleStream.of((double)e.charAt(0))).sum());
    }

    @Test
    void testFlatMapToInt() throws IOException {
        Assertions.assertEquals((int)131, (int)IOStream.of((Object[])new String[]{"A", "B"}).flatMapToInt(e -> IntStream.of((int)e.charAt(0))).sum());
    }

    @Test
    void testFlatMapToLong() throws IOException {
        Assertions.assertEquals((long)131L, (long)IOStream.of((Object[])new String[]{"A", "B"}).flatMapToLong(e -> LongStream.of((long)e.charAt(0))).sum());
    }

    @Test
    void testForaAllIOConsumer() throws IOException {
        Assertions.assertThrows(IOException.class, () -> IOStream.of((Object)"A").forAll(TestUtils.throwingIOConsumer()));
        Assertions.assertThrows(IOException.class, () -> IOStream.of((Object)"A").forAll(e -> {
            throw new IOException("Failure");
        }));
        Assertions.assertThrows(IOException.class, () -> IOStream.of((Object[])new String[]{"A", "B"}).forAll(TestUtils.throwingIOConsumer()));
        StringBuilder sb = new StringBuilder();
        IOStream.of((Object[])new String[]{"A", "B"}).forAll(sb::append);
        Assertions.assertEquals((Object)"AB", (Object)sb.toString());
    }

    @Test
    void testForaAllIOConsumerBiFunction() throws IOException {
        Assertions.assertThrows(IOException.class, () -> IOStream.of((Object)"A").forAll(TestUtils.throwingIOConsumer(), (i, e) -> e));
        Assertions.assertThrows(IOException.class, () -> IOStream.of((Object)"A").forAll(e -> {
            throw new IOException("Failure");
        }, (i, e) -> e));
        Assertions.assertThrows(IOException.class, () -> IOStream.of((Object[])new String[]{"A", "B"}).forAll(TestUtils.throwingIOConsumer(), (i, e) -> e));
        StringBuilder sb = new StringBuilder();
        IOStream.of((Object[])new String[]{"A", "B"}).forAll(sb::append, (i, e) -> e);
        Assertions.assertEquals((Object)"AB", (Object)sb.toString());
    }

    @Test
    void testForaAllIOConsumerBiFunctionNull() throws IOException {
        Assertions.assertDoesNotThrow(() -> IOStream.of((Object)"A").forAll(TestUtils.throwingIOConsumer(), null));
        Assertions.assertDoesNotThrow(() -> IOStream.of((Object)"A").forAll(e -> {
            throw new IOException("Failure");
        }, null));
        Assertions.assertDoesNotThrow(() -> IOStream.of((Object[])new String[]{"A", "B"}).forAll(TestUtils.throwingIOConsumer(), null));
        StringBuilder sb = new StringBuilder();
        IOStream.of((Object[])new String[]{"A", "B"}).forAll(sb::append, null);
        Assertions.assertEquals((Object)"AB", (Object)sb.toString());
    }

    @Test
    void testForEachIOConsumerOfQsuperT() throws IOException {
        Assertions.assertThrows(IOException.class, () -> IOStream.of((Object)"A").forEach(TestUtils.throwingIOConsumer()));
        Assertions.assertThrows(IOException.class, () -> IOStream.of((Object)"A").forEach(e -> {
            throw new IOException("Failure");
        }));
        Assertions.assertThrows(IOException.class, () -> IOStream.of((Object[])new String[]{"A", "B"}).forEach(TestUtils.throwingIOConsumer()));
        StringBuilder sb = new StringBuilder();
        IOStream.of((Object[])new String[]{"A", "B"}).forEachOrdered(sb::append);
        Assertions.assertEquals((Object)"AB", (Object)sb.toString());
    }

    @Test
    void testForEachOrdered() throws IOException {
        Assertions.assertThrows(IOException.class, () -> IOStream.of((Object)"A").forEach(TestUtils.throwingIOConsumer()));
        Assertions.assertThrows(IOException.class, () -> IOStream.of((Object)"A").forEach(e -> {
            throw new IOException("Failure");
        }));
        Assertions.assertThrows(IOException.class, () -> IOStream.of((Object[])new String[]{"A", "B"}).forEach(TestUtils.throwingIOConsumer()));
        StringBuilder sb = new StringBuilder();
        IOStream.of((Object[])new String[]{"A", "B"}).forEachOrdered(sb::append);
        Assertions.assertEquals((Object)"AB", (Object)sb.toString());
    }

    @Test
    void testForEachOrderedAdaptParallel() throws IOException {
        Assertions.assertThrows(IOException.class, () -> IOStream.adapt((Stream)((Stream)Stream.of("A").parallel())).forEach(TestUtils.throwingIOConsumer()));
        Assertions.assertThrows(IOException.class, () -> IOStream.adapt((Stream)((Stream)Stream.of("A").parallel())).forEach(e -> {
            throw new IOException("Failure");
        }));
        Assertions.assertThrows(IOException.class, () -> IOStream.adapt((Stream)((Stream)Stream.of("A", "B").parallel())).forEach(TestUtils.throwingIOConsumer()));
        StringBuilder sb = new StringBuilder();
        IOStream.adapt((Stream)((Stream)Stream.of("A", "B").parallel())).forEachOrdered(sb::append);
        Assertions.assertEquals((Object)"AB", (Object)sb.toString());
        sb.setLength(0);
        IOStream.adapt((Stream)((Stream)Stream.of("A", "B", "C").parallel())).forEachOrdered(sb::append);
        Assertions.assertEquals((Object)"ABC", (Object)sb.toString());
        sb.setLength(0);
        IOStream.adapt((Stream)((Stream)Stream.of("A", "B", "C", "D").parallel())).forEachOrdered(sb::append);
        Assertions.assertEquals((Object)"ABCD", (Object)sb.toString());
    }

    @Test
    void testForEachOrderedAsParallel() throws IOException {
        Assertions.assertThrows(IOException.class, () -> ((IOStream)IOStream.of((Object)"A").parallel()).forEach(TestUtils.throwingIOConsumer()));
        Assertions.assertThrows(IOException.class, () -> ((IOStream)IOStream.of((Object)"A").parallel()).forEach(e -> {
            throw new IOException("Failure");
        }));
        Assertions.assertThrows(IOException.class, () -> ((IOStream)IOStream.of((Object[])new String[]{"A", "B"}).parallel()).forEach(TestUtils.throwingIOConsumer()));
        StringBuilder sb = new StringBuilder();
        ((IOStream)IOStream.of((Object[])new String[]{"A", "B"}).parallel()).forEachOrdered(sb::append);
        Assertions.assertEquals((Object)"AB", (Object)sb.toString());
    }

    @Test
    void testIsParallel() {
        Assertions.assertFalse((boolean)IOStream.of((Object[])new String[]{"A", "B"}).isParallel());
        Assertions.assertTrue((boolean)((IOStream)IOStream.of((Object[])new String[]{"A", "B"}).parallel()).isParallel());
    }

    @Test
    void testIterateException() throws IOException {
        IOStream stream = IOStream.iterate((Object)1L, TestUtils.throwingIOUnaryOperator());
        IOIterator iterator = stream.iterator();
        Assertions.assertEquals((long)1L, (Long)((Long)iterator.next()));
        Assertions.assertThrows(NoSuchElementException.class, () -> iterator.next());
    }

    @Test
    void testIterateLong() throws IOException {
        IOStream stream = IOStream.iterate((Object)1L, i -> i + 1L);
        IOIterator iterator = stream.iterator();
        Assertions.assertEquals((long)1L, (Long)((Long)iterator.next()));
        Assertions.assertEquals((long)2L, (Long)((Long)iterator.next()));
    }

    @Test
    void testIterator() throws IOException {
        AtomicInteger ref = new AtomicInteger();
        IOStream.of((Object[])new String[]{"A", "B"}).iterator().forEachRemaining(e -> ref.incrementAndGet());
        Assertions.assertEquals((int)2, (int)ref.get());
    }

    @Test
    void testLimit() {
        Assertions.assertEquals((long)1L, (long)IOStream.of((Object[])new String[]{"A", "B"}).limit(1L).count());
    }

    @Test
    void testMap() throws IOException {
        Assertions.assertEquals(Arrays.asList("AC", "BC"), (Object)IOStream.of((Object[])new String[]{"A", "B"}).map(e -> e + "C").collect(Collectors.toList()));
    }

    @Test
    void testMapToDouble() {
        Assertions.assertArrayEquals((double[])new double[]{Double.parseDouble("1"), Double.parseDouble("2")}, (double[])IOStream.of((Object[])new String[]{"1", "2"}).mapToDouble(Double::parseDouble).toArray());
    }

    @Test
    void testMapToInt() {
        Assertions.assertArrayEquals((int[])new int[]{1, 2}, (int[])IOStream.of((Object[])new String[]{"1", "2"}).mapToInt(Integer::parseInt).toArray());
    }

    @Test
    void testMapToLong() {
        Assertions.assertArrayEquals((long[])new long[]{1L, 2L}, (long[])IOStream.of((Object[])new String[]{"1", "2"}).mapToLong(Long::parseLong).toArray());
    }

    @Test
    void testMax() throws IOException {
        Assertions.assertEquals((Object)"B", IOStream.of((Object[])new String[]{"A", "B"}).max(String::compareTo).get());
    }

    @Test
    void testMin() throws IOException {
        Assertions.assertEquals((Object)"A", IOStream.of((Object[])new String[]{"A", "B"}).min(String::compareTo).get());
    }

    @Test
    void testNoneMatch() throws IOException {
        Assertions.assertThrows(IOException.class, () -> IOStream.of((Object[])new String[]{"A", "B"}).noneMatch(TestConstants.THROWING_IO_PREDICATE));
        Assertions.assertFalse((boolean)IOStream.of((Object[])new String[]{"A", "B"}).noneMatch(IOPredicate.alwaysTrue()));
        Assertions.assertTrue((boolean)IOStream.of((Object[])new String[]{"A", "B"}).noneMatch(IOPredicate.alwaysFalse()));
    }

    @Test
    void testOfArray() {
        Assertions.assertEquals((long)0L, (long)IOStream.of((Object[])null).count());
        Assertions.assertEquals((long)0L, (long)IOStream.of((Object[])new Object[0]).count());
        Assertions.assertEquals((long)2L, (long)IOStream.of((Object[])new String[]{"A", "B"}).count());
    }

    @Test
    void testOfIterable() {
        Assertions.assertEquals((long)0L, (long)IOStream.of((Iterable)null).count());
        Assertions.assertEquals((long)0L, (long)IOStream.of(Collections.emptyList()).count());
        Assertions.assertEquals((long)0L, (long)IOStream.of(Collections.emptySet()).count());
        Assertions.assertEquals((long)0L, (long)IOStream.of(Collections.emptySortedSet()).count());
        Assertions.assertEquals((long)1L, (long)IOStream.of(Arrays.asList("a")).count());
        Assertions.assertEquals((long)2L, (long)IOStream.of(Arrays.asList("a", "b")).count());
    }

    @Test
    void testOfOne() {
        Assertions.assertEquals((long)1L, (long)IOStream.of((Object)"A").count());
    }

    @Test
    void testOnClose() throws IOException {
        Assertions.assertThrows(IOException.class, () -> ((IOStream)IOStream.of((Object)"A").onClose(TestConstants.THROWING_IO_RUNNABLE)).close());
        AtomicReference ref = new AtomicReference();
        ((IOStream)IOStream.of((Object)"A").onClose(() -> this.compareAndSetIO(ref, null, "new1"))).close();
        Assertions.assertEquals((Object)"new1", ref.get());
    }

    @Test
    void testOnCloseMultipleHandlers() {
        AtomicReference ref = new AtomicReference();
        ref.set(null);
        RuntimeException thrownRE = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> {
            Stream stream = (Stream)((Stream)Stream.of("A").onClose(() -> this.compareAndSetRE(ref, null, "new1"))).onClose(() -> TestConstants.throwRuntimeException("Failure 2"));
            stream.close();
        });
        Assertions.assertEquals((Object)"new1", ref.get());
        Assertions.assertEquals((Object)"Failure 2", (Object)thrownRE.getMessage());
        Assertions.assertEquals((int)0, (int)thrownRE.getSuppressed().length);
        ref.set(null);
        IOException thrownIO = (IOException)Assertions.assertThrows(IOException.class, () -> {
            IOStream stream = (IOStream)((IOStream)IOStream.of((Object)"A").onClose(() -> this.compareAndSetIO(ref, null, "new1"))).onClose(() -> TestConstants.throwIOException("Failure 2"));
            stream.close();
        });
        Assertions.assertEquals((Object)"new1", ref.get());
        Assertions.assertEquals((Object)"Failure 2", (Object)thrownIO.getMessage());
        Assertions.assertEquals((int)0, (int)thrownIO.getSuppressed().length);
        IOException thrownB = (IOException)Assertions.assertThrows(IOException.class, () -> {
            IOStream stream = (IOStream)((IOStream)IOStream.of((Object)"A").onClose((IORunnable)TestConstants.throwIOException("Failure 1"))).onClose((IORunnable)TestConstants.throwIOException("Failure 2"));
            stream.close();
        });
        Assertions.assertEquals((Object)"Failure 1", (Object)thrownB.getMessage());
        Assertions.assertEquals((int)0, (int)thrownB.getSuppressed().length);
    }

    @Test
    void testParallel() {
        Assertions.assertEquals((long)2L, (long)((IOStream)IOStream.of((Object[])new String[]{"A", "B"}).parallel()).count());
    }

    @Test
    void testPeek() throws IOException {
        AtomicReference ref = new AtomicReference();
        Assertions.assertEquals((long)1L, (long)Stream.of("A").peek(e -> this.compareAndSetRE(ref, null, (String)e)).count());
        Assertions.assertEquals((Object)(AT_LEAST_JAVA_11 ? null : "A"), ref.get());
        if (AT_LEAST_JAVA_11) {
            Assertions.assertEquals((long)1L, (long)IOStream.of((Object)"B").peek(e -> this.compareAndSetRE(ref, null, (String)e)).count());
            Assertions.assertEquals((long)1L, (long)IOStream.of((Object)"B").peek(e -> this.compareAndSetIO(ref, null, (String)e)).count());
            Assertions.assertNull(ref.get());
        } else {
            Assertions.assertThrows(RuntimeException.class, () -> IOStream.of((Object)"B").peek(e -> this.compareAndSetRE(ref, null, (String)e)).count());
            Assertions.assertThrows(IOException.class, () -> IOStream.of((Object)"B").peek(e -> this.compareAndSetIO(ref, null, (String)e)).count());
            Assertions.assertEquals((Object)"A", ref.get());
        }
    }

    @Test
    void testReduceBinaryOperatorOfT() throws IOException {
        Assertions.assertEquals((Object)"AB", IOStream.of((Object[])new String[]{"A", "B"}).reduce((t, u) -> t + u).get());
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_A.toRealPath(new LinkOption[0]), IOStream.of((Object[])new Path[]{TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_B}).reduce((t, u) -> t.toRealPath(new LinkOption[0])).get());
    }

    @Test
    void testReduceTBinaryOperatorOfT() throws IOException {
        Assertions.assertEquals((Object)"_AB", (Object)IOStream.of((Object[])new String[]{"A", "B"}).reduce((Object)"_", (t, u) -> t + u));
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_A.toRealPath(new LinkOption[0]), (Object)IOStream.of((Object[])new Path[]{TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_B}).reduce((Object)TestConstants.ABS_PATH_A, (t, u) -> t.toRealPath(new LinkOption[0])));
    }

    @Test
    void testReduceUBiFunctionOfUQsuperTUBinaryOperatorOfU() throws IOException {
        Assertions.assertEquals((Object)"_AB", (Object)IOStream.of((Object[])new String[]{"A", "B"}).reduce((Object)"_", (t, u) -> t + u, (t, u) -> t + u));
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_A.toRealPath(new LinkOption[0]), (Object)IOStream.of((Object[])new Path[]{TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_B}).reduce((Object)TestConstants.ABS_PATH_A, (t, u) -> t.toRealPath(new LinkOption[0]), (t, u) -> u.toRealPath(new LinkOption[0])));
    }

    @Test
    void testSequential() {
        Assertions.assertEquals((long)2L, (long)((IOStream)IOStream.of((Object[])new String[]{"A", "B"}).sequential()).count());
    }

    @Test
    void testSkip() throws IOException {
        AtomicReference ref = new AtomicReference();
        Assertions.assertEquals((long)1L, (long)Stream.of("A", "B").skip(1L).peek(e -> this.compareAndSetRE(ref, null, (String)e)).count());
        Assertions.assertEquals((Object)(AT_LEAST_JAVA_17 ? null : "B"), ref.get());
        if (AT_LEAST_JAVA_17) {
            Assertions.assertEquals((long)1L, (long)IOStream.of((Object[])new String[]{"C", "D"}).skip(1L).peek(e -> this.compareAndSetRE(ref, null, (String)e)).count());
            Assertions.assertEquals((long)1L, (long)IOStream.of((Object[])new String[]{"C", "D"}).skip(1L).peek(e -> this.compareAndSetIO(ref, null, (String)e)).count());
            Assertions.assertNull(ref.get());
        } else {
            if (AT_LEAST_JAVA_11) {
                Assertions.assertThrows(RuntimeException.class, () -> IOStream.of((Object[])new String[]{"C", "D"}).skip(1L).peek(e -> this.compareAndSetRE(ref, null, (String)e)).count());
                Assertions.assertThrows(IOException.class, () -> IOStream.of((Object[])new String[]{"C", "D"}).skip(1L).peek(e -> this.compareAndSetIO(ref, null, (String)e)).count());
            } else {
                Assertions.assertThrows(RuntimeException.class, () -> IOStream.of((Object[])new String[]{"C", "D"}).skip(1L).peek(e -> this.compareAndSetRE(ref, null, (String)e)).count());
                Assertions.assertThrows(IOException.class, () -> IOStream.of((Object[])new String[]{"C", "D"}).skip(1L).peek(e -> this.compareAndSetIO(ref, null, (String)e)).count());
            }
            Assertions.assertEquals((Object)"B", ref.get());
        }
    }

    @Test
    void testSorted() throws IOException {
        Assertions.assertEquals(Arrays.asList("A", "B", "C", "D"), (Object)IOStream.of((Object[])new String[]{"D", "A", "B", "C"}).sorted().collect(Collectors.toList()));
        Assertions.assertEquals(Arrays.asList("A", "B", "C", "D"), (Object)IOStream.of((Object[])new String[]{"D", "A", "B", "C"}).sorted().peek(this::ioExceptionOnNull).collect(Collectors.toList()));
    }

    @Test
    void testSortedComparatorOfQsuperT() throws IOException {
        Assertions.assertEquals(Arrays.asList("A", "B", "C", "D"), (Object)IOStream.of((Object[])new String[]{"D", "A", "B", "C"}).sorted(String::compareTo).collect(Collectors.toList()));
        Assertions.assertEquals(Arrays.asList("A", "B", "C", "D"), (Object)IOStream.of((Object[])new String[]{"D", "A", "B", "C"}).sorted(String::compareTo).peek(this::ioExceptionOnNull).collect(Collectors.toList()));
    }

    @Test
    void testSpliterator() {
        AtomicInteger ref = new AtomicInteger();
        IOStream.of((Object[])new String[]{"A", "B"}).spliterator().forEachRemaining(e -> ref.incrementAndGet());
        Assertions.assertEquals((int)2, (int)ref.get());
    }

    @Test
    void testToArray() {
        Assertions.assertArrayEquals((Object[])new String[]{"A", "B"}, (Object[])IOStream.of((Object[])new String[]{"A", "B"}).toArray());
    }

    @Test
    void testToArrayIntFunctionOfA() {
        Assertions.assertArrayEquals((Object[])new String[]{"A", "B"}, (Object[])IOStream.of((Object[])new String[]{"A", "B"}).toArray(String[]::new));
    }

    @Test
    void testUnordered() {
        Assertions.assertArrayEquals((Object[])new String[]{"A", "B"}, (Object[])((Stream)Stream.of("A", "B").unordered()).toArray());
        Assertions.assertArrayEquals((Object[])new String[]{"A", "B"}, (Object[])((IOStream)IOStream.of((Object[])new String[]{"A", "B"}).unordered()).toArray());
    }

    @Test
    void testUnwrap() {
        Stream unwrap = (Stream)IOStream.of((Object[])new String[]{"A", "B"}).unwrap();
        Assertions.assertNotNull((Object)unwrap);
        Assertions.assertEquals((long)2L, (long)unwrap.count());
    }
}

