/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.formats.tiff.AbstractTiffRasterData;
import org.apache.commons.imaging.formats.tiff.TiffRasterDataType;
import org.apache.commons.imaging.formats.tiff.TiffRasterStatistics;

public final class TiffRasterDataInt
extends AbstractTiffRasterData {
    private final int[] data;

    public TiffRasterDataInt(int width, int height) {
        super(width, height, 1);
        this.data = Allocator.intArray(this.nCells);
    }

    public TiffRasterDataInt(int width, int height, int samplesPerPixel) {
        super(width, height, samplesPerPixel);
        this.data = Allocator.intArray(this.nCells);
    }

    public TiffRasterDataInt(int width, int height, int samplesPerPixel, int[] data) {
        super(width, height, samplesPerPixel);
        if (data == null || data.length < this.nCells) {
            throw new IllegalArgumentException("Specified data does not contain sufficient elements");
        }
        this.data = data;
    }

    public TiffRasterDataInt(int width, int height, int[] data) {
        super(width, height, 1);
        if (data == null || data.length < this.nCells) {
            throw new IllegalArgumentException("Specified data does not contain sufficient elements");
        }
        this.data = data;
    }

    @Override
    public float[] getData() {
        float[] result = Allocator.floatArray(this.nCells);
        for (int i = 0; i < this.nCells; ++i) {
            result[i] = this.data[i];
        }
        return result;
    }

    @Override
    public TiffRasterDataType getDataType() {
        return TiffRasterDataType.INTEGER;
    }

    @Override
    public int[] getIntData() {
        return this.data;
    }

    @Override
    public int getIntValue(int x, int y) {
        return this.data[this.checkCoordinatesAndComputeIndex(x, y, 0)];
    }

    @Override
    public int getIntValue(int x, int y, int i) {
        return this.data[this.checkCoordinatesAndComputeIndex(x, y, i)];
    }

    @Override
    public TiffRasterStatistics getSimpleStatistics() {
        return new TiffRasterStatistics(this, Float.NaN);
    }

    @Override
    public TiffRasterStatistics getSimpleStatistics(float valueToExclude) {
        return new TiffRasterStatistics(this, valueToExclude);
    }

    @Override
    public float getValue(int x, int y) {
        return this.data[this.checkCoordinatesAndComputeIndex(x, y, 0)];
    }

    @Override
    public float getValue(int x, int y, int i) {
        return this.data[this.checkCoordinatesAndComputeIndex(x, y, i)];
    }

    @Override
    public void setIntValue(int x, int y, int value) {
        this.data[this.checkCoordinatesAndComputeIndex((int)x, (int)y, (int)0)] = value;
    }

    @Override
    public void setIntValue(int x, int y, int i, int value) {
        this.data[this.checkCoordinatesAndComputeIndex((int)x, (int)y, (int)i)] = value;
    }

    @Override
    public void setValue(int x, int y, float value) {
        this.data[this.checkCoordinatesAndComputeIndex((int)x, (int)y, (int)0)] = (int)value;
    }

    @Override
    public void setValue(int x, int y, int i, float value) {
        this.data[this.checkCoordinatesAndComputeIndex((int)x, (int)y, (int)i)] = (int)value;
    }
}

