/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common;

import java.math.BigInteger;
import org.apache.commons.imaging.ImagingRuntimeException;

public class AllocationRequestException
extends ImagingRuntimeException {
    private static final long serialVersionUID = 1L;
    private final int limit;
    private final BigInteger request;

    private static String format(int limit, BigInteger request) {
        return String.format("Allocation limit %,d exceeded: %,d", limit, request);
    }

    public AllocationRequestException(int limit, BigInteger request) {
        super(AllocationRequestException.format(limit, request));
        this.limit = limit;
        this.request = request;
    }

    public AllocationRequestException(int limit, BigInteger request, Throwable throwable) {
        super(AllocationRequestException.format(limit, request), throwable);
        this.limit = limit;
        this.request = request;
    }

    public AllocationRequestException(int limit, int request) {
        this(limit, BigInteger.valueOf(request));
    }

    public AllocationRequestException(int limit, long request, Throwable throwable) {
        this(limit, BigInteger.valueOf(request), throwable);
    }

    public int getLimit() {
        return this.limit;
    }

    public BigInteger getRequest() {
        return this.request;
    }
}

