/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.bzip2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BZip2CompressorInputStreamTest
extends AbstractTest {
    BZip2CompressorInputStreamTest() {
    }

    private void fuzzingTest(int[] bytes) throws IOException, ArchiveException {
        int len = bytes.length;
        byte[] input = new byte[len];
        for (int i = 0; i < len; ++i) {
            input[i] = (byte)bytes[i];
        }
        try (ArchiveInputStream ais = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("zip", (InputStream)new ByteArrayInputStream(input));){
            ais.getNextEntry();
            IOUtils.toByteArray((InputStream)ais);
        }
    }

    @Test
    void testMultiByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = BZip2CompressorInputStreamTest.getFile("bla.txt.bz2");
        byte[] buf = new byte[2];
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             BZip2CompressorInputStream in = new BZip2CompressorInputStream(is);){
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read(buf));
            Assertions.assertEquals((int)-1, (int)in.read(buf));
        }
    }

    @Test
    void testReadOfLength0ShouldReturn0() throws Exception {
        byte[] rawData = new byte[0x100000];
        for (int i = 0; i < rawData.length; ++i) {
            rawData[i] = (byte)Math.floor(Math.random() * 256.0);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (BZip2CompressorOutputStream bzipOut = new BZip2CompressorOutputStream((OutputStream)baos);){
            bzipOut.write(rawData);
            bzipOut.flush();
            bzipOut.close();
            Assertions.assertTrue((boolean)bzipOut.isClosed());
            baos.flush();
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try (BZip2CompressorInputStream bzipIn = new BZip2CompressorInputStream((InputStream)bais);){
            byte[] buffer = new byte[1024];
            Assertions.assertEquals((int)1024, (int)bzipIn.read(buffer, 0, 1024));
            Assertions.assertEquals((int)0, (int)bzipIn.read(buffer, 1024, 0));
            Assertions.assertEquals((int)1024, (int)bzipIn.read(buffer, 0, 1024));
        }
    }

    @Test
    void testShouldThrowAnIOExceptionWhenAppliedToAZipFile() throws Exception {
        try (InputStream in = BZip2CompressorInputStreamTest.newInputStream("bla.zip");){
            Assertions.assertThrows(IOException.class, () -> new BZip2CompressorInputStream(in));
        }
    }

    @Test
    void testShouldThrowIOExceptionInsteadOfRuntimeExceptionCOMPRESS516() {
        Assertions.assertThrows(IOException.class, () -> this.fuzzingTest(new int[]{80, 75, 3, 4, 46, 0, 0, 0, 12, 0, 132, 182, 186, 70, 114, 182, 254, 119, 99, 0, 0, 0, 107, 0, 0, 0, 3, 0, 28, 0, 98, 98, 98, 85, 84, 9, 0, 3, 231, 206, 100, 85, 243, 206, 100, 85, 117, 120, 11, 0, 1, 4, 92, 249, 1, 0, 4, 136, 19, 0, 0, 66, 90, 104, 52, 49, 65, 89, 38, 83, 89, 98, 228, 79, 81, 0, 0, 13, 209, 128, 0, 16, 64, 0, 53, 249, 139, 0, 32, 0, 72, 137, 250, 148, 242, 158, 41, 232, 210, 17, 138, 79, 83, 52, 15, 81, 122, 237, 134, 101, 214, 237, 97, 238, 104, 137, 72, 125, 7, 113, 146, 42, 80, 96, 4, 149, 97, 53, 71, 115, 49, 41, 194, 221, 94, 199, 74, 21, 20, 50, 76, 218, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
    }

    @Test
    void testShouldThrowIOExceptionInsteadOfRuntimeExceptionCOMPRESS519() {
        Assertions.assertThrows(IOException.class, () -> this.fuzzingTest(new int[]{80, 75, 3, 4, 46, 0, 0, 0, 12, 0, 132, 182, 186, 70, 114, 182, 254, 119, 99, 0, 0, 0, 107, 0, 0, 0, 3, 0, 28, 0, 98, 98, 98, 85, 84, 9, 0, 3, 231, 206, 100, 85, 243, 206, 100, 85, 117, 120, 11, 0, 1, 4, 92, 249, 1, 0, 4, 136, 19, 0, 0, 66, 90, 104, 52, 49, 65, 89, 38, 83, 89, 98, 228, 79, 81, 128, 0, 13, 209, 128, 0, 16, 64, 0, 53, 249, 139, 0, 32, 0, 72, 137, 250, 148, 242, 158, 41, 232, 210, 0, 0, 34, 0, 0, 0, 80, 75, 3, 4, 20, 0, 8, 0, 8, 0, 0, 0, 0}));
    }

    @Test
    void testSingleByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = BZip2CompressorInputStreamTest.getFile("bla.txt.bz2");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             BZip2CompressorInputStream in = new BZip2CompressorInputStream(is);){
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }
}

