/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.bugs;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.beanutils2.BeanIntrospector;
import org.apache.commons.beanutils2.FluentPropertyBeanIntrospector;
import org.apache.commons.beanutils2.PropertyUtilsBean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Jira541Test {
    private static final String FIELD_NAME = "field";
    private static final String FIELD_VALUE = "name";

    private static void testImpl() throws ReflectiveOperationException {
        PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
        propertyUtilsBean.addBeanIntrospector((BeanIntrospector)new FluentPropertyBeanIntrospector());
        SubTypeA subTypeA = new SubTypeA();
        propertyUtilsBean.setProperty((Object)subTypeA, FIELD_NAME, (Object)FIELD_VALUE);
        SubTypeB subTypeB = new SubTypeB();
        propertyUtilsBean.setProperty((Object)subTypeB, FIELD_NAME, (Object)FIELD_VALUE);
        Assertions.assertEquals((Object)FIELD_VALUE, (Object)subTypeA.getField());
        Assertions.assertEquals((Object)FIELD_VALUE, (Object)subTypeB.getField());
    }

    @Test
    public void testFluentBeanIntrospectorOnOverriddenSetter() throws Exception {
        Jira541Test.testImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFluentBeanIntrospectorOnOverriddenSetterConcurrent() throws Exception {
        ExecutorService executionService = Executors.newFixedThreadPool(256);
        try {
            ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
            for (int i = 0; i < 10000; ++i) {
                futures.add(executionService.submit(() -> {
                    Jira541Test.testImpl();
                    return null;
                }));
            }
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            executionService.shutdown();
        }
    }

    public static class SubTypeA
    extends BaseType {
        @Override
        public SubTypeA setField(String field) {
            super.setField(field);
            return this;
        }
    }

    public static class SubTypeB
    extends BaseType {
    }

    public static class BaseType {
        private String field;

        public String getField() {
            return this.field;
        }

        public BaseType setField(String objectName) {
            this.field = objectName;
            return this;
        }
    }
}

