/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import org.apache.commons.beanutils2.BeanPropertyValueEqualsPredicate;
import org.apache.commons.beanutils2.TestBean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanPropertyValueEqualsPredicateTest {
    private static final Integer expectedIntegerValue = 123;
    private static final Float expectedFloatValue = Float.valueOf(123.123f);
    private static final Double expectedDoubleValue = 567879.12344;
    private static final Boolean expectedBooleanValue = Boolean.TRUE;
    private static final Byte expectedByteValue = Byte.valueOf("12");

    @Test
    public void testEvaluateWithBooleanProperty() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("booleanProperty", (Object)expectedBooleanValue);
        Assertions.assertTrue((boolean)predicate.test((Object)new TestBean((boolean)expectedBooleanValue)));
        Assertions.assertFalse((boolean)predicate.test((Object)new TestBean(expectedBooleanValue == false)));
    }

    @Test
    public void testEvaluateWithByteProperty() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("byteProperty", (Object)expectedByteValue);
        TestBean testBean = new TestBean();
        testBean.setByteProperty(expectedByteValue);
        Assertions.assertTrue((boolean)predicate.test((Object)testBean));
        testBean.setByteProperty((byte)(expectedByteValue - 1));
        Assertions.assertFalse((boolean)predicate.test((Object)testBean));
    }

    @Test
    public void testEvaluateWithDoubleProperty() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("doubleProperty", (Object)expectedDoubleValue);
        Assertions.assertTrue((boolean)predicate.test((Object)new TestBean(expectedDoubleValue)));
        Assertions.assertFalse((boolean)predicate.test((Object)new TestBean(expectedDoubleValue - 1.0)));
    }

    @Test
    public void testEvaluateWithFloatProperty() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("floatProperty", (Object)expectedFloatValue);
        Assertions.assertTrue((boolean)predicate.test((Object)new TestBean(expectedFloatValue.floatValue())));
        Assertions.assertFalse((boolean)predicate.test((Object)new TestBean(expectedFloatValue.floatValue() - 1.0f)));
    }

    @Test
    public void testEvaluateWithIndexedProperty() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("intIndexed[0]", (Object)expectedIntegerValue);
        TestBean testBean = new TestBean();
        testBean.setIntIndexed(0, expectedIntegerValue);
        Assertions.assertTrue((boolean)predicate.test((Object)testBean));
        testBean.setIntIndexed(0, expectedIntegerValue - 1);
        Assertions.assertFalse((boolean)predicate.test((Object)testBean));
        predicate = new BeanPropertyValueEqualsPredicate("intIndexed[999]", (Object)"exception-ahead");
        try {
            Assertions.assertFalse((boolean)predicate.test((Object)testBean));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testEvaluateWithIntProperty() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("intProperty", (Object)expectedIntegerValue);
        Assertions.assertTrue((boolean)predicate.test((Object)new TestBean((int)expectedIntegerValue)));
        Assertions.assertFalse((boolean)predicate.test((Object)new TestBean(expectedIntegerValue - 1)));
    }

    @Test
    public void testEvaluateWithInvalidPropertyName() {
        try {
            new BeanPropertyValueEqualsPredicate("bogusProperty", null).test((Object)new TestBean());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testEvaluateWithMappedProperty() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("mappedProperty(test-key)", (Object)"match");
        TestBean testBean = new TestBean();
        testBean.setMappedProperty("test-key", "match");
        Assertions.assertTrue((boolean)predicate.test((Object)testBean));
        testBean.setMappedProperty("test-key", "no-match");
        Assertions.assertFalse((boolean)predicate.test((Object)testBean));
        predicate = new BeanPropertyValueEqualsPredicate("mappedProperty(invalid-key)", (Object)"match");
        Assertions.assertFalse((boolean)predicate.test((Object)testBean));
    }

    @Test
    public void testEvaluateWithNestedMappedProperty() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("anotherNested.mappedProperty(test-key)", (Object)"match");
        TestBean testBean = new TestBean();
        TestBean nestedBean = new TestBean();
        nestedBean.setMappedProperty("test-key", "match");
        testBean.setAnotherNested(nestedBean);
        Assertions.assertTrue((boolean)predicate.test((Object)testBean));
        nestedBean.setMappedProperty("test-key", "no-match");
        Assertions.assertFalse((boolean)predicate.test((Object)testBean));
    }

    @Test
    public void testEvaluateWithNestedProperty() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("anotherNested.stringProperty", (Object)"match");
        TestBean testBean = new TestBean();
        TestBean nestedBean = new TestBean("match");
        testBean.setAnotherNested(nestedBean);
        Assertions.assertTrue((boolean)predicate.test((Object)testBean));
        testBean.setAnotherNested(new TestBean("no-match"));
        Assertions.assertFalse((boolean)predicate.test((Object)testBean));
    }

    @Test
    public void testEvaluateWithNullInPath() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("anotherNested.stringProperty", (Object)"foo");
        Assertions.assertThrows(IllegalArgumentException.class, () -> predicate.test((Object)new TestBean()));
    }

    @Test
    public void testEvaluateWithNullInPathAndIgnoreTrue() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("anotherNested.stringProperty", (Object)"foo", true);
        Assertions.assertFalse((boolean)predicate.test((Object)new TestBean()));
    }

    @Test
    public void testEvaluateWithPrimitiveAndNull() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("intProperty", null);
        Assertions.assertFalse((boolean)predicate.test((Object)new TestBean(0)));
        predicate = new BeanPropertyValueEqualsPredicate("booleanProperty", null);
        Assertions.assertFalse((boolean)predicate.test((Object)new TestBean(true)));
        predicate = new BeanPropertyValueEqualsPredicate("floatProperty", null);
        Assertions.assertFalse((boolean)predicate.test((Object)new TestBean(expectedFloatValue.floatValue())));
    }

    @Test
    public void testEvaluateWithReadOnlyProperty() {
        TestBean testBean = new TestBean();
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("readOnlyProperty", (Object)testBean.getReadOnlyProperty());
        Assertions.assertTrue((boolean)predicate.test((Object)new TestBean()));
    }

    @Test
    public void testEvaluateWithSimpleStringProperty() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("stringProperty", (Object)"foo");
        Assertions.assertTrue((boolean)predicate.test((Object)new TestBean("foo")));
        Assertions.assertFalse((boolean)predicate.test((Object)new TestBean("bar")));
    }

    @Test
    public void testEvaluateWithSimpleStringPropertyWithNullValues() {
        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("stringProperty", null);
        Assertions.assertTrue((boolean)predicate.test((Object)new TestBean((String)null)));
        Assertions.assertFalse((boolean)predicate.test((Object)new TestBean("bar")));
    }

    @Test
    public void testEvaluateWithWriteOnlyProperty() {
        try {
            new BeanPropertyValueEqualsPredicate("writeOnlyProperty", null).test((Object)new TestBean());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

