/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.server;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.apache.celeborn.common.network.buffer.NioManagedBuffer;
import org.apache.celeborn.common.network.client.RpcResponseCallback;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.protocol.ChunkFetchFailure;
import org.apache.celeborn.common.network.protocol.ChunkFetchRequest;
import org.apache.celeborn.common.network.protocol.Encodable;
import org.apache.celeborn.common.network.protocol.OneWayMessage;
import org.apache.celeborn.common.network.protocol.RequestMessage;
import org.apache.celeborn.common.network.protocol.RpcFailure;
import org.apache.celeborn.common.network.protocol.RpcRequest;
import org.apache.celeborn.common.network.protocol.RpcResponse;
import org.apache.celeborn.common.network.server.BaseMessageHandler;
import org.apache.celeborn.common.network.server.MessageHandler;
import org.apache.celeborn.shaded.com.google.common.base.Throwables;
import org.apache.celeborn.shaded.io.netty.channel.Channel;
import org.apache.celeborn.shaded.io.netty.channel.ChannelFuture;
import org.apache.celeborn.shaded.io.netty.util.concurrent.Future;
import org.apache.celeborn.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportRequestHandler
extends MessageHandler<RequestMessage> {
    private static final Logger logger = LoggerFactory.getLogger(TransportRequestHandler.class);
    private final Channel channel;
    private final TransportClient reverseClient;
    private final BaseMessageHandler msgHandler;

    public TransportRequestHandler(Channel channel, TransportClient reverseClient, BaseMessageHandler msgHandler) {
        this.channel = channel;
        this.reverseClient = reverseClient;
        this.msgHandler = msgHandler;
    }

    @Override
    public void exceptionCaught(Throwable cause) {
        this.msgHandler.exceptionCaught(cause, this.reverseClient);
    }

    @Override
    public void channelActive() {
        this.msgHandler.channelActive(this.reverseClient);
    }

    @Override
    public void channelInactive() {
        this.msgHandler.channelInactive(this.reverseClient);
    }

    @Override
    public void handle(RequestMessage request) {
        if (logger.isTraceEnabled()) {
            logger.trace("Received request {} from {}", (Object)request.getClass().getName(), (Object)this.reverseClient);
        }
        if (this.checkRegistered(request)) {
            if (request instanceof RpcRequest) {
                this.processRpcRequest((RpcRequest)request);
            } else if (request instanceof OneWayMessage) {
                this.processOneWayMessage((OneWayMessage)request);
            } else {
                this.processOtherMessages(request);
            }
        }
    }

    private void processRpcRequest(final RpcRequest req) {
        try {
            logger.trace("Process rpc request {}", (Object)req.requestId);
            this.msgHandler.receive(this.reverseClient, req, new RpcResponseCallback(){

                @Override
                public void onSuccess(ByteBuffer response) {
                    TransportRequestHandler.this.respond(new RpcResponse(req.requestId, new NioManagedBuffer(response)));
                }

                @Override
                public void onFailure(Throwable e) {
                    TransportRequestHandler.this.respond(new RpcFailure(req.requestId, Throwables.getStackTraceAsString(e)));
                }
            });
        }
        catch (Exception e) {
            logger.error("Error while invoking handler#receive() on RPC id " + req.requestId, (Throwable)e);
            this.respond(new RpcFailure(req.requestId, Throwables.getStackTraceAsString(e)));
        }
        finally {
            req.body().release();
        }
    }

    private void processOneWayMessage(OneWayMessage req) {
        try {
            logger.trace("Process one way request");
            this.msgHandler.receive(this.reverseClient, req);
        }
        catch (Exception e) {
            logger.error("Error while invoking handler#receive() for one-way message.", (Throwable)e);
        }
        finally {
            req.body().release();
        }
    }

    private void processOtherMessages(RequestMessage req) {
        try {
            logger.trace("delegating to handler to process other request");
            this.msgHandler.receive(this.reverseClient, req);
        }
        catch (Exception e) {
            logger.error("Error while invoking handler#receive() for other message.", (Throwable)e);
        }
        finally {
            if (req.body() != null) {
                req.body().release();
            }
        }
    }

    private boolean checkRegistered(RequestMessage req) {
        if (!this.msgHandler.checkRegistered()) {
            IOException e = new IOException("Worker Not Registered!");
            if (req instanceof RpcRequest) {
                this.respond(new RpcFailure(((RpcRequest)req).requestId, Throwables.getStackTraceAsString(e)));
            } else if (req instanceof ChunkFetchRequest) {
                this.respond(new ChunkFetchFailure(((ChunkFetchRequest)req).streamChunkSlice, Throwables.getStackTraceAsString(e)));
            } else if (req instanceof OneWayMessage) {
                logger.warn("Ignore OneWayMessage since worker is not registered!");
            }
            return false;
        }
        return true;
    }

    private ChannelFuture respond(Encodable result) {
        SocketAddress remoteAddress = this.channel.remoteAddress();
        return this.channel.writeAndFlush(result).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
            if (future.isSuccess()) {
                logger.trace("Sent result {} to client {}", (Object)result, (Object)remoteAddress);
            } else {
                logger.warn(String.format("Fail to sending result %s to %s; closing connection", result, remoteAddress), future.cause());
            }
        }));
    }
}

