/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.DeviceInfo;
import org.apache.celeborn.common.meta.DeviceInfo$;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.meta.DiskStatus;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.common.util.Utils$;
import org.apache.celeborn.service.deploy.worker.WorkerSource$;
import org.apache.celeborn.service.deploy.worker.storage.DeviceMonitor;
import org.apache.celeborn.service.deploy.worker.storage.DeviceMonitor$;
import org.apache.celeborn.service.deploy.worker.storage.DeviceObserver;
import org.apache.celeborn.service.deploy.worker.storage.FileWriter;
import org.apache.celeborn.service.deploy.worker.storage.LocalDeviceMonitor$;
import org.apache.celeborn.service.deploy.worker.storage.LocalFlusher;
import org.apache.celeborn.service.deploy.worker.storage.ObservedDevice;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001\u0002\u0010 \u00019B\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"A!\n\u0001B\u0001B\u0003%1\n\u0003\u0005e\u0001\t\u0005\t\u0015!\u0003f\u0011!I\u0007A!A!\u0002\u0013Q\u0007\"\u0002:\u0001\t\u0003\u0019\b\"\u0003>\u0001\u0001\u0004\u0005\r\u0011\"\u0001|\u0011-\t\t\u0001\u0001a\u0001\u0002\u0004%\t!a\u0001\t\u0015\u0005=\u0001\u00011A\u0001B\u0003&A\u0010C\u0005\u0002\u0012\u0001\u0011\r\u0011\"\u0001\u0002\u0014!A\u00111\u0004\u0001!\u0002\u0013\t)\u0002C\u0005\u0002\u001e\u0001\u0011\r\u0011\"\u0001\u0002 !A\u00111\u0007\u0001!\u0002\u0013\t\t\u0003C\u0005\u00026\u0001\u0011\r\u0011\"\u0001\u00028!A\u0011q\b\u0001!\u0002\u0013\tI\u0004C\u0005\u0002B\u0001\u0011\r\u0011\"\u0001\u00028!A\u00111\t\u0001!\u0002\u0013\tI\u0004C\u0005\u0002F\u0001\u0011\r\u0011\"\u0001\u00028!A\u0011q\t\u0001!\u0002\u0013\tI\u0004C\u0005\u0002J\u0001\u0011\r\u0011\"\u0003\u0002L!A\u0011\u0011\f\u0001!\u0002\u0013\ti\u0005C\u0004\u0002\\\u0001!\t!!\u0018\t\u000f\u0005}\u0003\u0001\"\u0011\u0002^!9\u0011\u0011\r\u0001\u0005B\u0005\r\u0004bBA8\u0001\u0011\u0005\u0013\u0011\u000f\u0005\b\u0003k\u0002A\u0011IA<\u0011\u001d\t\u0019\t\u0001C!\u0003\u000bCq!!#\u0001\t\u0003\nY\tC\u0004\u0002,\u0002!\t%!\u0018\u0003%1{7-\u00197EKZL7-Z'p]&$xN\u001d\u0006\u0003A\u0005\nqa\u001d;pe\u0006<WM\u0003\u0002#G\u00051qo\u001c:lKJT!\u0001J\u0013\u0002\r\u0011,\u0007\u000f\\8z\u0015\t1s%A\u0004tKJ4\u0018nY3\u000b\u0005!J\u0013\u0001C2fY\u0016\u0014wN\u001d8\u000b\u0005)Z\u0013AB1qC\u000eDWMC\u0001-\u0003\ry'oZ\u0002\u0001'\u0011\u0001q&N\u001d\u0011\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\r\u0005s\u0017PU3g!\t1t'D\u0001 \u0013\tAtDA\u0007EKZL7-Z'p]&$xN\u001d\t\u0003u}j\u0011a\u000f\u0006\u0003yu\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003}\u001d\naaY8n[>t\u0017B\u0001!<\u0005\u001daunZ4j]\u001e\fAaY8oMB\u00111\tR\u0007\u0002{%\u0011Q)\u0010\u0002\r\u0007\u0016dWMY8s]\u000e{gNZ\u0001\t_\n\u001cXM\u001d<feB\u0011a\u0007S\u0005\u0003\u0013~\u0011a\u0002R3wS\u000e,wJY:feZ,'/A\u0006eKZL7-Z%oM>\u001c\b\u0003\u0002'R'zk\u0011!\u0014\u0006\u0003\u001d>\u000bA!\u001e;jY*\t\u0001+\u0001\u0003kCZ\f\u0017B\u0001*N\u0005\ri\u0015\r\u001d\t\u0003)ns!!V-\u0011\u0005Y\u000bT\"A,\u000b\u0005ak\u0013A\u0002\u001fs_>$h(\u0003\u0002[c\u00051\u0001K]3eK\u001aL!\u0001X/\u0003\rM#(/\u001b8h\u0015\tQ\u0016\u0007\u0005\u0002`E6\t\u0001M\u0003\u0002b{\u0005!Q.\u001a;b\u0013\t\u0019\u0007M\u0001\u0006EKZL7-Z%oM>\f\u0011\u0002Z5tW&sgm\\:\u0011\t1\u000b6K\u001a\t\u0003?\u001eL!\u0001\u001b1\u0003\u0011\u0011K7o[%oM>\fAb^8sW\u0016\u00148k\\;sG\u0016\u0004\"a\u001b9\u000e\u00031T!!\u001c8\u0002\rM|WO]2f\u0015\tyW(A\u0004nKR\u0014\u0018nY:\n\u0005Ed'AD!cgR\u0014\u0018m\u0019;T_V\u00148-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\rQ,ho\u001e=z!\t1\u0004\u0001C\u0003B\r\u0001\u0007!\tC\u0003G\r\u0001\u0007q\tC\u0003K\r\u0001\u00071\nC\u0003e\r\u0001\u0007Q\rC\u0003j\r\u0001\u0007!.A\bpEN,'O^3e\t\u00164\u0018nY3t+\u0005a\b\u0003\u0002'R=v\u0004\"A\u000e@\n\u0005}|\"AD(cg\u0016\u0014h/\u001a3EKZL7-Z\u0001\u0014_\n\u001cXM\u001d<fI\u0012+g/[2fg~#S-\u001d\u000b\u0005\u0003\u000b\tY\u0001E\u00021\u0003\u000fI1!!\u00032\u0005\u0011)f.\u001b;\t\u0011\u00055\u0001\"!AA\u0002q\f1\u0001\u001f\u00132\u0003Ay'm]3sm\u0016$G)\u001a<jG\u0016\u001c\b%A\teSN\\7\t[3dW&sG/\u001a:wC2,\"!!\u0006\u0011\u0007A\n9\"C\u0002\u0002\u001aE\u0012A\u0001T8oO\u0006\u0011B-[:l\u0007\",7m[%oi\u0016\u0014h/\u00197!\u0003Y!WM^5dK6{g.\u001b;pe\u000eCWmY6MSN$XCAA\u0011!\u0015\t\u0019#!\fT\u001d\u0011\t)#!\u000b\u000f\u0007Y\u000b9#C\u00013\u0013\r\tY#M\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty#!\r\u0003\u0007M+\u0017OC\u0002\u0002,E\nq\u0003Z3wS\u000e,Wj\u001c8ji>\u00148\t[3dW2K7\u000f\u001e\u0011\u0002\u0017\rDWmY6J_\"\u000bgnZ\u000b\u0003\u0003s\u00012\u0001MA\u001e\u0013\r\ti$\r\u0002\b\u0005>|G.Z1o\u00031\u0019\u0007.Z2l\u0013>D\u0015M\\4!\u00039\u0019\u0007.Z2l%\u0016\fGm\u0016:ji\u0016\fqb\u00195fG.\u0014V-\u00193Xe&$X\rI\u0001\u000fG\",7m\u001b#jg.,6/Y4f\u0003=\u0019\u0007.Z2l\t&\u001c8.V:bO\u0016\u0004\u0013a\u00033jg.\u001c\u0005.Z2lKJ,\"!!\u0014\u0011\t\u0005=\u0013QK\u0007\u0003\u0003#R1!a\u0015N\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003/\n\tF\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\fA\u0002Z5tW\u000eCWmY6fe\u0002\nA!\u001b8jiR\u0011\u0011QA\u0001\u000bgR\f'\u000f^\"iK\u000e\\\u0017A\u0005:fO&\u001cH/\u001a:GS2,wK]5uKJ$B!!\u0002\u0002f!9\u0011q\r\rA\u0002\u0005%\u0014A\u00034jY\u0016<&/\u001b;feB\u0019a'a\u001b\n\u0007\u00055tD\u0001\u0006GS2,wK]5uKJ\fA#\u001e8sK\u001eL7\u000f^3s\r&dWm\u0016:ji\u0016\u0014H\u0003BA\u0003\u0003gBq!a\u001a\u001a\u0001\u0004\tI'A\bsK\u001eL7\u000f^3s\r2,8\u000f[3s)\u0011\t)!!\u001f\t\u000f\u0005m$\u00041\u0001\u0002~\u00059a\r\\;tQ\u0016\u0014\bc\u0001\u001c\u0002\u0000%\u0019\u0011\u0011Q\u0010\u0003\u00191{7-\u00197GYV\u001c\b.\u001a:\u0002#Ut'/Z4jgR,'O\u00127vg\",'\u000f\u0006\u0003\u0002\u0006\u0005\u001d\u0005bBA>7\u0001\u0007\u0011QP\u0001\u0017e\u0016\u0004xN\u001d;O_:\u001c%/\u001b;jG\u0006dWI\u001d:peRA\u0011QAAG\u0003#\u000b\t\u000b\u0003\u0004\u0002\u0010r\u0001\raU\u0001\u000b[>,h\u000e\u001e)pS:$\bbBAJ9\u0001\u0007\u0011QS\u0001\u0002KB!\u0011qSAO\u001b\t\tIJC\u0002\u0002\u001c>\u000b!![8\n\t\u0005}\u0015\u0011\u0014\u0002\f\u0013>+\u0005pY3qi&|g\u000eC\u0004\u0002$r\u0001\r!!*\u0002\u0015\u0011L7o[*uCR,8\u000fE\u0002`\u0003OK1!!+a\u0005)!\u0015n]6Ti\u0006$Xo]\u0001\u0006G2|7/\u001a")
public class LocalDeviceMonitor
implements DeviceMonitor,
Logging {
    public final CelebornConf org$apache$celeborn$service$deploy$worker$storage$LocalDeviceMonitor$$conf;
    private final DeviceObserver observer;
    private final Map<String, DeviceInfo> deviceInfos;
    private final Map<String, DiskInfo> diskInfos;
    private final AbstractSource workerSource;
    private Map<DeviceInfo, ObservedDevice> observedDevices;
    private final long diskCheckInterval;
    private final Seq<String> deviceMonitorCheckList;
    private final boolean checkIoHang;
    private final boolean checkReadWrite;
    private final boolean checkDiskUsage;
    private final ScheduledExecutorService diskChecker;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        LocalDeviceMonitor localDeviceMonitor = this;
        synchronized (localDeviceMonitor) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public Map<DeviceInfo, ObservedDevice> observedDevices() {
        return this.observedDevices;
    }

    public void observedDevices_$eq(Map<DeviceInfo, ObservedDevice> x$1) {
        this.observedDevices = x$1;
    }

    public long diskCheckInterval() {
        return this.diskCheckInterval;
    }

    public Seq<String> deviceMonitorCheckList() {
        return this.deviceMonitorCheckList;
    }

    public boolean checkIoHang() {
        return this.checkIoHang;
    }

    public boolean checkReadWrite() {
        return this.checkReadWrite;
    }

    public boolean checkDiskUsage() {
        return this.checkDiskUsage;
    }

    private ScheduledExecutorService diskChecker() {
        return this.diskChecker;
    }

    public void init() {
        this.observedDevices_$eq(new HashMap<DeviceInfo, ObservedDevice>());
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.deviceInfos).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LocalDeviceMonitor.$anonfun$init$1(x$1)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LocalDeviceMonitor.$anonfun$init$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.deviceInfos).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            ObservedDevice observedDevice = new ObservedDevice((DeviceInfo)entry._2(), $this.org$apache$celeborn$service$deploy$worker$storage$LocalDeviceMonitor$$conf, $this.workerSource);
            observedDevice.addObserver($this.observer);
            return this.observedDevices().put((DeviceInfo)entry._2(), observedDevice);
        });
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.diskInfos).asScala()).values().toList().groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.deviceInfo()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            LocalDeviceMonitor.$anonfun$init$6(this, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void startCheck() {
        this.diskChecker().scheduleWithFixedDelay(new Runnable(this){
            private final /* synthetic */ LocalDeviceMonitor $outer;

            public void run() {
                this.$outer.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Device check start");
                try {
                    ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.$outer.observedDevices().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)device -> {
                        $anon$1.$anonfun$run$2(this, device);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable t) {
                    this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Device check failed.", t);
                }
            }

            public static final /* synthetic */ Object $anonfun$run$4(long now$1, ObservedDevice device$1, java.util.List concurrentList$1, long time) {
                return now$1 - time > device$1.notifyErrorExpireTimeout() ? BoxesRunTime.boxToBoolean((boolean)concurrentList$1.remove(BoxesRunTime.boxToLong((long)time))) : BoxedUnit.UNIT;
            }

            public static final /* synthetic */ void $anonfun$run$3(long now$1, ObservedDevice device$1, java.util.List concurrentList) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(concurrentList).asScala()).foreach((Function1 & Serializable & scala.Serializable)time -> $anon$1.$anonfun$run$4(now$1, device$1, concurrentList, BoxesRunTime.unboxToLong((Object)time)));
            }

            public static final /* synthetic */ int $anonfun$run$5(java.util.List x$5) {
                return x$5.size();
            }

            public static final /* synthetic */ void $anonfun$run$9($anon$1 $this, ObservedDevice device$1, int nonCriticalErrorSum$1, DiskInfo diskInfo) {
                block1: {
                    block2: {
                        block0: {
                            if (!$this.$outer.checkDiskUsage() || !DeviceMonitor$.MODULE$.highDiskUsage($this.$outer.org$apache$celeborn$service$deploy$worker$storage$LocalDeviceMonitor$$conf, diskInfo)) break block0;
                            $this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append(diskInfo.mountPoint()).append(" high_disk_usage error, notify observers").toString());
                            device$1.notifyObserversOnHighDiskUsage(diskInfo.mountPoint());
                            break block1;
                        }
                        if (!$this.$outer.checkReadWrite() || !DeviceMonitor$.MODULE$.readWriteError($this.$outer.org$apache$celeborn$service$deploy$worker$storage$LocalDeviceMonitor$$conf, (File)diskInfo.dirs().head())) break block2;
                        $this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append(diskInfo.mountPoint()).append(" read-write error, notify observers").toString());
                        device$1.notifyObserversOnNonCriticalError((List<String>)new .colon.colon((Object)diskInfo.mountPoint(), (List)Nil$.MODULE$), DiskStatus.READ_OR_WRITE_FAILURE);
                        break block1;
                    }
                    if (!((double)nonCriticalErrorSum$1 <= (double)device$1.notifyErrorThreshold() * 0.5)) break block1;
                    device$1.notifyObserversOnHealthy(diskInfo.mountPoint());
                }
            }

            public static final /* synthetic */ void $anonfun$run$2($anon$1 $this, ObservedDevice device) {
                List mountPoints = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(device.diskInfos().keySet()).asScala()).toList();
                long now = System.currentTimeMillis();
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(device.nonCriticalErrors().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)concurrentList -> {
                    $anon$1.$anonfun$run$3(now, device, concurrentList);
                    return BoxedUnit.UNIT;
                });
                int nonCriticalErrorSum = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(device.nonCriticalErrors().values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)$anon$1.$anonfun$run$5(x$5)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                if (nonCriticalErrorSum > device.notifyErrorThreshold()) {
                    $this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(152).append("Device ").append(device.deviceInfo().name()).append(" has accumulated ").append(nonCriticalErrorSum).append(" non-critical ").append("error within the past ").append(Utils$.MODULE$.msDurationToString(device.notifyErrorExpireTimeout())).append(" , its sum has ").append("exceed the threshold (").append(device.notifyErrorThreshold()).append("), device monitor will notify error to ").append("observed device.").toString());
                    List mountPoints2 = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(device.diskInfos().values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.mountPoint(), Iterable$.MODULE$.canBuildFrom())).toList();
                    device.notifyObserversOnError((List<String>)mountPoints2, DiskStatus.CRITICAL_ERROR);
                } else if ($this.$outer.checkIoHang() && device.ioHang()) {
                    $this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Encounter device io hang error!").append(device.deviceInfo().name()).append(", notify observers").toString());
                    device.notifyObserversOnNonCriticalError((List<String>)mountPoints, DiskStatus.IO_HANG);
                } else {
                    ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(device.diskInfos().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)diskInfo -> {
                        $anon$1.$anonfun$run$9($this, device, nonCriticalErrorSum, diskInfo);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(), $anonfun$run$2$adapted(org.apache.celeborn.service.deploy.worker.storage.LocalDeviceMonitor$$anon$1 org.apache.celeborn.service.deploy.worker.storage.ObservedDevice ), $anonfun$run$12(), $anonfun$run$4$adapted(long org.apache.celeborn.service.deploy.worker.storage.ObservedDevice java.util.List java.lang.Object ), $anonfun$run$10(org.apache.celeborn.common.meta.DiskInfo ), $anonfun$run$11(org.apache.celeborn.common.meta.DiskInfo ), $anonfun$run$3$adapted(long org.apache.celeborn.service.deploy.worker.storage.ObservedDevice java.util.List ), $anonfun$run$5$adapted(java.util.List ), $anonfun$run$6(org.apache.celeborn.service.deploy.worker.storage.ObservedDevice int ), $anonfun$run$7(org.apache.celeborn.common.meta.DiskInfo ), $anonfun$run$8(org.apache.celeborn.service.deploy.worker.storage.ObservedDevice ), $anonfun$run$9$adapted(org.apache.celeborn.service.deploy.worker.storage.LocalDeviceMonitor$$anon$1 org.apache.celeborn.service.deploy.worker.storage.ObservedDevice int org.apache.celeborn.common.meta.DiskInfo )}, serializedLambda);
            }
        }, this.diskCheckInterval(), this.diskCheckInterval(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void registerFileWriter(FileWriter fileWriter) {
        String mountPoint = DeviceInfo$.MODULE$.getMountPoint(fileWriter.getFile().getAbsolutePath(), this.diskInfos);
        this.observedDevices().get(this.diskInfos.get(mountPoint).deviceInfo()).addObserver(fileWriter);
    }

    @Override
    public void unregisterFileWriter(FileWriter fileWriter) {
        String mountPoint = DeviceInfo$.MODULE$.getMountPoint(fileWriter.getFile().getAbsolutePath(), this.diskInfos);
        this.observedDevices().get(this.diskInfos.get(mountPoint).deviceInfo()).removeObserver(fileWriter);
    }

    @Override
    public void registerFlusher(LocalFlusher flusher) {
        this.observedDevices().get(this.diskInfos.get(flusher.mountPoint()).deviceInfo()).addObserver(flusher);
    }

    @Override
    public void unregisterFlusher(LocalFlusher flusher) {
        this.observedDevices().get(this.diskInfos.get(flusher.mountPoint()).deviceInfo()).removeObserver(flusher);
    }

    @Override
    public void reportNonCriticalError(String mountPoint, IOException e, DiskStatus diskStatus) {
        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Receive non-critical exception, disk: ").append(mountPoint).append(", ").append(e).toString());
        this.observedDevices().get(this.diskInfos.get(mountPoint).deviceInfo()).notifyObserversOnNonCriticalError((List<String>)new .colon.colon((Object)mountPoint, (List)Nil$.MODULE$), diskStatus);
    }

    @Override
    public void close() {
        block0: {
            if (DeviceMonitor$.MODULE$.deviceCheckThreadPool() == null) break block0;
            DeviceMonitor$.MODULE$.deviceCheckThreadPool().shutdownNow();
        }
    }

    public static final /* synthetic */ boolean $anonfun$init$1(Tuple2 x$1) {
        return !((DeviceInfo)x$1._2()).deviceStatAvailable();
    }

    public static final /* synthetic */ void $anonfun$init$2(LocalDeviceMonitor $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String deviceName = (String)tuple2._1();
        $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Device monitor may not work properly on ").append(deviceName).append(" ").append("because device ").append(deviceName).append(" not exists.").toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final DeviceMonitor.DiskUsageInfo usage$1(List x3$1) {
        return DeviceMonitor$.MODULE$.getDiskUsageInfos((DiskInfo)x3$1.head());
    }

    public static final /* synthetic */ void $anonfun$init$6(LocalDeviceMonitor $this, Tuple2 x0$2) {
        DeviceInfo deviceInfo;
        List diskInfos;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x0$2;
                if (tuple2 == null) break block2;
                DeviceInfo deviceInfo2 = (DeviceInfo)tuple2._1();
                diskInfos = (List)tuple2._2();
                if (deviceInfo2 == null) break block2;
                deviceInfo = deviceInfo2;
                if (diskInfos != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        List list = diskInfos;
        scala.collection.immutable.Map deviceLabel = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"device"), (Object)deviceInfo.name())}));
        $this.workerSource.addGauge(WorkerSource$.MODULE$.DEVICE_OS_TOTAL_CAPACITY(), deviceLabel, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> LocalDeviceMonitor.usage$1(list).totalSpace());
        $this.workerSource.addGauge(WorkerSource$.MODULE$.DEVICE_OS_FREE_CAPACITY(), deviceLabel, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> LocalDeviceMonitor.usage$1(list).freeSpace());
        $this.workerSource.addGauge(WorkerSource$.MODULE$.DEVICE_CELEBORN_TOTAL_CAPACITY(), deviceLabel, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.configuredUsableSpace()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        $this.workerSource.addGauge(WorkerSource$.MODULE$.DEVICE_CELEBORN_FREE_CAPACITY(), deviceLabel, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.actualUsableSpace()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public LocalDeviceMonitor(CelebornConf conf, DeviceObserver observer, Map<String, DeviceInfo> deviceInfos, Map<String, DiskInfo> diskInfos, AbstractSource workerSource) {
        this.org$apache$celeborn$service$deploy$worker$storage$LocalDeviceMonitor$$conf = conf;
        this.observer = observer;
        this.deviceInfos = deviceInfos;
        this.diskInfos = diskInfos;
        this.workerSource = workerSource;
        DeviceMonitor.$init$(this);
        Logging.$init$((Logging)this);
        this.diskCheckInterval = conf.workerDiskMonitorCheckInterval();
        this.deviceMonitorCheckList = conf.workerDiskMonitorCheckList();
        this.checkIoHang = this.deviceMonitorCheckList().contains((Object)"iohang");
        this.checkReadWrite = this.deviceMonitorCheckList().contains((Object)"readwrite");
        this.checkDiskUsage = this.deviceMonitorCheckList().contains((Object)"diskusage");
        this.diskChecker = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("worker-disk-checker");
    }
}

