/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.internal.config;

import java.io.Serializable;
import java.util.Map;
import org.apache.celeborn.common.internal.config.ConfigEntry;
import org.apache.celeborn.common.internal.config.ConfigEntry$;
import org.apache.celeborn.common.internal.config.ConfigEntryWithDefault;
import org.apache.celeborn.common.internal.config.ConfigEntryWithDefaultFunction;
import org.apache.celeborn.common.internal.config.ConfigEntryWithDefaultString;
import org.apache.celeborn.common.internal.config.ConfigProvider;
import org.apache.celeborn.common.internal.config.ConfigReader$;
import org.apache.celeborn.common.internal.config.EnvProvider;
import org.apache.celeborn.common.internal.config.FallbackConfigEntry;
import org.apache.celeborn.common.internal.config.MapProvider;
import org.apache.celeborn.common.internal.config.SystemProvider;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.util.matching.Regex;
import scala.util.matching.Regex$;

@ScalaSignature(bytes="\u0006\u0001\u0005-q!B\n\u0015\u0011\u0013\tc!B\u0012\u0015\u0011\u0013!\u0003\"B\u0016\u0002\t\u0003a\u0003bB\u0017\u0002\u0005\u0004%IA\f\u0005\u0007o\u0005\u0001\u000b\u0011B\u0018\u0007\t\r\"\u0002\u0001\u000f\u0005\ts\u0015\u0011\t\u0011)A\u0005u!)1&\u0002C\u0001{!)1&\u0002C\u0001\u0001\"9A+\u0002b\u0001\n\u0013)\u0006B\u00020\u0006A\u0003%a\u000bC\u0003`\u000b\u0011\u0005\u0001\rC\u0003`\u000b\u0011\u0005Q\rC\u0003j\u000b\u0011\u0005!\u000eC\u0003m\u000b\u0011\u0005Q\u000eC\u0003p\u000b\u0011\u0005\u0001\u000fC\u0003w\u000b\u0011\u0005q\u000fC\u0003w\u000b\u0011%!\u0010C\u0004\u0002\u0004\u0015!I!!\u0002\u0002\u0019\r{gNZ5h%\u0016\fG-\u001a:\u000b\u0005U1\u0012AB2p]\u001aLwM\u0003\u0002\u00181\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u001a5\u000511m\\7n_:T!a\u0007\u000f\u0002\u0011\r,G.\u001a2pe:T!!\b\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0012aA8sO\u000e\u0001\u0001C\u0001\u0012\u0002\u001b\u0005!\"\u0001D\"p]\u001aLwMU3bI\u0016\u00148CA\u0001&!\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!I\u0001\u0007%\u00163uLU#\u0016\u0003=\u0002\"\u0001M\u001b\u000e\u0003ER!AM\u001a\u0002\u00115\fGo\u00195j]\u001eT!\u0001N\u0014\u0002\tU$\u0018\u000e\\\u0005\u0003mE\u0012QAU3hKb\fqAU#G?J+\u0005e\u0005\u0002\u0006K\u0005!1m\u001c8g!\t\u00113(\u0003\u0002=)\tq1i\u001c8gS\u001e\u0004&o\u001c<jI\u0016\u0014HC\u0001 @!\t\u0011S\u0001C\u0003:\u000f\u0001\u0007!\b\u0006\u0002?\u0003\")\u0011\b\u0003a\u0001\u0005B!1iR%J\u001b\u0005!%B\u0001\u001bF\u0015\u00051\u0015\u0001\u00026bm\u0006L!\u0001\u0013#\u0003\u00075\u000b\u0007\u000f\u0005\u0002K#:\u00111j\u0014\t\u0003\u0019\u001ej\u0011!\u0014\u0006\u0003\u001d\u0002\na\u0001\u0010:p_Rt\u0014B\u0001)(\u0003\u0019\u0001&/\u001a3fM&\u0011!k\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005A;\u0013\u0001\u00032j]\u0012LgnZ:\u0016\u0003Y\u0003Ba\u0016/Ju5\t\u0001L\u0003\u0002Z5\u00069Q.\u001e;bE2,'BA.(\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003;b\u0013q\u0001S1tQ6\u000b\u0007/A\u0005cS:$\u0017N\\4tA\u0005!!-\u001b8e)\rq\u0014m\u0019\u0005\u0006E.\u0001\r!S\u0001\u0007aJ,g-\u001b=\t\u000b\u0011\\\u0001\u0019\u0001\u001e\u0002\u0011A\u0014xN^5eKJ$2A\u00104h\u0011\u0015\u0011G\u00021\u0001J\u0011\u0015AG\u00021\u0001C\u0003\u00191\u0018\r\\;fg\u00069!-\u001b8e\u000b:4HC\u0001 l\u0011\u0015!W\u00021\u0001;\u0003)\u0011\u0017N\u001c3TsN$X-\u001c\u000b\u0003}9DQ\u0001\u001a\bA\u0002i\n1aZ3u)\t\tH\u000fE\u0002'e&K!a]\u0014\u0003\r=\u0003H/[8o\u0011\u0015)x\u00021\u0001J\u0003\rYW-_\u0001\u000bgV\u00147\u000f^5ukR,GCA%y\u0011\u0015I\b\u00031\u0001J\u0003\u0015Ig\u000e];u)\rI5\u0010 \u0005\u0006sF\u0001\r!\u0013\u0005\u0006{F\u0001\rA`\u0001\tkN,GMU3ggB\u0019!j`%\n\u0007\u0005\u00051KA\u0002TKR\fAbZ3u\u001fJ$UMZ1vYR$R!]A\u0004\u0003\u0013AQ!\u000f\nA\u0002iBQ!\u001e\nA\u0002%\u0003")
public class ConfigReader {
    private final ConfigProvider conf;
    private final HashMap<String, ConfigProvider> bindings;

    private HashMap<String, ConfigProvider> bindings() {
        return this.bindings;
    }

    public ConfigReader bind(String prefix, ConfigProvider provider) {
        this.bindings().update(prefix, provider);
        return this;
    }

    public ConfigReader bind(String prefix, Map<String, String> values) {
        return this.bind(prefix, new MapProvider(values));
    }

    public ConfigReader bindEnv(ConfigProvider provider) {
        return this.bind("env", provider);
    }

    public ConfigReader bindSystem(ConfigProvider provider) {
        return this.bind("system", provider);
    }

    public Option<String> get(String key) {
        return this.conf.get(key).map((Function1<String, String> & Serializable & scala.Serializable)input -> this.substitute((String)input));
    }

    public String substitute(String input) {
        return this.substitute(input, (Set)Predef$.MODULE$.Set().apply(Nil$.MODULE$));
    }

    private String substitute(String input, Set<String> usedRefs) {
        return input != null ? ConfigReader$.MODULE$.org$apache$celeborn$common$internal$config$ConfigReader$$REF_RE().replaceAllIn((CharSequence)input, (Function1<Regex.Match, String> & Serializable & scala.Serializable)m -> {
            String prefix = m.group(1);
            String name = m.group(2);
            String ref = prefix == null ? name : new StringBuilder(1).append(prefix).append(":").append(name).toString();
            Predef$.MODULE$.require(!usedRefs.contains(ref), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Circular reference in ").append(input).append(": ").append(ref).toString());
            String replacement = (String)this.bindings().get(prefix).flatMap((Function1<ConfigProvider, Option> & Serializable & scala.Serializable)x$1 -> this.getOrDefault((ConfigProvider)x$1, name)).map((Function1<String, String> & Serializable & scala.Serializable)v -> this.substitute((String)v, (Set)usedRefs.$plus(ref))).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> m.matched());
            return Regex$.MODULE$.quoteReplacement(replacement);
        }) : input;
    }

    private Option<String> getOrDefault(ConfigProvider conf, String key) {
        return conf.get(key).orElse((Function0<Option> & Serializable & scala.Serializable)() -> {
            Option option;
            ConfigEntry<?> configEntry = ConfigEntry$.MODULE$.findEntry(key);
            if (configEntry instanceof ConfigEntryWithDefault) {
                ConfigEntryWithDefault configEntryWithDefault = (ConfigEntryWithDefault)configEntry;
                option = Option$.MODULE$.apply(configEntryWithDefault.defaultValueString());
            } else if (configEntry instanceof ConfigEntryWithDefaultString) {
                ConfigEntryWithDefaultString configEntryWithDefaultString = (ConfigEntryWithDefaultString)configEntry;
                option = Option$.MODULE$.apply(configEntryWithDefaultString.defaultValueString());
            } else if (configEntry instanceof ConfigEntryWithDefaultFunction) {
                ConfigEntryWithDefaultFunction configEntryWithDefaultFunction = (ConfigEntryWithDefaultFunction)configEntry;
                option = Option$.MODULE$.apply(configEntryWithDefaultFunction.defaultValueString());
            } else if (configEntry instanceof FallbackConfigEntry) {
                FallbackConfigEntry fallbackConfigEntry = (FallbackConfigEntry)configEntry;
                option = this.getOrDefault(conf, fallbackConfigEntry.fallback().key());
            } else {
                option = None$.MODULE$;
            }
            return option;
        });
    }

    public ConfigReader(ConfigProvider conf) {
        this.conf = conf;
        this.bindings = new HashMap();
        this.bind(null, conf);
        this.bindEnv(new EnvProvider());
        this.bindSystem(new SystemProvider());
    }

    public ConfigReader(Map<String, String> conf) {
        this(new MapProvider(conf));
    }
}

