/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer bbuf, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (bbuf.hasArray()) {
            gen.writeBinary(bbuf.array(), bbuf.arrayOffset(), bbuf.limit());
            return;
        }
        ByteBuffer copy = bbuf.asReadOnlyBuffer();
        if (copy.position() > 0) {
            copy.rewind();
        }
        ByteBufferBackedInputStream in = new ByteBufferBackedInputStream(copy);
        gen.writeBinary(in, copy.remaining());
        in.close();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

