/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.utils;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.sidecar.common.server.ICassandraFactory;
import org.apache.cassandra.sidecar.common.server.MinimumVersion;

public class SimpleCassandraVersion
implements Comparable<SimpleCassandraVersion> {
    private static final String VERSION_REGEXP = "(\\d+)\\.(\\d+)(?:\\.(\\w+))?(\\-[.\\w]+)?([.+][.\\w]+)?";
    private static final Pattern PATTERN = Pattern.compile("(\\d+)\\.(\\d+)(?:\\.(\\w+))?(\\-[.\\w]+)?([.+][.\\w]+)?");
    private static final String SNAPSHOT = "-SNAPSHOT";
    public final int major;
    public final int minor;
    public final int patch;

    public static SimpleCassandraVersion create(String version) throws IllegalArgumentException {
        String stripped = version.toUpperCase().replace(SNAPSHOT, "");
        Matcher matcher = PATTERN.matcher(stripped);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid Cassandra version value: " + version);
        }
        try {
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            int patch = matcher.group(3) != null ? Integer.parseInt(matcher.group(3)) : 0;
            return SimpleCassandraVersion.create(major, minor, patch);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid Cassandra version value: " + version, e);
        }
    }

    public static SimpleCassandraVersion create(int major, int minor, int patch) {
        if (major < 0 || minor < 0 || patch < 0) {
            throw new IllegalArgumentException();
        }
        return new SimpleCassandraVersion(major, minor, patch);
    }

    public static SimpleCassandraVersion create(ICassandraFactory factory) {
        return SimpleCassandraVersion.create(factory.getClass().getAnnotation(MinimumVersion.class).value());
    }

    private SimpleCassandraVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    @Override
    public int compareTo(SimpleCassandraVersion other) {
        if (this.major < other.major) {
            return -1;
        }
        if (this.major > other.major) {
            return 1;
        }
        if (this.minor < other.minor) {
            return -1;
        }
        if (this.minor > other.minor) {
            return 1;
        }
        if (this.patch < other.patch) {
            return -1;
        }
        if (this.patch > other.patch) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SimpleCassandraVersion)) {
            return false;
        }
        SimpleCassandraVersion that = (SimpleCassandraVersion)o;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch;
    }

    public boolean isGreaterThan(SimpleCassandraVersion v2) {
        return this.compareTo(v2) > 0;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append('.').append(this.minor).append('.').append(this.patch);
        return sb.toString();
    }
}

