/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.common.request.data.NodeCommandRequestPayload;
import org.apache.cassandra.sidecar.common.server.StorageOperations;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.handlers.AccessProtected;
import org.apache.cassandra.sidecar.handlers.NodeCommandHandler;
import org.apache.cassandra.sidecar.modules.ApiModule;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.NotNull;

@Singleton
public class NativeUpdateHandler
extends NodeCommandHandler
implements AccessProtected {
    @Inject
    public NativeUpdateHandler(InstanceMetadataFetcher metadataFetcher, ExecutorPools executorPools) {
        super(metadataFetcher, executorPools, null);
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Collections.singleton(BasicPermissions.MODIFY_NATIVE.toAuthorization());
    }

    @Override
    protected void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, NodeCommandRequestPayload request) {
        StorageOperations storageOps = this.metadataFetcher.delegate(host).storageOperations();
        this.executorPools.service().runBlocking(() -> {
            switch (request.state()) {
                case START: {
                    storageOps.startNativeTransport();
                    break;
                }
                case STOP: {
                    storageOps.stopNativeTransport();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state: " + request.state());
                }
            }
        }).onSuccess(ignored -> context.json(ApiModule.OK_STATUS)).onFailure(cause -> this.processFailure((Throwable)cause, context, host, remoteAddress, request));
    }
}

