/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.providers;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth;

@VertxGen
public interface IBMCloudAuth
extends OpenIDConnectAuth {
    public static OAuth2Auth create(Vertx vertx, String region, String clientId, String clientSecret, String guid) {
        return IBMCloudAuth.create(vertx, region, clientId, clientSecret, guid, new HttpClientOptions());
    }

    public static OAuth2Auth create(Vertx vertx, String region, String clientId, String clientSecret, String guid, HttpClientOptions httpClientOptions) {
        if (region == null) {
            throw new IllegalStateException("region cannot be null");
        }
        return OAuth2Auth.create(vertx, new OAuth2Options().setHttpClientOptions(httpClientOptions).setFlow(OAuth2FlowType.AUTH_CODE).setClientId(clientId).setClientSecret(clientSecret).setTenant(guid).setSite("https://" + region + ".appid.cloud.ibm.com/oauth/v4/{tenant}").setTokenPath("/token").setAuthorizationPath("/authorization").setJwkPath("/publickeys").setUserInfoPath("/userinfo"));
    }

    public static void discover(Vertx vertx, OAuth2Options config, Handler<AsyncResult<OAuth2Auth>> handler) {
        IBMCloudAuth.discover(vertx, config).onComplete(handler);
    }

    public static Future<OAuth2Auth> discover(Vertx vertx, OAuth2Options config) {
        return OpenIDConnectAuth.discover(vertx, config);
    }
}

