/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.util;

import com.datastax.oss.driver.internal.mapper.processor.util.ResolvedAnnotation;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class AnnotationScanner {
    public static <A extends Annotation> Optional<ResolvedAnnotation<A>> getClassAnnotation(Class<A> annotationType, Set<TypeElement> typeHierarchy) {
        for (TypeElement element : typeHierarchy) {
            A annotation = element.getAnnotation(annotationType);
            if (annotation == null) continue;
            return Optional.of(new ResolvedAnnotation<A>(annotation, element));
        }
        return Optional.empty();
    }

    public static <A extends Annotation> Optional<ResolvedAnnotation<A>> getMethodAnnotation(Class<A> annotationType, ExecutableElement getMethod, Set<TypeElement> typeHierarchy) {
        A annotation = getMethod.getAnnotation(annotationType);
        if (annotation != null) {
            return Optional.of(new ResolvedAnnotation<A>(annotation, getMethod));
        }
        for (TypeElement typeElement : typeHierarchy) {
            for (Element element : typeElement.getEnclosedElements()) {
                ExecutableElement candidateMethod;
                TypeMirror typeMirror;
                Set<Modifier> modifiers = element.getModifiers();
                if (element.getKind() != ElementKind.METHOD || modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.PRIVATE) || (typeMirror = (candidateMethod = (ExecutableElement)element).getReturnType()).getKind() == TypeKind.VOID || !candidateMethod.getSimpleName().equals(getMethod.getSimpleName()) || (annotation = candidateMethod.getAnnotation(annotationType)) == null) continue;
                return Optional.of(new ResolvedAnnotation<A>(annotation, candidateMethod));
            }
        }
        return Optional.empty();
    }
}

