/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import com.google.common.collect.Range;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;

abstract class AbstractMapSerializer<T>
extends CollectionSerializer<T> {
    private final boolean hasValues;
    private final String name;

    protected AbstractMapSerializer(boolean hasValues) {
        this.hasValues = hasValues;
        this.name = hasValues ? "map" : "set";
    }

    @Override
    public ByteBuffer getSliceFromSerialized(ByteBuffer collection, ByteBuffer from, ByteBuffer to, AbstractType<?> comparator, boolean frozen) {
        if (from == ByteBufferUtil.UNSET_BYTE_BUFFER && to == ByteBufferUtil.UNSET_BYTE_BUFFER) {
            return collection;
        }
        try {
            ByteBuffer input = collection.duplicate();
            int n = AbstractMapSerializer.readCollectionSize(input, ByteBufferAccessor.instance);
            input.position(input.position() + AbstractMapSerializer.sizeOfCollectionSize());
            int startPos = input.position();
            int count = 0;
            boolean inSlice = from == ByteBufferUtil.UNSET_BYTE_BUFFER;
            for (int i = 0; i < n; ++i) {
                int comparison;
                int pos = input.position();
                ByteBuffer key = AbstractMapSerializer.readValue(input, ByteBufferAccessor.instance, 0);
                input.position(input.position() + AbstractMapSerializer.sizeOfValue(key, ByteBufferAccessor.instance));
                if (!inSlice) {
                    comparison = comparator.compareForCQL(from, key);
                    if (comparison <= 0) {
                        inSlice = true;
                        startPos = pos;
                    } else {
                        this.skipMapValue(input);
                        continue;
                    }
                }
                int n2 = comparison = to == ByteBufferUtil.UNSET_BYTE_BUFFER ? -1 : comparator.compareForCQL(key, to);
                if (comparison > 0) {
                    input.position(pos);
                    break;
                }
                this.skipMapValue(input);
                ++count;
                if (comparison == 0) break;
            }
            if (count == 0 && !frozen) {
                return null;
            }
            return this.copyAsNewCollection(collection, count, startPos, input.position());
        }
        catch (IndexOutOfBoundsException | BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a " + this.name);
        }
    }

    @Override
    public int getIndexFromSerialized(ByteBuffer collection, ByteBuffer key, AbstractType<?> comparator) {
        try {
            ByteBuffer input = collection.duplicate();
            int n = AbstractMapSerializer.readCollectionSize(input, ByteBufferAccessor.instance);
            int offset = AbstractMapSerializer.sizeOfCollectionSize();
            for (int i = 0; i < n; ++i) {
                ByteBuffer kbb = AbstractMapSerializer.readValue(input, ByteBufferAccessor.instance, offset);
                offset += AbstractMapSerializer.sizeOfValue(kbb, ByteBufferAccessor.instance);
                int comparison = comparator.compareForCQL(kbb, key);
                if (comparison == 0) {
                    return i;
                }
                if (comparison > 0) {
                    return -1;
                }
                if (!this.hasValues) continue;
                offset += AbstractMapSerializer.skipValue(input, ByteBufferAccessor.instance, offset);
            }
            return -1;
        }
        catch (BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a " + this.name);
        }
    }

    @Override
    public Range<Integer> getIndexesRangeFromSerialized(ByteBuffer collection, ByteBuffer from, ByteBuffer to, AbstractType<?> comparator) {
        if (from == ByteBufferUtil.UNSET_BYTE_BUFFER && to == ByteBufferUtil.UNSET_BYTE_BUFFER) {
            return Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE));
        }
        try {
            ByteBuffer input = collection.duplicate();
            int n = AbstractMapSerializer.readCollectionSize(input, ByteBufferAccessor.instance);
            input.position(input.position() + AbstractMapSerializer.sizeOfCollectionSize());
            int start = from == ByteBufferUtil.UNSET_BYTE_BUFFER ? 0 : -1;
            int end = to == ByteBufferUtil.UNSET_BYTE_BUFFER ? n : -1;
            for (int i = 0; i < n && (start < 0 || end < 0); ++i) {
                int comparison;
                if (i > 0) {
                    this.skipMapValue(input);
                }
                ByteBuffer key = AbstractMapSerializer.readValue(input, ByteBufferAccessor.instance, 0);
                input.position(input.position() + AbstractMapSerializer.sizeOfValue(key, ByteBufferAccessor.instance));
                if (start < 0) {
                    comparison = comparator.compareForCQL(from, key);
                    if (comparison > 0) continue;
                    start = i;
                }
                if (end >= 0 || (comparison = comparator.compareForCQL(key, to)) <= 0) continue;
                end = i;
            }
            if (start < 0) {
                return Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));
            }
            if (end < 0) {
                return Range.closedOpen((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(n));
            }
            return Range.closedOpen((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end));
        }
        catch (BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a " + this.name);
        }
    }

    private void skipMapValue(ByteBuffer input) {
        if (this.hasValues) {
            AbstractMapSerializer.skipValue(input);
        }
    }
}

