/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.bitpack;

import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.index.sai.disk.io.SeekingRandomAccessInput;
import org.apache.cassandra.index.sai.disk.v1.LongArray;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.packed.DirectReader;

@NotThreadSafe
public abstract class AbstractBlockPackedReader
implements LongArray {
    private final int blockShift;
    private final int blockMask;
    private final long valueCount;
    private final byte[] blockBitsPerValue;
    private final SeekingRandomAccessInput input;
    private long previousValue = Long.MIN_VALUE;
    private long lastIndex;

    AbstractBlockPackedReader(IndexInput indexInput, byte[] blockBitsPerValue, int blockShift, int blockMask, long valueCount) {
        this.blockShift = blockShift;
        this.blockMask = blockMask;
        this.valueCount = valueCount;
        this.input = new SeekingRandomAccessInput(indexInput);
        this.blockBitsPerValue = blockBitsPerValue;
    }

    protected abstract long blockOffsetAt(int var1);

    @Override
    public long get(long valueIndex) {
        if (valueIndex < 0L || valueIndex >= this.valueCount) {
            throw new IndexOutOfBoundsException(String.format("Index should be between [0, %d), but was %d.", this.valueCount, valueIndex));
        }
        int blockIndex = (int)(valueIndex >>> this.blockShift);
        int inBlockIndex = (int)(valueIndex & (long)this.blockMask);
        byte bitsPerValue = this.blockBitsPerValue[blockIndex];
        LongValues subReader = bitsPerValue == 0 ? LongValues.ZEROES : DirectReader.getInstance((RandomAccessInput)this.input, (int)bitsPerValue, (long)this.blockOffsetAt(blockIndex));
        return this.delta(blockIndex, inBlockIndex) + subReader.get((long)inBlockIndex);
    }

    @Override
    public long length() {
        return this.valueCount;
    }

    @Override
    public long indexOf(long value) {
        boolean exactMatch;
        if (value < this.previousValue) {
            this.lastIndex = 0L;
        }
        if (this.lastIndex >= this.valueCount) {
            return -1L;
        }
        this.previousValue = value;
        int blockIndex = this.binarySearchBlockMinValues(value);
        boolean bl = exactMatch = blockIndex >= 0;
        if (blockIndex < 0) {
            blockIndex = -blockIndex;
        }
        if (blockIndex > 0) {
            --blockIndex;
        }
        this.lastIndex = this.findBlockRowID(value, blockIndex, exactMatch);
        return this.lastIndex >= this.valueCount ? -1L : this.lastIndex;
    }

    private int binarySearchBlockMinValues(long targetValue) {
        int high = Math.toIntExact(this.blockBitsPerValue.length) - 1;
        int low = Math.toIntExact(this.lastIndex >> this.blockShift);
        if (low + 1 <= high) {
            long cmp = Long.compare(targetValue, this.delta(low + 1, 0));
            if (cmp == 0L) {
                return low + 1;
            }
            if (cmp < 0L) {
                return -low - 1;
            }
            ++low;
        }
        while (low <= high) {
            int mid = low + (high - low >> 1);
            long midVal = this.delta(mid, 0);
            if (midVal < targetValue) {
                low = mid + 1;
                continue;
            }
            if (midVal > targetValue) {
                high = mid - 1;
                continue;
            }
            if (mid > 0 && this.delta(mid - 1, 0) == targetValue) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low;
    }

    private long findBlockRowID(long targetValue, long blockIdx, boolean exactMatch) {
        long offset = blockIdx << this.blockShift;
        long low = Math.max(this.lastIndex, offset);
        long high = Math.min(offset + (long)this.blockMask + (long)(exactMatch ? 1 : 0), this.valueCount - 1L);
        return this.binarySearchBlock(targetValue, low, high);
    }

    private long binarySearchBlock(long target, long low, long high) {
        while (low <= high) {
            long mid = low + (high - low >> 1);
            long midVal = this.get(mid);
            if (midVal < target) {
                low = mid + 1L;
                this.lastIndex = mid;
                continue;
            }
            if (midVal > target) {
                high = mid - 1L;
                continue;
            }
            if (mid > 0L && this.get(mid - 1L) == target) {
                high = mid - 1L;
                continue;
            }
            return mid;
        }
        return low;
    }

    abstract long delta(int var1, int var2);
}

