/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.map;

import java.util.Iterator;
import java.util.Map;
import org.psjava.ds.KeyValuePair;
import org.psjava.ds.KeyValuePairEqualityTester;
import org.psjava.ds.KeyValuePairHash;
import org.psjava.util.ConvertedDataIterator;
import org.psjava.util.DataConverter;
import org.psjava.util.EqualityTester;
import org.psjava.util.StrictEqualityTester;

public class MapIteratorFromJavaMap {
    public static <K, V> Iterator<KeyValuePair<K, V>> create(Map<K, V> map) {
        return ConvertedDataIterator.create(map.entrySet().iterator(), new DataConverter<Map.Entry<K, V>, KeyValuePair<K, V>>(){

            @Override
            public KeyValuePair<K, V> convert(Map.Entry<K, V> e) {
                return new EntryWrapper(e);
            }
        });
    }

    private MapIteratorFromJavaMap() {
    }

    private static class EntryWrapper<K, V>
    implements KeyValuePair<K, V>,
    EqualityTester<EntryWrapper<K, V>> {
        private Map.Entry<K, V> e;

        private EntryWrapper(Map.Entry<K, V> e) {
            this.e = e;
        }

        @Override
        public K getKey() {
            return this.e.getKey();
        }

        @Override
        public V getValue() {
            return this.e.getValue();
        }

        public boolean equals(Object obj) {
            return StrictEqualityTester.areEqual(this, obj, this);
        }

        @Override
        public boolean areEqual(EntryWrapper<K, V> o1, EntryWrapper<K, V> o2) {
            return KeyValuePairEqualityTester.are(o1, o2);
        }

        public int hashCode() {
            return KeyValuePairHash.hash(this);
        }
    }
}

