/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.kv;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.apache.bookkeeper.clients.exceptions.InternalServerException;
import org.apache.bookkeeper.clients.impl.channel.StorageServerChannel;
import org.apache.bookkeeper.clients.impl.container.StorageContainerChannel;
import org.apache.bookkeeper.clients.utils.ListenableFutureRpcProcessor;
import org.apache.bookkeeper.common.util.Backoff;
import org.apache.bookkeeper.stream.proto.kv.rpc.IncrementRequest;
import org.apache.bookkeeper.stream.proto.kv.rpc.IncrementResponse;
import org.apache.bookkeeper.stream.proto.storage.StatusCode;

class IncrementRequestProcessor<RespT>
extends ListenableFutureRpcProcessor<IncrementRequest, IncrementResponse, RespT> {
    private final IncrementRequest request;
    private final Function<IncrementResponse, RespT> responseFunc;

    public static <T> IncrementRequestProcessor<T> of(IncrementRequest request, Function<IncrementResponse, T> responseFunc, StorageContainerChannel channel, ScheduledExecutorService executor, Backoff.Policy backoffPolicy) {
        return new IncrementRequestProcessor<T>(request, responseFunc, channel, executor, backoffPolicy);
    }

    private IncrementRequestProcessor(IncrementRequest request, Function<IncrementResponse, RespT> respFunc, StorageContainerChannel channel, ScheduledExecutorService executor, Backoff.Policy backoffPolicy) {
        super(channel, executor, backoffPolicy);
        this.request = request;
        this.responseFunc = respFunc;
    }

    @Override
    protected IncrementRequest createRequest() {
        return this.request;
    }

    @Override
    protected ListenableFuture<IncrementResponse> sendRPC(StorageServerChannel rsChannel, IncrementRequest request) {
        return rsChannel.getTableService().increment(request);
    }

    @Override
    protected RespT processResponse(IncrementResponse response) throws Exception {
        if (StatusCode.SUCCESS == response.getHeader().getCode()) {
            return this.responseFunc.apply(response);
        }
        throw new InternalServerException("Encountered internal server exception : code = " + (Object)((Object)response.getHeader().getCode()));
    }
}

