/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumUtil;
import org.apache.zookeeper.test.RestoreCommittedLogTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmptiedSnapshotRecoveryTest
extends ZKTestCase
implements Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(RestoreCommittedLogTest.class);
    private static String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private static final int CONNECTION_TIMEOUT = 3000;
    private static final int N_TRANSACTIONS = 150;
    private static final int SNAP_COUNT = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(boolean leaveEmptyFile, boolean trustEmptySnap) throws Exception {
        File tmpSnapDir = ClientBase.createTmpDir();
        File tmpLogDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpSnapDir, tmpLogDir, 3000);
        SyncRequestProcessor.setSnapCount((int)100);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L), (String)"waiting for server being up ");
        try (ZooKeeper zk = new ZooKeeper(HOSTPORT, 3000, (Watcher)this);){
            for (int i = 0; i < 150; ++i) {
                zk.create("/node-" + i, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        f.shutdown();
        zks.shutdown();
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown(HOSTPORT, 3000L), (String)"waiting for server to shutdown");
        zks = new ZooKeeperServer(tmpSnapDir, tmpLogDir, 3000);
        zks.startdata();
        long zxid = zks.getZKDatabase().getDataTreeLastProcessedZxid();
        LOG.info("After clean restart, zxid = {}", (Object)zxid);
        Assertions.assertTrue((zxid > 0L ? 1 : 0) != 0, (String)"zxid > 0");
        zks.shutdown();
        FileTxnSnapLog txnLogFactory = zks.getTxnLogFactory();
        List snapshots = txnLogFactory.findNRecentSnapshots(10);
        Assertions.assertTrue((snapshots.size() > 0 ? 1 : 0) != 0, (String)"We have a snapshot to corrupt");
        for (File file : snapshots) {
            if (leaveEmptyFile) {
                new PrintWriter(file).close();
                continue;
            }
            file.delete();
        }
        if (trustEmptySnap) {
            System.setProperty("zookeeper.snapshot.trust.empty", "true");
        }
        zks = new ZooKeeperServer(tmpSnapDir, tmpLogDir, 3000);
        try {
            zks.startdata();
            long currentZxid = zks.getZKDatabase().getDataTreeLastProcessedZxid();
            if (!trustEmptySnap) {
                Assertions.fail((String)"Should have gotten exception for corrupted database");
            }
            Assertions.assertEquals((long)currentZxid, (long)zxid, (String)"zxid mismatch after restoring database");
        }
        catch (IOException e) {
            if (trustEmptySnap) {
                Assertions.fail((String)"Should not get exception for empty database");
            }
        }
        finally {
            if (trustEmptySnap) {
                System.clearProperty("zookeeper.snapshot.trust.empty");
            }
        }
        zks.shutdown();
    }

    @Test
    public void testRestoreWithEmptySnapFiles() throws Exception {
        this.runTest(true, false);
    }

    @Test
    public void testRestoreWithNoSnapFiles() throws Exception {
        this.runTest(false, false);
    }

    @Test
    public void testRestoreWithTrustedEmptySnapFiles() throws Exception {
        this.runTest(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoreWithTrustedEmptySnapFilesWhenFollowing() throws Exception {
        QuorumUtil qu = new QuorumUtil(1);
        try {
            List snapshots;
            FileTxnSnapLog txnLogFactory;
            int i;
            qu.startAll();
            String connString = qu.getConnectionStringForServer(1);
            try (ZooKeeper zk = new ZooKeeper(connString, 3000, (Watcher)this);){
                for (i = 0; i < 150; ++i) {
                    zk.create("/node-" + i, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
            }
            int leaderIndex = qu.getLeaderServer();
            for (i = 1; i <= qu.ALL; ++i) {
                qu.shutdown(i);
                if (i == leaderIndex) continue;
                txnLogFactory = qu.getPeer((int)i).peer.getTxnFactory();
                snapshots = txnLogFactory.findNRecentSnapshots(10);
                Assertions.assertTrue((snapshots.size() > 0 ? 1 : 0) != 0, (String)"We have a snapshot to corrupt");
                for (File file : snapshots) {
                    Files.delete(file.toPath());
                }
                Assertions.assertEquals((int)txnLogFactory.findNRecentSnapshots(10).size(), (int)0);
            }
            System.setProperty("zookeeper.snapshot.trust.empty", "true");
            qu.start(leaderIndex);
            for (i = 1; i <= qu.ALL; ++i) {
                if (i == leaderIndex) continue;
                qu.restart(i);
                txnLogFactory = qu.getPeer((int)i).peer.getTxnFactory();
                snapshots = txnLogFactory.findNRecentSnapshots(10);
                Assertions.assertTrue((snapshots.size() > 0 ? 1 : 0) != 0, (String)("A snapshot should have been created on follower " + i));
            }
            try (ZooKeeper zk = new ZooKeeper(connString, 3000, (Watcher)this);){
                for (int i2 = 0; i2 < 150; ++i2) {
                    Assertions.assertNotNull((Object)zk.exists("/node-" + i2, false));
                }
            }
        }
        finally {
            System.clearProperty("zookeeper.snapshot.trust.empty");
            qu.tearDown();
        }
    }

    public void process(WatchedEvent event) {
    }
}

