/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.util.Recycler;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.CompletionKey;

class EntryCompletionKey
extends CompletionKey {
    private final Recycler.Handle<EntryCompletionKey> recyclerHandle;
    long ledgerId;
    long entryId;
    private static final Recycler<EntryCompletionKey> V2_KEY_RECYCLER = new Recycler<EntryCompletionKey>(){

        protected EntryCompletionKey newObject(Recycler.Handle<EntryCompletionKey> handle) {
            return new EntryCompletionKey(handle);
        }
    };

    static EntryCompletionKey acquireV2Key(long ledgerId, long entryId, BookkeeperProtocol.OperationType operationType) {
        EntryCompletionKey key = (EntryCompletionKey)V2_KEY_RECYCLER.get();
        key.reset(ledgerId, entryId, operationType);
        return key;
    }

    private EntryCompletionKey(Recycler.Handle<EntryCompletionKey> handle) {
        super(null);
        this.recyclerHandle = handle;
    }

    void reset(long ledgerId, long entryId, BookkeeperProtocol.OperationType operationType) {
        this.ledgerId = ledgerId;
        this.entryId = entryId;
        this.operationType = operationType;
    }

    public boolean equals(Object object) {
        if (!(object instanceof EntryCompletionKey)) {
            return false;
        }
        EntryCompletionKey that = (EntryCompletionKey)object;
        return this.entryId == that.entryId && this.ledgerId == that.ledgerId && this.operationType == that.operationType;
    }

    public int hashCode() {
        return Long.hashCode(this.ledgerId) * 31 + Long.hashCode(this.entryId);
    }

    public String toString() {
        return String.format("%d:%d %s", this.ledgerId, this.entryId, this.operationType);
    }

    @Override
    public void release() {
        this.recyclerHandle.recycle((Object)this);
    }
}

