/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.Entry;
import org.apache.distributedlog.EnvelopedEntry;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.RecordStream;

@NotThreadSafe
class EnvelopedEntryReader
implements Entry.Reader,
RecordStream {
    private final long logSegmentSeqNo;
    private final long entryId;
    private final ByteBuf src;
    private final LogRecord.Reader reader;
    private long slotId = 0L;
    private IOException lastException = null;
    private boolean isExhausted = false;

    EnvelopedEntryReader(long logSegmentSeqNo, long entryId, long startSequenceId, ByteBuf in, boolean envelopedEntry, boolean deserializeRecordSet, StatsLogger statsLogger) throws IOException {
        this.logSegmentSeqNo = logSegmentSeqNo;
        this.entryId = entryId;
        this.src = envelopedEntry ? EnvelopedEntry.fromEnvelopedBuf(in, statsLogger) : in;
        this.reader = new LogRecord.Reader((RecordStream)this, this.src, startSequenceId, deserializeRecordSet);
    }

    @VisibleForTesting
    boolean isExhausted() {
        return this.isExhausted;
    }

    @VisibleForTesting
    ByteBuf getSrcBuf() {
        return this.src;
    }

    private void checkLastException() throws IOException {
        if (null != this.lastException) {
            throw this.lastException;
        }
    }

    private void releaseBuffer() {
        this.isExhausted = true;
        ReferenceCountUtil.release((Object)this.src);
    }

    @Override
    public long getLSSN() {
        return this.logSegmentSeqNo;
    }

    @Override
    public long getEntryId() {
        return this.entryId;
    }

    @Override
    public LogRecordWithDLSN nextRecord() throws IOException {
        LogRecordWithDLSN record;
        this.checkLastException();
        if (this.isExhausted) {
            return null;
        }
        try {
            record = this.reader.readOp();
        }
        catch (IOException ioe) {
            this.lastException = ioe;
            this.releaseBuffer();
            throw ioe;
        }
        if (null == record) {
            this.releaseBuffer();
        }
        return record;
    }

    @Override
    public void release() {
        if (this.isExhausted) {
            return;
        }
        this.releaseBuffer();
    }

    @Override
    public boolean skipTo(long txId) throws IOException {
        this.checkLastException();
        return this.reader.skipTo(txId, true);
    }

    @Override
    public boolean skipTo(DLSN dlsn) throws IOException {
        this.checkLastException();
        return this.reader.skipTo(dlsn);
    }

    public void advance(int numRecords) {
        this.slotId += (long)numRecords;
    }

    public DLSN getCurrentPosition() {
        return new DLSN(this.logSegmentSeqNo, this.entryId, this.slotId);
    }

    public String getName() {
        return "EnvelopedReader";
    }
}

