/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.admin;

import java.io.File;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.admin.SnapshotAndRestoreCommandTest;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RestoreQuorumTest
extends QuorumPeerTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoreAfterQuorumLost() throws Exception {
        this.setupAdminServerProperties();
        int SERVER_COUNT = 3;
        int NODE_COUNT = 10;
        String PATH = "/testRestoreAfterQuorumLost";
        try {
            int i;
            this.servers = this.LaunchServers(SERVER_COUNT);
            int leaderId = this.servers.findLeader();
            this.servers.zk[leaderId].create("/testRestoreAfterQuorumLost", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            for (int i2 = 0; i2 < 10; ++i2) {
                this.servers.zk[leaderId].create("/testRestoreAfterQuorumLost/" + i2, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            File snapshotFile = SnapshotAndRestoreCommandTest.takeSnapshotAndValidate(this.servers.adminPorts[leaderId], ClientBase.testBaseDir);
            for (i = 10; i < 20; ++i) {
                this.servers.zk[leaderId].create("/testRestoreAfterQuorumLost/" + i, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            this.servers.shutDownAllServers();
            this.waitForAll(this.servers, ZooKeeper.States.CONNECTING);
            for (i = 0; i < SERVER_COUNT; ++i) {
                System.setProperty("zookeeper.admin.serverPort", String.valueOf(this.servers.adminPorts[i]));
                this.servers.mt[i].start();
                this.servers.restartClient(i, this);
            }
            this.waitForAll(this.servers, ZooKeeper.States.CONNECTED);
            for (i = 0; i < SERVER_COUNT; ++i) {
                SnapshotAndRestoreCommandTest.performRestoreAndValidate(this.servers.adminPorts[i], snapshotFile);
            }
            for (i = 0; i < SERVER_COUNT; ++i) {
                this.servers.restartClient(i, this);
                Assertions.assertEquals((int)10, (int)this.servers.zk[i].getAllChildrenNumber("/testRestoreAfterQuorumLost"));
            }
            for (i = 20; i < 30; ++i) {
                this.servers.zk[leaderId].create("/testRestoreAfterQuorumLost/" + i, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
            }
            for (i = 0; i < SERVER_COUNT; ++i) {
                Assertions.assertEquals((int)20, (int)this.servers.zk[i].getAllChildrenNumber("/testRestoreAfterQuorumLost"));
            }
        }
        finally {
            this.clearAdminServerProperties();
        }
    }

    private void setupAdminServerProperties() {
        System.setProperty("zookeeper.admin.enableServer", "true");
        System.setProperty("zookeeper.admin.rateLimiterIntervalInMS", "0");
        System.setProperty("zookeeper.admin.snapshot.enabled", "true");
        System.setProperty("zookeeper.serializeLastProcessedZxid.enabled", "true");
        System.setProperty("zookeeper.admin.restore.enabled", "true");
    }

    private void clearAdminServerProperties() {
        System.clearProperty("zookeeper.admin.enableServer");
        System.clearProperty("zookeeper.admin.serverPort");
        System.clearProperty("zookeeper.admin.rateLimiterIntervalInMS");
        System.clearProperty("zookeeper.admin.snapshot.enabled");
        System.clearProperty("zookeeper.serializeLastProcessedZxid.enabled");
        System.clearProperty("zookeeper.admin.restore.enabled");
    }
}

