/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelPipeline;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.ClientCnxnSocketNetty;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.ClientX509Util;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.NettyServerCnxn;
import org.apache.zookeeper.server.NettyServerCnxnFactory;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerStats;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.quorum.BufferStats;
import org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.SSLAuthTest;
import org.apache.zookeeper.test.TestByteBufAllocator;
import org.apache.zookeeper.test.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServerCnxnTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(NettyServerCnxnTest.class);

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        System.setProperty("zookeeper.serverCnxnFactory", "org.apache.zookeeper.server.NettyServerCnxnFactory");
        NettyServerCnxnFactory.setTestAllocator((ByteBufAllocator)TestByteBufAllocator.getInstance());
        this.maxCnxns = 1;
        this.exceptionOnFailedConnect = true;
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        NettyServerCnxnFactory.clearTestAllocator();
        TestByteBufAllocator.checkForLeaks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=40L)
    public void testSendCloseSession() throws Exception {
        Assertions.assertTrue((boolean)(this.serverFactory instanceof NettyServerCnxnFactory), (String)"Didn't instantiate ServerCnxnFactory with NettyServerCnxnFactory!");
        TestableZooKeeper zk = this.createClient();
        ZooKeeperServer zkServer = this.serverFactory.getZooKeeperServer();
        String path = "/a";
        try {
            zk.create("/a", "test".getBytes(StandardCharsets.UTF_8), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assertions.assertNotNull((Object)zk.exists("/a", true), (String)"Didn't create znode:/a");
            Assertions.assertEquals((int)1, (int)zkServer.getZKDatabase().getDataTree().getWatchCount());
            Iterable connections = this.serverFactory.getConnections();
            Assertions.assertEquals((int)1, (int)this.serverFactory.getNumAliveConnections(), (String)"Mismatch in number of live connections!");
            for (ServerCnxn serverCnxn : connections) {
                serverCnxn.sendCloseSession();
            }
            LOG.info("Waiting for the channel disconnected event");
            int timeout = 0;
            while (this.serverFactory.getNumAliveConnections() != 0) {
                Thread.sleep(1000L);
                if ((timeout += 1000) <= CONNECTION_TIMEOUT) continue;
                Assertions.fail((String)"The number of live connections should be 0");
            }
            Assertions.assertEquals((int)0, (int)zkServer.getZKDatabase().getDataTree().getWatchCount());
        }
        finally {
            zk.close();
        }
    }

    @Test
    @Timeout(value=40L)
    public void testMaxConnectionPerIpSurpased() {
        Assertions.assertTrue((boolean)(this.serverFactory instanceof NettyServerCnxnFactory), (String)"Did not instantiate ServerCnxnFactory with NettyServerCnxnFactory!");
        Assertions.assertThrows(ProtocolException.class, () -> {
            try (TestableZooKeeper zk1 = this.createClient();){
                TestableZooKeeper zk2 = this.createClient();
                if (zk2 != null) {
                    zk2.close();
                }
            }
        });
    }

    @Test
    public void testClientResponseStatsUpdate() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = this.createClient();){
            BufferStats clientResponseStats = this.serverFactory.getZooKeeperServer().serverStats().getClientResponseStats();
            MatcherAssert.assertThat((String)"Last client response size should be initialized with INIT_VALUE", (Object)clientResponseStats.getLastBufferSize(), (Matcher)Matchers.equalTo((Object)-1));
            zk.create("/a", "test".getBytes(StandardCharsets.UTF_8), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            MatcherAssert.assertThat((String)"Last client response size should be greater than 0 after client request was performed", (Object)clientResponseStats.getLastBufferSize(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            byte[] contents = zk.getData("/a", null, null);
            Assertions.assertArrayEquals((byte[])"test".getBytes(StandardCharsets.UTF_8), (byte[])contents, (String)"unexpected data");
        }
    }

    @Test
    public void testNonMTLSLocalConn() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = this.createClient();){
            ServerStats serverStats = this.serverFactory.getZooKeeperServer().serverStats();
            Assertions.assertEquals((long)2L, (long)serverStats.getNonMTLSLocalConnCount());
            Assertions.assertEquals((long)0L, (long)serverStats.getNonMTLSRemoteConnCount());
        }
    }

    @Test
    public void testNonMTLSRemoteConn() throws Exception {
        LeaderZooKeeperServer zks = (LeaderZooKeeperServer)Mockito.mock(LeaderZooKeeperServer.class);
        Mockito.when((Object)zks.isRunning()).thenReturn((Object)true);
        ServerStats.Provider providerMock = (ServerStats.Provider)Mockito.mock(ServerStats.Provider.class);
        Mockito.when((Object)zks.serverStats()).thenReturn((Object)new ServerStats(providerMock));
        this.testNonMTLSRemoteConn((ZooKeeperServer)zks, false, false);
    }

    @Test
    public void testNonMTLSRemoteConnZookKeeperServerNotReady() throws Exception {
        this.testNonMTLSRemoteConn(null, false, false);
    }

    @Test
    public void testNonMTLSRemoteConnZookKeeperServerNotReadyEarlyDropEnabled() throws Exception {
        this.testNonMTLSRemoteConn(null, false, true);
    }

    @Test
    public void testMTLSRemoteConnZookKeeperServerNotReadyEarlyDropEnabled() throws Exception {
        this.testNonMTLSRemoteConn(null, true, true);
    }

    @Test
    public void testMTLSRemoteConnZookKeeperServerNotReadyEarlyDropDisabled() throws Exception {
        this.testNonMTLSRemoteConn(null, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNonMTLSRemoteConn(ZooKeeperServer zks, boolean secure, boolean earlyDrop) throws Exception {
        try {
            System.setProperty("zookeeper.netty.server.earlyDropSecureConnectionHandshakes", earlyDrop + "");
            Channel channel = (Channel)Mockito.mock(Channel.class);
            ChannelId id = (ChannelId)Mockito.mock(ChannelId.class);
            ChannelFuture success = (ChannelFuture)Mockito.mock(ChannelFuture.class);
            ChannelHandlerContext context = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
            ChannelPipeline channelPipeline = (ChannelPipeline)Mockito.mock(ChannelPipeline.class);
            Mockito.when((Object)context.channel()).thenReturn((Object)channel);
            Mockito.when((Object)channel.pipeline()).thenReturn((Object)channelPipeline);
            Mockito.when((Object)success.channel()).thenReturn((Object)channel);
            Mockito.when((Object)channel.closeFuture()).thenReturn((Object)success);
            InetSocketAddress address = new InetSocketAddress(0);
            Mockito.when((Object)channel.remoteAddress()).thenReturn((Object)address);
            Mockito.when((Object)channel.id()).thenReturn((Object)id);
            NettyServerCnxnFactory factory = new NettyServerCnxnFactory();
            factory.setSecure(secure);
            factory.setZooKeeperServer(zks);
            Attribute atr = (Attribute)Mockito.mock(Attribute.class);
            ((Channel)Mockito.doReturn((Object)atr).when((Object)channel)).attr((AttributeKey)Mockito.any());
            ((Attribute)Mockito.doNothing().when((Object)atr)).set(Mockito.any());
            factory.channelHandler.channelActive(context);
            if (zks != null) {
                Assertions.assertEquals((long)0L, (long)zks.serverStats().getNonMTLSLocalConnCount());
                Assertions.assertEquals((long)1L, (long)zks.serverStats().getNonMTLSRemoteConnCount());
            } else if (earlyDrop && secure) {
                ((Channel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).close();
            } else {
                ((Channel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)0))).close();
            }
        }
        finally {
            System.clearProperty("zookeeper.netty.server.earlyDropSecureConnectionHandshakes");
        }
    }

    @Test
    public void testServerSideThrottling() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = this.createClient();){
            BufferStats clientResponseStats = this.serverFactory.getZooKeeperServer().serverStats().getClientResponseStats();
            MatcherAssert.assertThat((String)"Last client response size should be initialized with INIT_VALUE", (Object)clientResponseStats.getLastBufferSize(), (Matcher)Matchers.equalTo((Object)-1));
            zk.create("/a", "test".getBytes(StandardCharsets.UTF_8), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            MatcherAssert.assertThat((String)"Last client response size should be greater than 0 after client request was performed", (Object)clientResponseStats.getLastBufferSize(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            for (ServerCnxn cnxn : this.serverFactory.cnxns) {
                final NettyServerCnxn nettyCnxn = (NettyServerCnxn)cnxn;
                nettyCnxn.disableRecv();
                nettyCnxn.getChannel().eventLoop().schedule(new Runnable(){

                    @Override
                    public void run() {
                        nettyCnxn.getChannel().read();
                    }
                }, 1L, TimeUnit.SECONDS);
                nettyCnxn.getChannel().eventLoop().schedule(new Runnable(){

                    @Override
                    public void run() {
                        nettyCnxn.enableRecv();
                    }
                }, 2L, TimeUnit.SECONDS);
            }
            byte[] contents = zk.getData("/a", null, null);
            Assertions.assertArrayEquals((byte[])"test".getBytes(StandardCharsets.UTF_8), (byte[])contents, (String)"unexpected data");
            for (ServerCnxn cnxn : this.serverFactory.cnxns) {
                final NettyServerCnxn nettyCnxn = (NettyServerCnxn)cnxn;
                nettyCnxn.disableRecv();
                nettyCnxn.getChannel().eventLoop().schedule(new Runnable(){

                    @Override
                    public void run() {
                        nettyCnxn.enableRecv();
                    }
                }, 2L, TimeUnit.SECONDS);
            }
            contents = zk.getData("/a", null, null);
            Assertions.assertArrayEquals((byte[])"test".getBytes(StandardCharsets.UTF_8), (byte[])contents, (String)"unexpected data");
        }
    }

    @Test
    public void testEnableDisableThrottling_secure_random() throws Exception {
        this.runEnableDisableThrottling(true, true);
    }

    @Test
    public void testEnableDisableThrottling_secure_sequentially() throws Exception {
        this.runEnableDisableThrottling(true, false);
    }

    @Test
    public void testEnableDisableThrottling_nonSecure_random() throws Exception {
        this.runEnableDisableThrottling(false, true);
    }

    @Test
    public void testEnableDisableThrottling_nonSecure_sequentially() throws Exception {
        this.runEnableDisableThrottling(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNettyUsesDaemonThreads() throws Exception {
        Assertions.assertTrue((boolean)(this.serverFactory instanceof NettyServerCnxnFactory), (String)"Didn't instantiate ServerCnxnFactory with NettyServerCnxnFactory!");
        System.setProperty("zookeeper.clientCnxnSocket", ClientCnxnSocketNetty.class.getName());
        try {
            ZooKeeperServer zkServer = this.serverFactory.getZooKeeperServer();
            try (TestableZooKeeper zk = this.createClient();){
                String path = "/a";
                zk.create("/a", "test".getBytes(StandardCharsets.UTF_8), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                List<Thread> threads = TestUtils.getAllThreads();
                boolean foundThread = false;
                for (Thread t : threads) {
                    if (!t.getName().startsWith("zkNetty-")) continue;
                    foundThread = true;
                    Assertions.assertTrue((boolean)t.isDaemon(), (String)"All Netty threads started by ZK must daemon threads");
                }
                Assertions.assertTrue((boolean)foundThread, (String)"Did not find any Netty ZK Threads");
            }
            finally {
                zkServer.shutdown();
            }
        }
        finally {
            System.clearProperty("zookeeper.clientCnxnSocket");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runEnableDisableThrottling(boolean secure, boolean randomDisableEnable) throws Exception {
        ClientX509Util x509Util = null;
        if (secure) {
            x509Util = SSLAuthTest.setUpSecure();
        }
        try {
            NettyServerCnxnFactory factory = (NettyServerCnxnFactory)this.serverFactory;
            factory.setAdvancedFlowControlEnabled(true);
            if (secure) {
                factory.setSecure(true);
            }
            String path = "/testEnableDisableThrottling";
            try (TestableZooKeeper zk = this.createClient();){
                zk.create("/testEnableDisableThrottling", new byte[1], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                final AtomicBoolean stopped = new AtomicBoolean(false);
                final Random random = new Random();
                Thread enableDisableThread = null;
                enableDisableThread = randomDisableEnable ? new Thread(){

                    @Override
                    public void run() {
                        while (!stopped.get()) {
                            for (ServerCnxn cnxn : ((NettyServerCnxnTest)NettyServerCnxnTest.this).serverFactory.cnxns) {
                                boolean shouldDisableEnable = random.nextBoolean();
                                if (shouldDisableEnable) {
                                    cnxn.disableRecv();
                                    continue;
                                }
                                cnxn.enableRecv();
                            }
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        for (ServerCnxn cnxn : ((NettyServerCnxnTest)NettyServerCnxnTest.this).serverFactory.cnxns) {
                            cnxn.enableRecv();
                        }
                    }
                } : new Thread(){

                    @Override
                    public void run() {
                        while (!stopped.get()) {
                            for (ServerCnxn cnxn : ((NettyServerCnxnTest)NettyServerCnxnTest.this).serverFactory.cnxns) {
                                try {
                                    cnxn.disableRecv();
                                    Thread.sleep(10L);
                                    cnxn.enableRecv();
                                    Thread.sleep(10L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                    }
                };
                enableDisableThread.start();
                LOG.info("started thread to enable and disable recv");
                final int totalRequestsNum = 100000;
                AtomicInteger successResponse = new AtomicInteger();
                CountDownLatch responseReceivedLatch = new CountDownLatch(totalRequestsNum);
                Thread clientThread = new Thread((ZooKeeper)zk, successResponse, responseReceivedLatch){
                    final /* synthetic */ ZooKeeper val$zk;
                    final /* synthetic */ AtomicInteger val$successResponse;
                    final /* synthetic */ CountDownLatch val$responseReceivedLatch;
                    {
                        this.val$zk = zooKeeper;
                        this.val$successResponse = atomicInteger;
                        this.val$responseReceivedLatch = countDownLatch;
                    }

                    @Override
                    public void run() {
                        int requestIssued = 0;
                        while (requestIssued++ < totalRequestsNum) {
                            this.val$zk.getData("/testEnableDisableThrottling", null, new AsyncCallback.DataCallback(){

                                public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                                    if (rc == KeeperException.Code.OK.intValue()) {
                                        val$successResponse.addAndGet(1);
                                    } else {
                                        LOG.info("failed response is {}", (Object)rc);
                                    }
                                    val$responseReceivedLatch.countDown();
                                }
                            }, null);
                        }
                    }
                };
                clientThread.start();
                LOG.info("started thread to issue {} async requests", (Object)totalRequestsNum);
                Assertions.assertTrue((boolean)responseReceivedLatch.await(60L, TimeUnit.SECONDS));
                LOG.info("received all {} responses", (Object)totalRequestsNum);
                stopped.set(true);
                enableDisableThread.join();
                LOG.info("enable and disable recv thread exited");
                LOG.info("waiting another 1s for the requests to go through");
                Thread.sleep(1000L);
                Assertions.assertEquals((int)successResponse.get(), (int)totalRequestsNum);
            }
        }
        finally {
            if (secure) {
                SSLAuthTest.clearSecureSetting(x509Util);
            }
        }
    }
}

