/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.http.vertx;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.ErrorHttpService;
import org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;

public abstract class VertxAbstractHandler
implements Handler<RoutingContext> {
    void processRequest(HttpEndpointService httpEndpointService, RoutingContext context) {
        HttpServerRequest httpRequest = context.request();
        HttpServerResponse httpResponse = context.response();
        HttpServiceRequest request = new HttpServiceRequest().setMethod(this.convertMethod(httpRequest)).setParams(this.convertParams(httpRequest)).setBody(context.body().asString());
        HttpServiceResponse response = null;
        try {
            response = httpEndpointService.handle(request);
        }
        catch (Exception e) {
            response = new ErrorHttpService().handle(request);
        }
        httpResponse.setStatusCode(response.getStatusCode());
        if (response.getContentType() != null) {
            httpResponse.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)response.getContentType());
        }
        httpResponse.end(response.getBody());
    }

    Map<String, String> convertParams(HttpServerRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry entry : request.params()) {
            map.put((String)entry.getKey(), (String)entry.getValue());
        }
        return map;
    }

    HttpServer.Method convertMethod(HttpServerRequest request) {
        HttpMethod method = request.method();
        if (HttpMethod.POST.equals((Object)method)) {
            return HttpServer.Method.POST;
        }
        if (HttpMethod.DELETE.equals((Object)method)) {
            return HttpServer.Method.DELETE;
        }
        if (HttpMethod.PUT.equals((Object)method)) {
            return HttpServer.Method.PUT;
        }
        return HttpServer.Method.GET;
    }
}

