/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.embedded;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.ClientCnxnSocketNetty;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.server.NettyServerCnxnFactory;
import org.apache.zookeeper.server.embedded.ExitHandler;
import org.apache.zookeeper.server.embedded.ZooKeeperServerEmbedded;
import org.apache.zookeeper.server.embedded.ZookeeperServeInfo;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class ZookeeperServerSslEmbeddedTest {
    @TempDir
    public Path baseDir;

    @BeforeAll
    public static void setUpEnvironment() {
        System.setProperty("zookeeper.admin.enableServer", "false");
        System.setProperty("zookeeper.4lw.commands.whitelist", "*");
    }

    @AfterAll
    public static void cleanUpEnvironment() throws InterruptedException, IOException {
        System.clearProperty("zookeeper.admin.enableServer");
        System.clearProperty("zookeeper.4lw.commands.whitelist");
        System.clearProperty("zookeeper.ssl.trustStore.location");
        System.clearProperty("zookeeper.ssl.trustStore.password");
        System.clearProperty("zookeeper.ssl.trustStore.type");
    }

    @Test
    public void testStart() throws Exception {
        int clientPort = PortAssignment.unique();
        int clientSecurePort = PortAssignment.unique();
        Properties configZookeeper = new Properties();
        configZookeeper.put("clientPort", clientPort + "");
        configZookeeper.put("secureClientPort", clientSecurePort + "");
        configZookeeper.put("host", "localhost");
        configZookeeper.put("ticktime", "4000");
        configZookeeper.put("serverCnxnFactory", NettyServerCnxnFactory.class.getName());
        File testKeyStore = new File("src/test/resources/embedded/testKeyStore.jks");
        File testTrustStore = new File("src/test/resources/embedded/testTrustStore.jks");
        Assert.assertTrue((boolean)testKeyStore.isFile());
        Assert.assertTrue((boolean)testTrustStore.isFile());
        configZookeeper.put("ssl.keyStore.location", testKeyStore.getAbsolutePath());
        configZookeeper.put("ssl.keyStore.password", "testpass");
        configZookeeper.put("ssl.keyStore.type", "JKS");
        System.setProperty("zookeeper.ssl.trustStore.location", testTrustStore.getAbsolutePath());
        System.setProperty("zookeeper.ssl.trustStore.password", "testpass");
        System.setProperty("zookeeper.ssl.trustStore.type", "JKS");
        try (ZooKeeperServerEmbedded zkServer = ZooKeeperServerEmbedded.builder().baseDir(this.baseDir).configuration(configZookeeper).exitHandler(ExitHandler.LOG_ONLY).build();){
            ZookeeperServeInfo.ServerInfo status;
            zkServer.start();
            Assert.assertTrue((boolean)ClientBase.waitForServerUp(zkServer.getConnectionString(), 60000L));
            for (int i = 0; !(i >= 100 || (status = ZookeeperServeInfo.getStatus("StandaloneServer*")).isLeader() && status.isStandaloneMode()); ++i) {
                Thread.sleep(100L);
            }
            ZookeeperServeInfo.ServerInfo status2 = ZookeeperServeInfo.getStatus("StandaloneServer*");
            Assert.assertTrue((boolean)status2.isLeader());
            Assert.assertTrue((boolean)status2.isStandaloneMode());
            CountDownLatch l = new CountDownLatch(1);
            ZKClientConfig zKClientConfig = new ZKClientConfig();
            zKClientConfig.setProperty("zookeeper.client.secure", "true");
            zKClientConfig.setProperty("zookeeper.clientCnxnSocket", ClientCnxnSocketNetty.class.getName());
            try (ZooKeeper zk = new ZooKeeper(zkServer.getSecureConnectionString(), 60000, event -> {
                switch (event.getState()) {
                    case SyncConnected: {
                        l.countDown();
                    }
                }
            }, zKClientConfig);){
                Assert.assertTrue((boolean)zk.getClientConfig().getBoolean("zookeeper.client.secure"));
                Assert.assertTrue((boolean)l.await(10L, TimeUnit.SECONDS));
            }
        }
    }
}

