/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.security.sasl.SaslException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.Follower;
import org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.LearnerHandler;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.server.quorum.SyncedLearnerTracker;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class DIFFSyncConsistencyTest
extends QuorumPeerTestBase {
    private static int SERVER_COUNT = 3;
    private QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[SERVER_COUNT];

    @Test
    @Timeout(value=120L)
    public void testInconsistentDueToUncommittedLog() throws Exception {
        int i;
        int i2;
        int LEADER_TIMEOUT_MS = 10000;
        int[] clientPorts = new int[SERVER_COUNT];
        StringBuilder sb = new StringBuilder();
        for (int i3 = 0; i3 < SERVER_COUNT; ++i3) {
            clientPorts[i3] = PortAssignment.unique();
            String server = "server." + i3 + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;127.0.0.1:" + clientPorts[i3];
            sb.append(server + "\n");
        }
        String currentQuorumCfgSection = sb.toString();
        for (i2 = 0; i2 < SERVER_COUNT; ++i2) {
            this.mt[i2] = new QuorumPeerTestBase.MainThread(i2, clientPorts[i2], currentQuorumCfgSection, false){

                @Override
                public QuorumPeerTestBase.TestQPMain getTestQPMain() {
                    return new MockTestQPMain();
                }
            };
            this.mt[i2].start();
        }
        for (i2 = 0; i2 < SERVER_COUNT; ++i2) {
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i2], ClientBase.CONNECTION_TIMEOUT), (String)("waiting for server " + i2 + " being up"));
        }
        int leader = this.findLeader(this.mt);
        ClientBase.CountdownWatcher watch = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + clientPorts[leader], ClientBase.CONNECTION_TIMEOUT, (Watcher)watch);
        watch.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        ConcurrentMap outstanding = this.mt[leader].main.quorumPeer.leader.outstandingProposals;
        int previousTick = this.mt[leader].main.quorumPeer.tickTime;
        this.mt[leader].main.quorumPeer.tickTime = 10000;
        Thread.sleep(previousTick);
        LOG.info("LEADER ELECTED {}", (Object)leader);
        for (int i4 = 0; i4 < SERVER_COUNT; ++i4) {
            if (i4 == leader) continue;
            this.mt[i4].shutdown();
        }
        try {
            zk.create("/zk" + leader, "zk".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assertions.fail((String)("create /zk" + leader + " should have failed"));
        }
        catch (KeeperException i4) {
            // empty catch block
        }
        Assertions.assertTrue((outstanding.size() > 0 ? 1 : 0) != 0);
        Leader.Proposal p = this.findProposalOfType(outstanding, 1);
        LOG.info("Old leader id: {}. All proposals: {}", (Object)leader, (Object)outstanding);
        Assertions.assertNotNull((Object)p, (String)"Old leader doesn't have 'create' proposal");
        int sleepTime = 0;
        Long longLeader = leader;
        while (!((SyncedLearnerTracker.QuorumVerifierAcksetPair)p.qvAcksetPairs.get(0)).getAckset().contains(longLeader)) {
            if (sleepTime > 2000) {
                Assertions.fail((String)("Transaction not synced to disk within 1 second " + ((SyncedLearnerTracker.QuorumVerifierAcksetPair)p.qvAcksetPairs.get(0)).getAckset() + " expected " + leader));
            }
            Thread.sleep(100L);
            sleepTime += 100;
        }
        for (int i5 = 0; i5 < SERVER_COUNT; ++i5) {
            if (i5 == leader) continue;
            this.mt[i5].start();
            int sleepCount = 0;
            while (this.mt[i5].getQuorumPeer() == null) {
                if (++sleepCount > 100) {
                    Assertions.fail((String)("Can't start follower " + i5 + " !"));
                }
                Thread.sleep(100L);
            }
            ((CustomQuorumPeer)this.mt[i5].getQuorumPeer()).setInjectError(true);
            LOG.info("Follower {} started.", (Object)i5);
        }
        for (int c = 0; c < 100; ++c) {
            try {
                Stat stat = zk.exists("/zk" + leader, false);
                Assertions.assertNotNull((Object)stat, (String)("server " + leader + " should have /zk"));
                break;
            }
            catch (KeeperException.ConnectionLossException stat) {
                Thread.sleep(100L);
                continue;
            }
        }
        for (i = 0; i < SERVER_COUNT; ++i) {
            this.mt[i].shutdown();
        }
        DIFFSyncConsistencyTest.waitForOne(zk, ZooKeeper.States.CONNECTING);
        for (i = 0; i < SERVER_COUNT; ++i) {
            if (i == leader) continue;
            this.mt[i].start();
            int sleepCount = 0;
            while (this.mt[i].getQuorumPeer() == null) {
                if (++sleepCount > 100) {
                    Assertions.fail((String)("Can't start follower " + i + " !"));
                }
                Thread.sleep(100L);
            }
            ((CustomQuorumPeer)this.mt[i].getQuorumPeer()).setInjectError(false);
            LOG.info("Follower {} started again.", (Object)i);
        }
        int newLeader = this.findLeader(this.mt);
        Assertions.assertNotEquals((int)newLeader, (int)leader, (String)("new leader is still the old leader " + leader + " !!"));
        for (int i6 = 0; i6 < SERVER_COUNT; ++i6) {
            if (i6 != newLeader) continue;
            zk.close();
            zk = new ZooKeeper("127.0.0.1:" + clientPorts[i6], ClientBase.CONNECTION_TIMEOUT, (Watcher)watch);
            watch.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
            Stat val = zk.exists("/zk" + leader, false);
            Assertions.assertNotNull((Object)val, (String)("Data inconsistency detected! Server " + i6 + " should have a view of /zk" + leader + "!"));
        }
        zk.close();
    }

    @Override
    @AfterEach
    public void tearDown() {
        for (int i = 0; i < this.mt.length; ++i) {
            try {
                this.mt[i].shutdown();
                continue;
            }
            catch (InterruptedException e) {
                LOG.warn("Quorum Peer interrupted while shutting it down", (Throwable)e);
            }
        }
    }

    private Leader.Proposal findProposalOfType(Map<Long, Leader.Proposal> proposals, int type) {
        for (Leader.Proposal proposal : proposals.values()) {
            if (proposal.request.getHdr().getType() != type) continue;
            return proposal;
        }
        return null;
    }

    private int findLeader(QuorumPeerTestBase.MainThread[] mt) {
        for (int i = 0; i < mt.length; ++i) {
            if (mt[i].main.quorumPeer.leader == null) continue;
            return i;
        }
        return -1;
    }

    static class MockTestQPMain
    extends QuorumPeerTestBase.TestQPMain {
        MockTestQPMain() {
        }

        protected QuorumPeer getQuorumPeer() throws SaslException {
            return new CustomQuorumPeer();
        }
    }

    static class CustomQuorumPeer
    extends QuorumPeer {
        private volatile boolean injectError = false;

        protected Follower makeFollower(FileTxnSnapLog logFactory) throws IOException {
            return new Follower(this, new FollowerZooKeeperServer(logFactory, (QuorumPeer)this, this.getZkDb())){

                void readPacket(QuorumPacket pp) throws IOException {
                    super.readPacket(pp);
                    if (injectError && pp.getType() == 12) {
                        String type = LearnerHandler.packetToString((QuorumPacket)pp);
                        throw new SocketTimeoutException("Socket timeout while reading the packet for operation " + type);
                    }
                }
            };
        }

        public void setInjectError(boolean injectError) {
            this.injectError = injectError;
        }
    }
}

