/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.common.PathUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PathUtilsTest
extends ZKTestCase {
    @Test
    public void testValidatePath_ValidPath() {
        PathUtils.validatePath((String)"/this is / a valid/path");
    }

    @Test
    public void testValidatePath_Null() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PathUtils.validatePath(null));
    }

    @Test
    public void testValidatePath_EmptyString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PathUtils.validatePath((String)""));
    }

    @Test
    public void testValidatePath_NotAbsolutePath() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PathUtils.validatePath((String)"not/valid"));
    }

    @Test
    public void testValidatePath_EndsWithSlash() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PathUtils.validatePath((String)"/ends/with/slash/"));
    }

    @Test
    public void testValidatePath_ContainsNullCharacter() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PathUtils.validatePath((String)"/test\u0000"));
    }

    @Test
    public void testValidatePath_DoubleSlash() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PathUtils.validatePath((String)"/double//slash"));
    }

    @Test
    public void testValidatePath_SinglePeriod() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PathUtils.validatePath((String)"/single/./period"));
    }

    @Test
    public void testValidatePath_DoublePeriod() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PathUtils.validatePath((String)"/double/../period"));
    }

    @Test
    public void testValidatePath_NameContainingPeriod() {
        PathUtils.validatePath((String)"/name/with.period.");
    }

    @Test
    public void testValidatePath_0x01() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PathUtils.validatePath((String)"/test\u0001"));
    }

    @Test
    public void testValidatePath_0x1F() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PathUtils.validatePath((String)"/test\u001f"));
    }

    @Test
    public void testValidatePath_0x20() {
        PathUtils.validatePath((String)"/test ");
    }

    @Test
    public void testValidatePath_0x7e() {
        PathUtils.validatePath((String)"/test~");
    }

    @Test
    public void testValidatePath_0x7f() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PathUtils.validatePath((String)"/test\u007f"));
    }

    @Test
    public void testValidatePath_0x9f() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PathUtils.validatePath((String)"/test\u009f"));
    }

    @Test
    public void testValidatePath_ud800() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PathUtils.validatePath((String)"/test\ud800"));
    }

    @Test
    public void testValidatePath_uf8ff() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PathUtils.validatePath((String)"/test\uf8ff"));
    }

    @Test
    public void testValidatePath_HighestAllowableChar() {
        PathUtils.validatePath((String)"/test\uffef");
    }

    @Test
    public void testValidatePath_SupplementaryChar() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PathUtils.validatePath((String)"/test\ufff0"));
    }

    @Test
    public void testGetTopNamespace() {
        Assertions.assertEquals((Object)"n0", (Object)PathUtils.getTopNamespace((String)"/n0/n1/n2/n3"));
        Assertions.assertNull((Object)PathUtils.getTopNamespace((String)"/"));
        Assertions.assertNull((Object)PathUtils.getTopNamespace((String)""));
        Assertions.assertNull((Object)PathUtils.getTopNamespace(null));
    }
}

