/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import java.util.HashSet;
import java.util.Set;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.lsm.common.api.AbstractLSMWithBuddyDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.rtree.impls.RTree;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;

public class LSMRTreeDiskComponent
extends AbstractLSMWithBuddyDiskComponent {
    private final RTree rtree;
    private final BTree btree;
    private final BloomFilter bloomFilter;

    public LSMRTreeDiskComponent(AbstractLSMIndex lsmIndex, RTree rtree, BTree btree, BloomFilter bloomFilter, ILSMComponentFilter filter) {
        super(lsmIndex, LSMRTreeDiskComponent.getMetadataPageManager(rtree), filter);
        this.rtree = rtree;
        this.btree = btree;
        this.bloomFilter = bloomFilter;
    }

    public BTree getBuddyIndex() {
        return this.btree;
    }

    public BloomFilter getBloomFilter() {
        return this.bloomFilter;
    }

    public IBufferCache getBloomFilterBufferCache() {
        return this.btree.getBufferCache();
    }

    public long getComponentSize() {
        long size = LSMRTreeDiskComponent.getComponentSize(this.rtree);
        size += this.btree.getFileReference().getFile().length();
        return size += this.bloomFilter.getFileReference().getFile().length();
    }

    public Set<String> getLSMComponentPhysicalFiles() {
        Set<String> files = LSMRTreeDiskComponent.getFiles(this.rtree);
        files.add(this.btree.getFileReference().getFile().getAbsolutePath());
        files.add(this.bloomFilter.getFileReference().getFile().getAbsolutePath());
        return files;
    }

    public int getFileReferenceCount() {
        return LSMRTreeDiskComponent.getFileReferenceCount(this.rtree);
    }

    public RTree getMetadataHolder() {
        return this.rtree;
    }

    public RTree getIndex() {
        return this.rtree;
    }

    static IMetadataPageManager getMetadataPageManager(RTree rtree) {
        return (IMetadataPageManager)rtree.getPageManager();
    }

    static long getComponentSize(RTree rtree) {
        return rtree.getFileReference().getFile().length();
    }

    static int getFileReferenceCount(RTree rtree) {
        return rtree.getBufferCache().getFileReferenceCount(rtree.getFileId());
    }

    static Set<String> getFiles(RTree rtree) {
        HashSet<String> files = new HashSet<String>();
        files.add(rtree.getFileReference().getFile().getAbsolutePath());
        return files;
    }
}

