/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser.factory;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.external.api.IExternalDataRuntimeContext;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.api.IRecordDataParserFactory;
import org.apache.asterix.external.input.record.RecordWithMetadataAndPK;
import org.apache.asterix.external.input.record.converter.IRecordConverterFactory;
import org.apache.asterix.external.parser.RecordWithMetadataParser;
import org.apache.asterix.external.provider.ParserFactoryProvider;
import org.apache.asterix.external.provider.RecordConverterFactoryProvider;
import org.apache.asterix.external.util.ExternalDataCompatibilityUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class RecordWithMetadataParserFactory<I, O>
implements IRecordDataParserFactory<I> {
    private static final long serialVersionUID = 1L;
    private static final List<String> parserFormats = Collections.unmodifiableList(Arrays.asList("record-with-metadata"));
    private ARecordType metaType;
    private ARecordType recordType;
    private IRecordDataParserFactory<O> recordParserFactory;
    private IRecordConverterFactory<I, RecordWithMetadataAndPK<O>> converterFactory;

    @Override
    public void configure(Map<String, String> configuration) throws AlgebricksException {
        String recordFormat = configuration.get("record-format");
        if (recordFormat == null) {
            throw CompilationException.create((ErrorCode)ErrorCode.UNKNOWN_RECORD_FORMAT_FOR_META_PARSER, (Serializable[])new Serializable[]{"record-format"});
        }
        String format = configuration.get("format");
        if (format == null) {
            throw CompilationException.create((ErrorCode)ErrorCode.UNKNOWN_RECORD_FORMAT_FOR_META_PARSER, (Serializable[])new Serializable[]{"format"});
        }
        this.recordParserFactory = (IRecordDataParserFactory)ParserFactoryProvider.getDataParserFactory(recordFormat);
        this.recordParserFactory.setRecordType(this.recordType);
        this.recordParserFactory.setMetaType(this.metaType);
        this.recordParserFactory.configure(configuration);
        this.converterFactory = RecordConverterFactoryProvider.getConverterFactory(format, recordFormat);
        this.converterFactory.setRecordType(this.recordType);
        this.converterFactory.setMetaType(this.metaType);
        this.converterFactory.configure(configuration);
        ExternalDataCompatibilityUtils.validateCompatibility(this.recordParserFactory, this.converterFactory);
    }

    @Override
    public void setRecordType(ARecordType recordType) {
        this.recordType = recordType;
    }

    @Override
    public void setMetaType(ARecordType metaType) {
        this.metaType = metaType;
    }

    @Override
    public List<String> getParserFormats() {
        return parserFormats;
    }

    @Override
    public Class<?> getRecordClass() {
        return this.converterFactory.getInputClass();
    }

    @Override
    public IRecordDataParser<I> createRecordParser(IExternalDataRuntimeContext context) throws HyracksDataException {
        IRecordDataParser<O> recordParser = this.recordParserFactory.createRecordParser(context);
        return new RecordWithMetadataParser<I, O>(this.metaType, recordParser, this.converterFactory.createConverter(context));
    }
}

