/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser.factory;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.external.api.IExternalDataRuntimeContext;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.api.IStreamDataParser;
import org.apache.asterix.external.parser.JSONDataParser;
import org.apache.asterix.external.parser.factory.AbstractGenericDataParserFactory;
import org.apache.asterix.om.types.ARecordType;

public class JSONDataParserFactory
extends AbstractGenericDataParserFactory<char[]> {
    private static final long serialVersionUID = 1L;
    private static final List<String> PARSER_FORMAT = Collections.unmodifiableList(Arrays.asList("json", "JSON"));
    private final JsonFactory jsonFactory = new JsonFactory();

    public JSONDataParserFactory() {
        this.jsonFactory.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, true);
        this.jsonFactory.configure(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES, true);
        this.jsonFactory.configure(JsonFactory.Feature.INTERN_FIELD_NAMES, true);
    }

    @Override
    public IStreamDataParser createInputStreamParser(IExternalDataRuntimeContext context) {
        return this.createParser(context);
    }

    @Override
    public void setMetaType(ARecordType metaType) {
    }

    @Override
    public List<String> getParserFormats() {
        return PARSER_FORMAT;
    }

    @Override
    public IRecordDataParser<char[]> createRecordParser(IExternalDataRuntimeContext context) {
        return this.createParser(context);
    }

    @Override
    public Class<?> getRecordClass() {
        return char[].class;
    }

    private JSONDataParser createParser(IExternalDataRuntimeContext context) {
        return new JSONDataParser(this.recordType, this.jsonFactory, context);
    }
}

