/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.ParquetConverterContext;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.nested.AbstractComplexConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.GenericPrimitiveConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.TimeConverter;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.LogicalTypeAnnotation;

class TimestampConverter
extends GenericPrimitiveConverter {
    private static final long JULIAN_DAY_OF_EPOCH = 2440588L;
    private static final long MILLIS_PER_DAY = 86400000L;
    private static final long NANOS_PER_MILLIS = 1000000L;
    private final LogicalTypeAnnotation.TimeUnit timeUnit;
    private final int timeZoneOffset;

    TimestampConverter(AbstractComplexConverter parent, String stringFieldName, int index, ParquetConverterContext context, LogicalTypeAnnotation.TimeUnit timeUnit, int timeZoneOffset) throws IOException {
        super(ATypeTag.DATETIME, parent, stringFieldName, index, context);
        this.timeUnit = timeUnit;
        this.timeZoneOffset = timeZoneOffset;
    }

    @Override
    public void addBinary(Binary value) {
        ByteBuffer buffer = value.toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
        long timeOfDayNanos = buffer.getLong();
        int julianDay = buffer.getInt();
        long timestamp = TimestampConverter.fromJulian(julianDay, timeOfDayNanos);
        this.addLong(timestamp);
    }

    @Override
    public void addLong(long value) {
        long convertedTime = TimeConverter.getConvertedTime(this.timeUnit, value);
        this.context.serializeDateTime(convertedTime + (long)this.timeZoneOffset, this.parent.getDataOutput());
        this.parent.addValue(this);
    }

    private static long fromJulian(int days, long nanos) {
        return ((long)days - 2440588L) * 86400000L + nanos / 1000000L;
    }
}

