/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.function;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.app.function.QueryIndexRewriter;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.metadata.api.IDatasourceFunction;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.FunctionDataSource;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourcePropertiesProvider;
import org.apache.hyracks.algebricks.core.algebra.metadata.IProjectionFiltrationInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.properties.RandomPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;
import org.apache.hyracks.storage.am.common.impls.DefaultTupleProjectorFactory;
import org.apache.hyracks.storage.common.projection.ITupleProjectorFactory;

public class QueryIndexDatasource
extends FunctionDataSource {
    private final Dataset ds;
    private final String indexName;
    private final AlgebricksAbsolutePartitionConstraint storageLocations;
    private final int numSecKeys;

    public QueryIndexDatasource(Dataset ds, String indexName, INodeDomain domain, AlgebricksAbsolutePartitionConstraint storageLocations, ARecordType recType, int numSecKeys) throws AlgebricksException {
        super(QueryIndexDatasource.createQueryIndexDataSourceId(ds, indexName), QueryIndexRewriter.QUERY_INDEX, domain, (IAType)recType);
        this.ds = ds;
        this.indexName = indexName;
        this.storageLocations = storageLocations;
        this.numSecKeys = numSecKeys;
    }

    protected void initSchemaType(IAType iType) {
        ARecordType type = (ARecordType)iType;
        IAType[] fieldTypes = type.getFieldTypes();
        this.schemaTypes = new IAType[fieldTypes.length];
        System.arraycopy(fieldTypes, 0, this.schemaTypes, 0, this.schemaTypes.length);
    }

    protected AlgebricksAbsolutePartitionConstraint getLocations(IClusterStateManager csm, MetadataProvider md) {
        return this.storageLocations;
    }

    public boolean isScanAccessPathALeaf() {
        return false;
    }

    protected IDatasourceFunction createFunction(MetadataProvider metadataProvider, AlgebricksAbsolutePartitionConstraint locations) {
        throw new UnsupportedOperationException("query-index() does not use record reader adapter");
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildDatasourceScanRuntime(MetadataProvider metadataProvider, IDataSource<DataSourceId> dataSource, List<LogicalVariable> scanVariables, List<LogicalVariable> projectVariables, boolean projectPushed, List<LogicalVariable> minFilterVars, List<LogicalVariable> maxFilterVars, ITupleFilterFactory tupleFilterFactory, long outputLimit, IOperatorSchema opSchema, IVariableTypeEnvironment typeEnv, JobGenContext context, JobSpecification jobSpec, Object implConfig, IProjectionFiltrationInfo projectionInfo) throws AlgebricksException {
        return metadataProvider.getBtreeSearchRuntime(jobSpec, opSchema, typeEnv, context, true, false, null, this.ds, this.indexName, null, null, true, true, false, null, null, null, tupleFilterFactory, outputLimit, false, false, (ITupleProjectorFactory)DefaultTupleProjectorFactory.INSTANCE, false);
    }

    public IDataSourcePropertiesProvider getPropertiesProvider() {
        return new IDataSourcePropertiesProvider(){

            public IPhysicalPropertiesVector computeRequiredProperties(List<LogicalVariable> scanVariables, IOptimizationContext ctx) {
                return StructuralPropertiesVector.EMPTY_PROPERTIES_VECTOR;
            }

            public IPhysicalPropertiesVector computeDeliveredProperties(List<LogicalVariable> scanVariables, IOptimizationContext ctx) {
                ArrayList<LocalOrderProperty> propsLocal = new ArrayList<LocalOrderProperty>(1);
                ArrayList<OrderColumn> secKeys = new ArrayList<OrderColumn>(QueryIndexDatasource.this.numSecKeys);
                for (int i = 0; i < QueryIndexDatasource.this.numSecKeys; ++i) {
                    secKeys.add(new OrderColumn(scanVariables.get(i), OrderOperator.IOrder.OrderKind.ASC));
                }
                propsLocal.add(new LocalOrderProperty(secKeys));
                return new StructuralPropertiesVector((IPartitioningProperty)new RandomPartitioningProperty(QueryIndexDatasource.this.domain), propsLocal);
            }
        };
    }

    private static DataSourceId createQueryIndexDataSourceId(Dataset dataset, String indexName) {
        return new DataSourceId(dataset.getDatabaseName(), dataset.getDataverseName(), dataset.getDatasetName(), new String[]{indexName, QueryIndexRewriter.QUERY_INDEX.getName()});
    }
}

