/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.partition;

import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunctionFactory;
import org.apache.hyracks.api.dataflow.value.ITuplePartitioner;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionerFactory;
import org.apache.hyracks.dataflow.common.data.partition.FieldHashPartitioner;

public class FieldHashPartitionerFactory
implements ITuplePartitionerFactory {
    private static final long serialVersionUID = 1L;
    private final int[] hashFields;
    private final IBinaryHashFunctionFactory[] hashFunctionFactories;
    private final int numPartitions;

    public FieldHashPartitionerFactory(int[] hashFields, IBinaryHashFunctionFactory[] hashFunctionFactories, int numPartitions) {
        this.hashFields = hashFields;
        this.hashFunctionFactories = hashFunctionFactories;
        this.numPartitions = numPartitions;
    }

    public ITuplePartitioner createPartitioner(IHyracksTaskContext ctx) {
        IBinaryHashFunction[] hashFunctions = new IBinaryHashFunction[this.hashFunctionFactories.length];
        for (int i = 0; i < this.hashFunctionFactories.length; ++i) {
            hashFunctions[i] = this.hashFunctionFactories[i].createBinaryHashFunction();
        }
        return new FieldHashPartitioner(this.hashFields, hashFunctions, this.numPartitions);
    }
}

