/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataUtil;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.ArrayIndexUtil;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeSignature;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.util.LogRedactionUtil;

public class TypeUtil {
    private static final char TYPE_NAME_DELIMITER = '$';
    private static final String DATASET_INLINE_TYPE_PREFIX = "$d$t$";
    private static final String FUNCTION_INLINE_TYPE_PREFIX = "$f$t$";
    public static final String DATETIME_PARAMETER_NAME = BuiltinType.ADATETIME.getTypeName();
    public static final String DATE_PARAMETER_NAME = BuiltinType.ADATE.getTypeName();
    public static final String TIME_PARAMETER_NAME = BuiltinType.ATIME.getTypeName();

    private TypeUtil() {
    }

    public static FunctionIdentifier getTypeConstructorDefaultNull(IAType type, boolean withFormat) {
        switch (type.getTypeTag()) {
            case TINYINT: {
                return BuiltinFunctions.INT8_DEFAULT_NULL_CONSTRUCTOR;
            }
            case SMALLINT: {
                return BuiltinFunctions.INT16_DEFAULT_NULL_CONSTRUCTOR;
            }
            case INTEGER: {
                return BuiltinFunctions.INT32_DEFAULT_NULL_CONSTRUCTOR;
            }
            case BIGINT: {
                return BuiltinFunctions.INT64_DEFAULT_NULL_CONSTRUCTOR;
            }
            case FLOAT: {
                return BuiltinFunctions.FLOAT_DEFAULT_NULL_CONSTRUCTOR;
            }
            case DOUBLE: {
                return BuiltinFunctions.DOUBLE_DEFAULT_NULL_CONSTRUCTOR;
            }
            case BOOLEAN: {
                return BuiltinFunctions.BOOLEAN_DEFAULT_NULL_CONSTRUCTOR;
            }
            case STRING: {
                return BuiltinFunctions.STRING_DEFAULT_NULL_CONSTRUCTOR;
            }
            case DATE: {
                return withFormat ? BuiltinFunctions.DATE_DEFAULT_NULL_CONSTRUCTOR_WITH_FORMAT : BuiltinFunctions.DATE_DEFAULT_NULL_CONSTRUCTOR;
            }
            case TIME: {
                return withFormat ? BuiltinFunctions.TIME_DEFAULT_NULL_CONSTRUCTOR_WITH_FORMAT : BuiltinFunctions.TIME_DEFAULT_NULL_CONSTRUCTOR;
            }
            case DATETIME: {
                return withFormat ? BuiltinFunctions.DATETIME_DEFAULT_NULL_CONSTRUCTOR_WITH_FORMAT : BuiltinFunctions.DATETIME_DEFAULT_NULL_CONSTRUCTOR;
            }
            case YEARMONTHDURATION: {
                return BuiltinFunctions.YEAR_MONTH_DURATION_DEFAULT_NULL_CONSTRUCTOR;
            }
            case DAYTIMEDURATION: {
                return BuiltinFunctions.DAY_TIME_DURATION_DEFAULT_NULL_CONSTRUCTOR;
            }
            case DURATION: {
                return BuiltinFunctions.DURATION_DEFAULT_NULL_CONSTRUCTOR;
            }
            case UUID: {
                return BuiltinFunctions.UUID_DEFAULT_NULL_CONSTRUCTOR;
            }
            case BINARY: {
                return BuiltinFunctions.BINARY_BASE64_DEFAULT_NULL_CONSTRUCTOR;
            }
        }
        return null;
    }

    public static Map<String, String> validateConfiguration(Map<String, String> config, SourceLocation sourceLoc) throws CompilationException {
        if (config == null) {
            return Collections.emptyMap();
        }
        for (Map.Entry<String, String> me : config.entrySet()) {
            String name = me.getKey();
            String value = me.getValue();
            if (DATETIME_PARAMETER_NAME.equals(name) || DATE_PARAMETER_NAME.equals(name) || TIME_PARAMETER_NAME.equals(name)) {
                if (value != null) continue;
                throw new CompilationException(ErrorCode.INVALID_REQ_PARAM_VAL, sourceLoc, new Serializable[]{name, "null"});
            }
            throw new CompilationException(ErrorCode.ILLEGAL_SET_PARAMETER, sourceLoc, new Serializable[]{name});
        }
        return config;
    }

    public static String getDatetimeFormat(Map<String, String> config) {
        return config.get(DATETIME_PARAMETER_NAME);
    }

    public static String getDateFormat(Map<String, String> config) {
        return config.get(DATE_PARAMETER_NAME);
    }

    public static String getTimeFormat(Map<String, String> config) {
        return config.get(TIME_PARAMETER_NAME);
    }

    public static String getTemporalFormat(IAType targetType, Triple<String, String, String> temporalFormatByType) {
        switch (targetType.getTypeTag()) {
            case DATETIME: {
                return (String)temporalFormatByType.first;
            }
            case DATE: {
                return (String)temporalFormatByType.second;
            }
            case TIME: {
                return (String)temporalFormatByType.third;
            }
        }
        return null;
    }

    public static IAObject getTemporalFormatArg(AbstractFunctionCallExpression funExpr) {
        List arguments;
        FunctionIdentifier funId = funExpr.getFunctionIdentifier();
        if ((BuiltinFunctions.DATE_DEFAULT_NULL_CONSTRUCTOR_WITH_FORMAT.equals((Object)funId) || BuiltinFunctions.TIME_DEFAULT_NULL_CONSTRUCTOR_WITH_FORMAT.equals((Object)funId) || BuiltinFunctions.DATETIME_DEFAULT_NULL_CONSTRUCTOR_WITH_FORMAT.equals((Object)funId)) && (arguments = funExpr.getArguments()).size() > 1) {
            return ConstantExpressionUtil.getConstantIaObject((ILogicalExpression)((ILogicalExpression)((Mutable)arguments.get(1)).getValue()), null);
        }
        return null;
    }

    public static Pair<ARecordType, ARecordType> createEnforcedType(ARecordType recordType, ARecordType metaType, List<Index> indexes) throws AlgebricksException {
        EnforcedTypeBuilder enforcedTypeBuilder = new EnforcedTypeBuilder();
        ARecordType enforcedRecordType = recordType;
        block5: for (Index index : indexes) {
            if (!index.isSecondaryIndex() || !index.getIndexDetails().isOverridingKeyFieldTypes()) continue;
            switch (Index.IndexCategory.of(index.getIndexType())) {
                case VALUE: {
                    enforcedRecordType = TypeUtil.appendValueIndexType(enforcedRecordType, (Index.ValueIndexDetails)index.getIndexDetails(), enforcedTypeBuilder);
                    continue block5;
                }
                case TEXT: {
                    enforcedRecordType = TypeUtil.appendTextIndexType(enforcedRecordType, (Index.TextIndexDetails)index.getIndexDetails(), enforcedTypeBuilder);
                    continue block5;
                }
                case ARRAY: {
                    enforcedRecordType = TypeUtil.appendArrayIndexTypes(enforcedRecordType, (Index.ArrayIndexDetails)index.getIndexDetails(), enforcedTypeBuilder);
                    continue block5;
                }
            }
            throw new CompilationException(ErrorCode.COMPILATION_UNKNOWN_INDEX_TYPE, new Serializable[]{String.valueOf(index.getIndexType())});
        }
        TypeUtil.validateRecord((IAType)enforcedRecordType);
        return new Pair((Object)enforcedRecordType, (Object)metaType);
    }

    private static ARecordType appendValueIndexType(ARecordType enforcedRecordType, Index.ValueIndexDetails valueIndexDetails, EnforcedTypeBuilder enforcedTypeBuilder) throws AlgebricksException {
        List<List<String>> keyFieldNames = valueIndexDetails.getKeyFieldNames();
        List<IAType> keyFieldTypes = valueIndexDetails.getKeyFieldTypes();
        List<Integer> keySources = valueIndexDetails.getKeyFieldSourceIndicators();
        for (int i = 0; i < keyFieldNames.size(); ++i) {
            if (keySources.get(i) != 0) {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"Indexing an open field is only supported on the record part"});
            }
            enforcedTypeBuilder.reset(enforcedRecordType, keyFieldNames.get(i), Collections.nCopies(keyFieldNames.get(i).size(), false), keyFieldTypes.get(i), valueIndexDetails.getCastDefaultNull().getOrElse(false));
            TypeUtil.validateRecord((IAType)enforcedRecordType);
            enforcedRecordType = enforcedTypeBuilder.build();
        }
        return enforcedRecordType;
    }

    private static ARecordType appendTextIndexType(ARecordType enforcedRecordType, Index.TextIndexDetails textIndexDetails, EnforcedTypeBuilder enforcedTypeBuilder) throws AlgebricksException {
        List<List<String>> keyFieldNames = textIndexDetails.getKeyFieldNames();
        List<IAType> keyFieldTypes = textIndexDetails.getKeyFieldTypes();
        List<Integer> keySources = textIndexDetails.getKeyFieldSourceIndicators();
        for (int i = 0; i < keyFieldNames.size(); ++i) {
            if (keySources.get(i) != 0) {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"Indexing an open field is only supported on the record part"});
            }
            enforcedTypeBuilder.reset(enforcedRecordType, keyFieldNames.get(i), Collections.nCopies(keyFieldNames.get(i).size(), false), keyFieldTypes.get(i), false);
            TypeUtil.validateRecord((IAType)enforcedRecordType);
            enforcedRecordType = enforcedTypeBuilder.build();
        }
        return enforcedRecordType;
    }

    private static ARecordType appendArrayIndexTypes(ARecordType enforcedRecordType, Index.ArrayIndexDetails arrayIndexDetails, EnforcedTypeBuilder enforcedTypeBuilder) throws AlgebricksException {
        for (Index.ArrayIndexElement e : arrayIndexDetails.getElementList()) {
            if (e.getSourceIndicator() != 0) {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"Indexing an open field is only supported on the record part"});
            }
            List<List<String>> unnestList = e.getUnnestList();
            List<List<String>> projectList = e.getProjectList();
            List<IAType> typeList = e.getTypeList();
            for (int i = 0; i < projectList.size(); ++i) {
                List<String> project = projectList.get(i);
                enforcedTypeBuilder.reset(enforcedRecordType, ArrayIndexUtil.getFlattenedKeyFieldNames(unnestList, project), ArrayIndexUtil.getUnnestFlags(unnestList, project), typeList.get(i), false);
                TypeUtil.validateRecord((IAType)enforcedRecordType);
                enforcedRecordType = enforcedTypeBuilder.build();
            }
        }
        return enforcedRecordType;
    }

    private static Map<String, IAType> createRecordNameTypeMap(ARecordType recordType) {
        LinkedHashMap<String, IAType> recordNameTypesMap = new LinkedHashMap<String, IAType>();
        for (int j = 0; j < recordType.getFieldNames().length; ++j) {
            recordNameTypesMap.put(recordType.getFieldNames()[j], recordType.getFieldTypes()[j]);
        }
        return recordNameTypesMap;
    }

    private static IAType keepUnknown(IAType originalRecordType, ARecordType updatedRecordType) {
        if (originalRecordType.getTypeTag() == ATypeTag.UNION) {
            return AUnionType.createUnknownableType((IAType)updatedRecordType, (String)updatedRecordType.getTypeName());
        }
        return updatedRecordType;
    }

    private static void validateRecord(IAType enforcedDatasetRecordType) {
        if (enforcedDatasetRecordType.getTypeTag() != ATypeTag.OBJECT) {
            throw new IllegalStateException("The dataset type must be a record type to be able to build an index");
        }
    }

    private static void validateNestedRecord(IAType nestedRecordType, List<String> fieldName) throws AsterixException {
        IAType actualType = TypeComputeUtils.getActualType((IAType)nestedRecordType);
        if (actualType.getTypeTag() != ATypeTag.OBJECT) {
            String fName = String.join((CharSequence)".", fieldName);
            throw new AsterixException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"Field accessor is not defined for '" + LogRedactionUtil.userData((String)fName) + "' of type " + actualType.getTypeTag()});
        }
    }

    public static IAType createQuantifiedType(IAType primeType, boolean nullable, boolean missable) {
        if (primeType != null) {
            switch (primeType.getTypeTag()) {
                case ANY: 
                case UNION: 
                case NULL: 
                case MISSING: {
                    throw new IllegalArgumentException(primeType.getDisplayName());
                }
            }
        }
        IAType resType = primeType;
        if (nullable && missable) {
            resType = AUnionType.createUnknownableType((IAType)resType);
        } else if (nullable) {
            resType = AUnionType.createNullableType((IAType)resType);
        } else if (missable) {
            resType = AUnionType.createMissableType((IAType)resType);
        }
        return resType;
    }

    public static boolean isReservedInlineTypeName(String typeName) {
        return typeName.length() > 0 && typeName.charAt(0) == '$';
    }

    public static String createDatasetInlineTypeName(String datasetName, boolean forMetaItemType) {
        char typeChar = forMetaItemType ? (char)'m' : 'i';
        return DATASET_INLINE_TYPE_PREFIX + typeChar + "$" + datasetName;
    }

    public static boolean isDatasetInlineTypeName(Dataset dataset, String typeDatabaseName, DataverseName typeDataverseName, String typeName) {
        return TypeUtil.isInlineTypeName(dataset.getDatabaseName(), dataset.getDataverseName(), typeDatabaseName, typeDataverseName, typeName, DATASET_INLINE_TYPE_PREFIX);
    }

    private static boolean isInlineTypeName(String entityDatabaseName, DataverseName entityDataverseName, String typeDatabaseName, DataverseName typeDataverseName, String typeName, String inlineTypePrefix) {
        return entityDatabaseName.equals(typeDatabaseName) && entityDataverseName.equals((Object)typeDataverseName) && typeName.startsWith(inlineTypePrefix);
    }

    public static String createFunctionParameterTypeName(String functionName, int arity, int parameterIndex) {
        StringBuilder sb = new StringBuilder(FUNCTION_INLINE_TYPE_PREFIX.length() + functionName.length() + 8);
        sb.append(FUNCTION_INLINE_TYPE_PREFIX).append(functionName).append('$').append(arity);
        if (parameterIndex >= 0) {
            sb.append('$').append(parameterIndex);
        } else if (parameterIndex != -1) {
            throw new IllegalArgumentException(String.valueOf(parameterIndex));
        }
        return sb.toString();
    }

    public static boolean isFunctionInlineTypeName(Function function, String typeDatabaseName, DataverseName typeDataverseName, String typeName) {
        return TypeUtil.isInlineTypeName(function.getDatabaseName(), function.getDataverseName(), typeDatabaseName, typeDataverseName, typeName, FUNCTION_INLINE_TYPE_PREFIX);
    }

    public static String getFullyQualifiedDisplayName(DataverseName dataverseName, String typeName) {
        return MetadataUtil.getFullyQualifiedDisplayName((DataverseName)dataverseName, (String)typeName);
    }

    public static List<TypeSignature> getFunctionInlineTypes(Function function) {
        List<TypeSignature> parameterTypes;
        List<TypeSignature> inlineTypes = Collections.emptyList();
        TypeSignature returnType = function.getReturnType();
        if (returnType != null && TypeUtil.isFunctionInlineTypeName(function, returnType.getDatabaseName(), returnType.getDataverseName(), returnType.getName())) {
            inlineTypes = new ArrayList<TypeSignature>();
            inlineTypes.add(returnType);
        }
        if ((parameterTypes = function.getParameterTypes()) != null) {
            for (TypeSignature parameterType : parameterTypes) {
                if (parameterType == null || !TypeUtil.isFunctionInlineTypeName(function, parameterType.getDatabaseName(), parameterType.getDataverseName(), parameterType.getName())) continue;
                if (inlineTypes.isEmpty()) {
                    inlineTypes = new ArrayList<TypeSignature>();
                }
                inlineTypes.add(parameterType);
            }
        }
        return inlineTypes;
    }

    private static class EnforcedTypeBuilder {
        private final Deque<Triple<IAType, String, Boolean>> typeStack = new ArrayDeque<Triple<IAType, String, Boolean>>();
        private List<Boolean> keyUnnestFlags;
        private List<String> keyFieldNames;
        private ARecordType baseRecordType;
        private IAType keyFieldType;
        private String bridgeNameFoundFromOpenTypeBuild;
        private IAType endOfOpenTypeBuild;
        private int indexOfOpenPart;
        private boolean castDefaultNull;

        private EnforcedTypeBuilder() {
        }

        public void reset(ARecordType baseRecordType, List<String> keyFieldNames, List<Boolean> keyUnnestFlags, IAType keyFieldType, boolean castDefaultNull) {
            this.baseRecordType = baseRecordType;
            this.keyFieldNames = keyFieldNames;
            this.keyUnnestFlags = keyUnnestFlags;
            this.keyFieldType = keyFieldType;
            this.castDefaultNull = castDefaultNull;
        }

        public ARecordType build() throws AlgebricksException {
            boolean isOpen = this.constructNestedTypeStack();
            IAType newTypeToAdd = isOpen ? this.buildNewForOpenType() : this.buildNewForFullyClosedType();
            return this.buildRestOfRecord(newTypeToAdd);
        }

        private boolean constructNestedTypeStack() throws AlgebricksException {
            ARecordType typeIntermediate = this.baseRecordType;
            ArrayList<String> subFieldName = new ArrayList<String>();
            for (int i = 0; i < this.keyFieldNames.size() - 1; ++i) {
                this.typeStack.push((Triple<IAType, String, Boolean>)new Triple((Object)typeIntermediate, (Object)this.keyFieldNames.get(i), (Object)(i != 0 && this.keyUnnestFlags.get(i - 1) != false ? 1 : 0)));
                this.bridgeNameFoundFromOpenTypeBuild = typeIntermediate.getTypeName();
                if (i == 0 || !this.keyUnnestFlags.get(i - 1).booleanValue()) {
                    subFieldName.add(this.keyFieldNames.get(i));
                } else {
                    if ((typeIntermediate = TypeComputeUtils.extractListItemType((IAType)typeIntermediate)) == null) {
                        String fName = String.join((CharSequence)".", subFieldName);
                        throw new AsterixException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"No list item type found. Wrong type given from field " + LogRedactionUtil.userData((String)fName)});
                    }
                    subFieldName.add(this.keyFieldNames.get(i));
                }
                typeIntermediate = TypeComputeUtils.getActualType((IAType)typeIntermediate);
                typeIntermediate = typeIntermediate.getSubFieldType(subFieldName.subList(i, subFieldName.size()));
                if (typeIntermediate == null) {
                    this.endOfOpenTypeBuild = null;
                    this.indexOfOpenPart = i;
                    return true;
                }
                ATypeTag tt = TypeComputeUtils.getActualType((IAType)typeIntermediate).getTypeTag();
                if (tt == ATypeTag.OBJECT || tt == ATypeTag.ARRAY || tt == ATypeTag.MULTISET) continue;
                String fName = String.join((CharSequence)".", subFieldName);
                throw new AsterixException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"Field accessor is not defined for '" + LogRedactionUtil.userData((String)fName) + "' of type " + tt});
            }
            this.endOfOpenTypeBuild = typeIntermediate;
            this.indexOfOpenPart = this.keyFieldNames.size() - 1;
            return false;
        }

        private IAType buildNewForOpenType() {
            List<Boolean> unnestFlagsForOpenType = this.keyUnnestFlags.subList(this.indexOfOpenPart, this.keyUnnestFlags.size());
            List<String> fieldNamesForOpenType = this.keyFieldNames.subList(this.indexOfOpenPart, this.keyFieldNames.size());
            IAType resultant = this.keyFieldType;
            for (int i = unnestFlagsForOpenType.size() - 1; i >= 0; --i) {
                StringBuilder recordTypeNameBuilder = new StringBuilder();
                recordTypeNameBuilder.append(this.baseRecordType.getTypeName());
                for (int j = 0; j < i + this.indexOfOpenPart; ++j) {
                    recordTypeNameBuilder.append("_").append(this.keyFieldNames.get(j));
                    if (!this.keyUnnestFlags.get(j).booleanValue()) continue;
                    recordTypeNameBuilder.append("_Item");
                }
                resultant = EnforcedTypeBuilder.nestArrayType(resultant, unnestFlagsForOpenType.get(i));
                resultant = new ARecordType(recordTypeNameBuilder.toString(), new String[]{fieldNamesForOpenType.get(i)}, new IAType[]{AUnionType.createUnknownableType((IAType)resultant)}, true);
            }
            Triple<IAType, String, Boolean> gapTriple = this.typeStack.pop();
            ARecordType parentRecord = (ARecordType)EnforcedTypeBuilder.unnestArrayType(TypeComputeUtils.getActualType((IAType)((IAType)gapTriple.first)), (Boolean)gapTriple.third);
            IAType[] parentFieldTypes = (IAType[])ArrayUtils.addAll((Object[])((IAType[])parentRecord.getFieldTypes().clone()), (Object[])((IAType[])((ARecordType)resultant).getFieldTypes().clone()));
            resultant = new ARecordType(this.bridgeNameFoundFromOpenTypeBuild, (String[])ArrayUtils.addAll((Object[])parentRecord.getFieldNames(), (Object[])new String[]{(String)gapTriple.second}), parentFieldTypes, true);
            resultant = EnforcedTypeBuilder.keepUnknown((IAType)gapTriple.first, EnforcedTypeBuilder.nestArrayType(resultant, (Boolean)gapTriple.third));
            return resultant;
        }

        private IAType buildNewForFullyClosedType() throws AsterixException {
            IAType typeIntermediate = TypeComputeUtils.getActualType((IAType)this.endOfOpenTypeBuild);
            boolean isOpenTypeWithUnnest = this.indexOfOpenPart != 0 && this.keyUnnestFlags.get(this.indexOfOpenPart - 1) != false;
            boolean isKeyTypeWithUnnest = this.keyUnnestFlags.get(this.indexOfOpenPart);
            ARecordType lastNestedRecord = (ARecordType)EnforcedTypeBuilder.unnestArrayType(typeIntermediate, isOpenTypeWithUnnest);
            Map<String, IAType> recordNameTypesMap = EnforcedTypeBuilder.createRecordNameTypeMap(lastNestedRecord);
            IAType enforcedFieldType = recordNameTypesMap.get(this.keyFieldNames.get(this.keyFieldNames.size() - 1));
            if (enforcedFieldType != null && enforcedFieldType.getTypeTag() == ATypeTag.UNION && ((AUnionType)enforcedFieldType).isUnknownableType()) {
                enforcedFieldType = ((AUnionType)enforcedFieldType).getActualType();
            }
            if (enforcedFieldType != null) {
                if (this.castDefaultNull) {
                    recordNameTypesMap.put(this.keyFieldNames.get(this.keyFieldNames.size() - 1), AUnionType.createNullableType((IAType)EnforcedTypeBuilder.nestArrayType(this.keyFieldType, isKeyTypeWithUnnest)));
                } else if (!ATypeHierarchy.canPromote((ATypeTag)enforcedFieldType.getTypeTag(), (ATypeTag)this.keyFieldType.getTypeTag())) {
                    throw new AsterixException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"Cannot enforce field '" + LogRedactionUtil.userData((String)String.join((CharSequence)".", this.keyFieldNames)) + "' to have type " + this.keyFieldType});
                }
            } else {
                recordNameTypesMap.put(this.keyFieldNames.get(this.keyFieldNames.size() - 1), AUnionType.createUnknownableType((IAType)EnforcedTypeBuilder.nestArrayType(this.keyFieldType, isKeyTypeWithUnnest)));
            }
            IAType resultant = EnforcedTypeBuilder.nestArrayType((IAType)new ARecordType(lastNestedRecord.getTypeName(), recordNameTypesMap.keySet().toArray(new String[0]), recordNameTypesMap.values().toArray(new IAType[0]), lastNestedRecord.isOpen()), isOpenTypeWithUnnest);
            return EnforcedTypeBuilder.keepUnknown(this.endOfOpenTypeBuild, resultant);
        }

        private ARecordType buildRestOfRecord(IAType newTypeToAdd) {
            IAType resultant = TypeComputeUtils.getActualType((IAType)newTypeToAdd);
            while (!this.typeStack.isEmpty()) {
                Triple<IAType, String, Boolean> typeFromStack = this.typeStack.pop();
                IAType typeIntermediate = EnforcedTypeBuilder.unnestArrayType((IAType)typeFromStack.first, (Boolean)typeFromStack.third);
                typeIntermediate = TypeComputeUtils.getActualType((IAType)typeIntermediate);
                ARecordType recordType = (ARecordType)typeIntermediate;
                IAType[] fieldTypes = (IAType[])recordType.getFieldTypes().clone();
                fieldTypes[recordType.getFieldIndex((String)((String)typeFromStack.second))] = resultant;
                typeIntermediate = EnforcedTypeBuilder.nestArrayType((IAType)new ARecordType(recordType.getTypeName() + "_enforced", recordType.getFieldNames(), fieldTypes, recordType.isOpen()), (Boolean)typeFromStack.third);
                resultant = EnforcedTypeBuilder.keepUnknown((IAType)typeFromStack.first, typeIntermediate);
            }
            return (ARecordType)resultant;
        }

        private static Map<String, IAType> createRecordNameTypeMap(ARecordType recordType) {
            LinkedHashMap<String, IAType> recordNameTypesMap = new LinkedHashMap<String, IAType>();
            for (int j = 0; j < recordType.getFieldNames().length; ++j) {
                recordNameTypesMap.put(recordType.getFieldNames()[j], recordType.getFieldTypes()[j]);
            }
            return recordNameTypesMap;
        }

        private static IAType keepUnknown(IAType originalRecordType, IAType updatedRecordType) {
            if (originalRecordType.getTypeTag() == ATypeTag.UNION) {
                return AUnionType.createUnknownableType((IAType)updatedRecordType, (String)updatedRecordType.getTypeName());
            }
            return updatedRecordType;
        }

        private static IAType nestArrayType(IAType originalType, boolean isWithinArray) {
            if (isWithinArray) {
                String newTypeName = originalType.getTypeName().endsWith("_Item") ? originalType.getTypeName().substring(0, originalType.getTypeName().length() - 5) : originalType.getTypeName();
                return new AOrderedListType(originalType, newTypeName + "_Array");
            }
            return originalType;
        }

        private static IAType unnestArrayType(IAType originalType, boolean isWithinArray) {
            IAType resultant = originalType;
            if (isWithinArray && (resultant = TypeComputeUtils.extractListItemType((IAType)resultant)) != null) {
                resultant = TypeComputeUtils.getActualType((IAType)resultant);
            }
            return resultant;
        }
    }
}

