/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.io.DataOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.cluster.PartitioningProperties;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.context.ITransactionSubsystemProvider;
import org.apache.asterix.common.context.TransactionSubsystemProvider;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataConstants;
import org.apache.asterix.common.metadata.MetadataUtil;
import org.apache.asterix.common.utils.IdentifierUtil;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.formats.base.IDataFormat;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.formats.nontagged.TypeTraitProvider;
import org.apache.asterix.metadata.IDatasetDetails;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.IATypeVisitor;
import org.apache.asterix.om.types.visitor.SimpleStringBuilderForIATypeVisitor;
import org.apache.asterix.om.utils.ProjectionFiltrationTypeUtil;
import org.apache.asterix.runtime.operators.LSMPrimaryUpsertOperatorDescriptor;
import org.apache.asterix.runtime.utils.RuntimeUtils;
import org.apache.asterix.transaction.management.opcallbacks.PrimaryIndexInstantSearchOperationCallbackFactory;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraintHelper;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.data.IBinaryComparatorFactoryProvider;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunctionFactory;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionerFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.partition.FieldHashPartitionerFactory;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;
import org.apache.hyracks.dataflow.std.misc.ConstantTupleSourceOperatorDescriptor;
import org.apache.hyracks.storage.am.btree.dataflow.BTreeSearchOperatorDescriptor;
import org.apache.hyracks.storage.am.common.api.IIndexBuilderFactory;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.build.IndexBuilderFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexCreateOperatorDescriptor;
import org.apache.hyracks.storage.am.common.dataflow.IndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexDropOperatorDescriptor;
import org.apache.hyracks.storage.am.common.impls.DefaultTupleProjectorFactory;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.dataflow.LSMTreeIndexCompactOperatorDescriptor;
import org.apache.hyracks.storage.common.IResourceFactory;
import org.apache.hyracks.storage.common.projection.ITupleProjectorFactory;
import org.apache.hyracks.util.LogRedactionUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatasetUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final byte OP_UPSERT = 3;

    private DatasetUtil() {
    }

    public static Integer getFilterSourceIndicator(Dataset dataset) {
        return ((InternalDatasetDetails)dataset.getDatasetDetails()).getFilterSourceIndicator();
    }

    public static List<String> getFilterField(Dataset dataset) {
        return ((InternalDatasetDetails)dataset.getDatasetDetails()).getFilterField();
    }

    public static IBinaryComparatorFactory[] computeFilterBinaryComparatorFactories(Dataset dataset, ARecordType recordType, ARecordType metaType, IBinaryComparatorFactoryProvider comparatorFactoryProvider) throws AlgebricksException {
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            return null;
        }
        Integer filterFieldSourceIndicator = DatasetUtil.getFilterSourceIndicator(dataset);
        List<String> filterField = DatasetUtil.getFilterField(dataset);
        if (filterField == null) {
            return null;
        }
        IBinaryComparatorFactory[] bcfs = new IBinaryComparatorFactory[1];
        ARecordType itemType = filterFieldSourceIndicator == 0 ? recordType : metaType;
        IAType type = itemType.getSubFieldType(filterField);
        bcfs[0] = comparatorFactoryProvider.getBinaryComparatorFactory((Object)type, true);
        return bcfs;
    }

    public static ITypeTraits[] computeFilterTypeTraits(Dataset dataset, ARecordType recordType, ARecordType metaType) throws AlgebricksException {
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            return null;
        }
        Integer filterFieldSourceIndicator = DatasetUtil.getFilterSourceIndicator(dataset);
        List<String> filterField = DatasetUtil.getFilterField(dataset);
        if (filterField == null) {
            return null;
        }
        ARecordType itemType = filterFieldSourceIndicator == 0 ? recordType : metaType;
        ITypeTraits[] typeTraits = new ITypeTraits[1];
        IAType type = itemType.getSubFieldType(filterField);
        typeTraits[0] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)type);
        return typeTraits;
    }

    public static int[] createFilterFields(Dataset dataset) {
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            return null;
        }
        List<String> filterField = DatasetUtil.getFilterField(dataset);
        if (filterField == null) {
            return null;
        }
        List<List<String>> partitioningKeys = dataset.getPrimaryKeys();
        int numKeys = partitioningKeys.size();
        int[] filterFields = new int[1];
        int valueFields = dataset.hasMetaPart() ? 2 : 1;
        filterFields[0] = numKeys + valueFields;
        return filterFields;
    }

    public static int[] createBTreeFieldsWhenThereisAFilter(Dataset dataset) {
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            return null;
        }
        List<String> filterField = DatasetUtil.getFilterField(dataset);
        if (filterField == null) {
            return null;
        }
        List<List<String>> partitioningKeys = dataset.getPrimaryKeys();
        int valueFields = dataset.hasMetaPart() ? 2 : 1;
        int[] btreeFields = new int[partitioningKeys.size() + valueFields];
        for (int i = 0; i < btreeFields.length; ++i) {
            btreeFields[i] = i;
        }
        return btreeFields;
    }

    public static List<Integer> getKeySourceIndicators(Dataset dataset) {
        IDatasetDetails datasetDetails = dataset.getDatasetDetails();
        if (datasetDetails.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
            return ((InternalDatasetDetails)datasetDetails).getKeySourceIndicator();
        }
        return null;
    }

    public static int getPositionOfPartitioningKeyField(Dataset dataset, List<String> fieldExpr, boolean fieldFromMeta) {
        List<Integer> keySourceIndicator = null;
        IDatasetDetails datasetDetails = dataset.getDatasetDetails();
        if (datasetDetails.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
            keySourceIndicator = ((InternalDatasetDetails)datasetDetails).getKeySourceIndicator();
        }
        List<List<String>> partitioningKeys = dataset.getPrimaryKeys();
        for (int i = 0; i < partitioningKeys.size(); ++i) {
            List<String> partitioningKey = partitioningKeys.get(i);
            if (!partitioningKey.equals(fieldExpr) || !DatasetUtil.keySourceMatches(keySourceIndicator, i, fieldFromMeta)) continue;
            return i;
        }
        return -1;
    }

    private static boolean keySourceMatches(List<Integer> keySourceIndicator, int keyIndex, boolean fieldFromMeta) {
        if (keySourceIndicator != null) {
            return fieldFromMeta && keySourceIndicator.get(keyIndex) == 1 || !fieldFromMeta && keySourceIndicator.get(keyIndex) == 0;
        }
        return true;
    }

    public static Pair<ILSMMergePolicyFactory, Map<String, String>> getMergePolicyFactory(Dataset dataset, MetadataTransactionContext mdTxnCtx) throws AlgebricksException {
        ILSMMergePolicyFactory mergePolicyFactory;
        String policyName = dataset.getCompactionPolicy();
        CompactionPolicy compactionPolicy = MetadataManager.INSTANCE.getCompactionPolicy(mdTxnCtx, "System", MetadataConstants.METADATA_DATAVERSE_NAME, policyName);
        String compactionPolicyFactoryClassName = compactionPolicy.getClassName();
        Map<String, String> properties = dataset.getCompactionPolicyProperties();
        try {
            mergePolicyFactory = (ILSMMergePolicyFactory)Class.forName(compactionPolicyFactoryClassName).newInstance();
            if (mergePolicyFactory.getName().compareTo("correlated-prefix") == 0) {
                properties.put("datasetId", Integer.toString(dataset.getDatasetId()));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new AlgebricksException((Throwable)e);
        }
        return new Pair((Object)mergePolicyFactory, properties);
    }

    public static void writePropertyTypeRecord(String name, String value, DataOutput out, ARecordType recordType) throws HyracksDataException {
        RecordBuilder propertyRecordBuilder = new RecordBuilder();
        ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
        propertyRecordBuilder.reset(recordType);
        AMutableString aString = new AMutableString("");
        ISerializerDeserializer stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
        fieldValue.reset();
        aString.setValue(name);
        stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        propertyRecordBuilder.addField(0, (IValueReference)fieldValue);
        fieldValue.reset();
        aString.setValue(value);
        stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        propertyRecordBuilder.addField(1, (IValueReference)fieldValue);
        propertyRecordBuilder.write(out, true);
    }

    public static ARecordType getMetaType(MetadataProvider metadataProvider, Dataset dataset) throws AlgebricksException {
        if (dataset.hasMetaPart()) {
            return (ARecordType)metadataProvider.findType(dataset.getMetaItemTypeDatabaseName(), dataset.getMetaItemTypeDataverseName(), dataset.getMetaItemTypeName());
        }
        return null;
    }

    public static JobSpecification dropDatasetJobSpec(Dataset dataset, MetadataProvider metadataProvider) throws AlgebricksException, ACIDException {
        return DatasetUtil.dropDatasetJobSpec(dataset, metadataProvider, Collections.emptySet());
    }

    public static JobSpecification dropDatasetJobSpec(Dataset dataset, MetadataProvider metadataProvider, Set<IndexDropOperatorDescriptor.DropOption> options) throws AlgebricksException, ACIDException {
        LOGGER.info("DROP DATASET: " + dataset);
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            return RuntimeUtils.createJobSpecification((ICcApplicationContext)metadataProvider.getApplicationContext());
        }
        JobSpecification specPrimary = RuntimeUtils.createJobSpecification((ICcApplicationContext)metadataProvider.getApplicationContext());
        PartitioningProperties partitioningProperties = metadataProvider.getPartitioningProperties(dataset);
        IndexDataflowHelperFactory indexHelperFactory = new IndexDataflowHelperFactory(metadataProvider.getStorageComponentProvider().getStorageManager(), partitioningProperties.getSplitsProvider());
        IndexDropOperatorDescriptor primaryBtreeDrop = new IndexDropOperatorDescriptor((IOperatorDescriptorRegistry)specPrimary, (IIndexDataflowHelperFactory)indexHelperFactory, options, partitioningProperties.getComputeStorageMap());
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)specPrimary, (IOperatorDescriptor)primaryBtreeDrop, (AlgebricksPartitionConstraint)partitioningProperties.getConstraints());
        specPrimary.addRoot((IOperatorDescriptor)primaryBtreeDrop);
        return specPrimary;
    }

    public static JobSpecification createDatasetJobSpec(Dataset dataset, MetadataProvider metadataProvider) throws AlgebricksException {
        Index index = IndexUtil.getPrimaryIndex(dataset);
        ARecordType itemType = (ARecordType)metadataProvider.findType(dataset);
        ARecordType metaItemType = null;
        if (dataset.hasMetaPart()) {
            metaItemType = (ARecordType)metadataProvider.findMetaType(dataset);
        }
        itemType = (ARecordType)metadataProvider.findTypeForDatasetWithoutType((IAType)itemType, (IAType)metaItemType, dataset);
        JobSpecification spec = RuntimeUtils.createJobSpecification((ICcApplicationContext)metadataProvider.getApplicationContext());
        PartitioningProperties partitioningProperties = metadataProvider.getPartitioningProperties(dataset);
        IFileSplitProvider splitsProvider = partitioningProperties.getSplitsProvider();
        FileSplit[] fs = splitsProvider.getFileSplits();
        StringBuilder sb = new StringBuilder();
        for (FileSplit f : fs) {
            sb.append(f).append(" ");
        }
        LOGGER.info("CREATING File Splits: {}", (Object)sb);
        Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtil.getMergePolicyFactory(dataset, metadataProvider.getMetadataTxnContext());
        int[][] computeStorageMap = partitioningProperties.getComputeStorageMap();
        IndexBuilderFactory[][] indexBuilderFactories = DatasetUtil.getIndexBuilderFactories(dataset, metadataProvider, index, itemType, metaItemType, splitsProvider, (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, computeStorageMap);
        IndexCreateOperatorDescriptor indexCreateOp = new IndexCreateOperatorDescriptor((IOperatorDescriptorRegistry)spec, (IIndexBuilderFactory[][])indexBuilderFactories, computeStorageMap);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)indexCreateOp, (AlgebricksPartitionConstraint)partitioningProperties.getConstraints());
        spec.addRoot((IOperatorDescriptor)indexCreateOp);
        return spec;
    }

    public static IndexBuilderFactory[][] getIndexBuilderFactories(Dataset dataset, MetadataProvider metadataProvider, Index index, ARecordType itemType, ARecordType metaItemType, IFileSplitProvider fileSplitProvider, ILSMMergePolicyFactory mergePolicyFactory, Map<String, String> mergePolicyProperties, int[][] computeStorageMap) throws AlgebricksException {
        IndexBuilderFactory[][] indexBuilderFactories = new IndexBuilderFactory[computeStorageMap.length][];
        for (int i = 0; i < computeStorageMap.length; ++i) {
            int len = computeStorageMap[i].length;
            indexBuilderFactories[i] = new IndexBuilderFactory[len];
            for (int k = 0; k < len; ++k) {
                IndexBuilderFactory indexBuilderFactory;
                IResourceFactory resourceFactory = dataset.getResourceFactory(metadataProvider, index, itemType, metaItemType, mergePolicyFactory, mergePolicyProperties);
                indexBuilderFactories[i][k] = indexBuilderFactory = new IndexBuilderFactory(metadataProvider.getStorageComponentProvider().getStorageManager(), fileSplitProvider, resourceFactory, true);
            }
        }
        return indexBuilderFactories;
    }

    public static JobSpecification compactDatasetJobSpec(Dataverse dataverse, String datasetName, MetadataProvider metadataProvider) throws AlgebricksException {
        DataverseName dataverseName = dataverse.getDataverseName();
        Dataset dataset = metadataProvider.findDataset(dataverse.getDatabaseName(), dataverseName, datasetName);
        if (dataset == null) {
            throw new AsterixException(ErrorCode.UNKNOWN_DATASET_IN_DATAVERSE, new Serializable[]{datasetName, MetadataUtil.dataverseName((String)dataverse.getDatabaseName(), (DataverseName)dataverseName, (boolean)metadataProvider.isUsingDatabase())});
        }
        JobSpecification spec = RuntimeUtils.createJobSpecification((ICcApplicationContext)metadataProvider.getApplicationContext());
        PartitioningProperties partitioningProperties = metadataProvider.getPartitioningProperties(dataset);
        IndexDataflowHelperFactory indexHelperFactory = new IndexDataflowHelperFactory(metadataProvider.getStorageComponentProvider().getStorageManager(), partitioningProperties.getSplitsProvider());
        LSMTreeIndexCompactOperatorDescriptor compactOp = new LSMTreeIndexCompactOperatorDescriptor((IOperatorDescriptorRegistry)spec, (IIndexDataflowHelperFactory)indexHelperFactory, partitioningProperties.getComputeStorageMap());
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)compactOp, (AlgebricksPartitionConstraint)partitioningProperties.getConstraints());
        spec.addRoot((IOperatorDescriptor)compactOp);
        return spec;
    }

    public static IOperatorDescriptor createPrimaryIndexScanOp(JobSpecification spec, MetadataProvider metadataProvider, Dataset dataset) throws AlgebricksException {
        return DatasetUtil.createPrimaryIndexScanOp(spec, metadataProvider, dataset, (ITupleProjectorFactory)DefaultTupleProjectorFactory.INSTANCE);
    }

    public static IOperatorDescriptor createPrimaryIndexScanOp(JobSpecification spec, MetadataProvider metadataProvider, Dataset dataset, ITupleProjectorFactory projectorFactory) throws AlgebricksException {
        PartitioningProperties partitioningProperties = metadataProvider.getPartitioningProperties(dataset);
        IFileSplitProvider primaryFileSplitProvider = partitioningProperties.getSplitsProvider();
        AlgebricksPartitionConstraint primaryPartitionConstraint = partitioningProperties.getConstraints();
        int[] lowKeyFields = null;
        int[] highKeyFields = null;
        TransactionSubsystemProvider txnSubsystemProvider = TransactionSubsystemProvider.INSTANCE;
        PrimaryIndexInstantSearchOperationCallbackFactory searchCallbackFactory = new PrimaryIndexInstantSearchOperationCallbackFactory(dataset.getDatasetId(), dataset.getPrimaryBloomFilterFields(), (ITransactionSubsystemProvider)txnSubsystemProvider, 0);
        IndexDataflowHelperFactory indexHelperFactory = new IndexDataflowHelperFactory(metadataProvider.getStorageComponentProvider().getStorageManager(), primaryFileSplitProvider);
        BTreeSearchOperatorDescriptor primarySearchOp = new BTreeSearchOperatorDescriptor((IOperatorDescriptorRegistry)spec, dataset.getPrimaryRecordDescriptor(metadataProvider), lowKeyFields, highKeyFields, true, true, (IIndexDataflowHelperFactory)indexHelperFactory, false, false, null, (ISearchOperationCallbackFactory)searchCallbackFactory, null, null, false, null, null, -1L, false, null, null, projectorFactory, null, partitioningProperties.getComputeStorageMap());
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)primarySearchOp, (AlgebricksPartitionConstraint)primaryPartitionConstraint);
        return primarySearchOp;
    }

    public static Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> createPrimaryIndexUpsertOp(JobSpecification spec, MetadataProvider metadataProvider, Dataset dataset, RecordDescriptor inputRecordDesc, int[] fieldPermutation, IMissingWriterFactory missingWriterFactory) throws AlgebricksException {
        int numKeys = dataset.getPrimaryKeys().size();
        int numFilterFields = DatasetUtil.getFilterField(dataset) == null ? 0 : 1;
        ARecordType itemType = (ARecordType)metadataProvider.findType(dataset);
        ARecordType metaItemType = (ARecordType)metadataProvider.findMetaType(dataset);
        itemType = (ARecordType)metadataProvider.findTypeForDatasetWithoutType((IAType)itemType, (IAType)metaItemType, dataset);
        Index primaryIndex = metadataProvider.getIndex(dataset.getDatabaseName(), dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName());
        PartitioningProperties partitioningProperties = metadataProvider.getPartitioningProperties(dataset);
        int[] primaryKeyFields = new int[numKeys];
        int[] pkFields = new int[numKeys];
        for (int i = 0; i < numKeys; ++i) {
            primaryKeyFields[i] = i;
            pkFields[i] = fieldPermutation[i];
        }
        boolean hasSecondaries = metadataProvider.getDatasetIndexes(dataset.getDatabaseName(), dataset.getDataverseName(), dataset.getDatasetName()).size() > 1;
        IStorageComponentProvider storageComponentProvider = metadataProvider.getStorageComponentProvider();
        IModificationOperationCallbackFactory modificationCallbackFactory = dataset.getModificationCallbackFactory(storageComponentProvider, primaryIndex, IndexOperation.UPSERT, primaryKeyFields);
        ISearchOperationCallbackFactory searchCallbackFactory = dataset.getSearchCallbackFactory(storageComponentProvider, primaryIndex, IndexOperation.UPSERT, primaryKeyFields);
        IndexDataflowHelperFactory idfh = new IndexDataflowHelperFactory(storageComponentProvider.getStorageManager(), partitioningProperties.getSplitsProvider());
        ITypeTraits[] outputTypeTraits = new ITypeTraits[inputRecordDesc.getFieldCount() + 1 + (dataset.hasMetaPart() ? 2 : 1) + numFilterFields];
        ISerializerDeserializer[] outputSerDes = new ISerializerDeserializer[inputRecordDesc.getFieldCount() + 1 + (dataset.hasMetaPart() ? 2 : 1) + numFilterFields];
        IDataFormat dataFormat = metadataProvider.getDataFormat();
        int f = 0;
        outputSerDes[f] = dataFormat.getSerdeProvider().getSerializerDeserializer((Object)BuiltinType.AINT8);
        outputTypeTraits[f] = dataFormat.getTypeTraitProvider().getTypeTrait((Object)BuiltinType.AINT8);
        outputSerDes[++f] = dataFormat.getSerdeProvider().getSerializerDeserializer((Object)itemType);
        outputTypeTraits[f] = dataFormat.getTypeTraitProvider().getTypeTrait((Object)itemType);
        ++f;
        if (dataset.hasMetaPart()) {
            outputSerDes[f] = dataFormat.getSerdeProvider().getSerializerDeserializer((Object)metaItemType);
            outputTypeTraits[f] = dataFormat.getTypeTraitProvider().getTypeTrait((Object)metaItemType);
            ++f;
        }
        int fieldIdx = -1;
        Integer filterSourceIndicator = null;
        ARecordType filterItemType = null;
        if (numFilterFields > 0) {
            int i;
            filterSourceIndicator = DatasetUtil.getFilterSourceIndicator(dataset);
            String filterField = DatasetUtil.getFilterField(dataset).get(0);
            filterItemType = filterSourceIndicator == 0 ? itemType : metaItemType;
            String[] fieldNames = filterItemType.getFieldNames();
            for (i = 0; i < fieldNames.length && !fieldNames[i].equals(filterField); ++i) {
            }
            fieldIdx = i;
            outputTypeTraits[f] = dataFormat.getTypeTraitProvider().getTypeTrait((Object)filterItemType.getFieldTypes()[fieldIdx]);
            outputSerDes[f] = dataFormat.getSerdeProvider().getSerializerDeserializer((Object)filterItemType.getFieldTypes()[fieldIdx]);
            ++f;
        }
        for (int j = 0; j < inputRecordDesc.getFieldCount(); ++j) {
            outputTypeTraits[j + f] = inputRecordDesc.getTypeTraits()[j];
            outputSerDes[j + f] = inputRecordDesc.getFields()[j];
        }
        RecordDescriptor outputRecordDesc = new RecordDescriptor(outputSerDes, outputTypeTraits);
        ARecordType requestedType = DatasetUtil.getPrevRecordType(metadataProvider, dataset, itemType);
        ITupleProjectorFactory projectorFactory = IndexUtil.createUpsertTupleProjectorFactory(dataset.getDatasetFormatInfo(), requestedType, itemType, metaItemType, numKeys);
        IBinaryHashFunctionFactory[] pkHashFunFactories = dataset.getPrimaryHashFunctionFactories(metadataProvider);
        FieldHashPartitionerFactory tuplePartitionerFactory = new FieldHashPartitionerFactory(pkFields, pkHashFunFactories, partitioningProperties.getNumberOfPartitions());
        LSMPrimaryUpsertOperatorDescriptor op = new LSMPrimaryUpsertOperatorDescriptor((IOperatorDescriptorRegistry)spec, outputRecordDesc, fieldPermutation, (IIndexDataflowHelperFactory)idfh, missingWriterFactory, modificationCallbackFactory, searchCallbackFactory, dataset.getFrameOpCallbackFactory(metadataProvider), numKeys, filterSourceIndicator, filterItemType, fieldIdx, hasSecondaries, projectorFactory, (ITuplePartitionerFactory)tuplePartitionerFactory, partitioningProperties.getComputeStorageMap());
        return new Pair((Object)op, (Object)partitioningProperties.getConstraints());
    }

    private static ARecordType getPrevRecordType(MetadataProvider metadataProvider, Dataset dataset, ARecordType itemType) throws AlgebricksException {
        ARecordType result;
        if (dataset.getDatasetFormatInfo().getFormat() == DatasetConfig.DatasetFormat.ROW) {
            return itemType;
        }
        List<Index> secondaryIndexes = metadataProvider.getDatasetIndexes(dataset.getDatabaseName(), dataset.getDataverseName(), dataset.getDatasetName());
        ArrayList<ARecordType> indexPaths = new ArrayList<ARecordType>();
        for (Index index : secondaryIndexes) {
            Index.AbstractIndexDetails indexDetails;
            if (!index.isSecondaryIndex() || index.isPrimaryKeyIndex() || index.isSampleIndex()) continue;
            if (index.getIndexType() == DatasetConfig.IndexType.BTREE) {
                indexDetails = (Index.ValueIndexDetails)index.getIndexDetails();
                indexPaths.add(((Index.ValueIndexDetails)indexDetails).getIndexExpectedType());
                continue;
            }
            if (index.getIndexType() != DatasetConfig.IndexType.ARRAY) continue;
            indexDetails = (Index.ArrayIndexDetails)index.getIndexDetails();
            indexPaths.add(((Index.ArrayIndexDetails)indexDetails).getIndexExpectedType());
        }
        ARecordType aRecordType = result = indexPaths.isEmpty() ? ProjectionFiltrationTypeUtil.EMPTY_TYPE : ProjectionFiltrationTypeUtil.merge(indexPaths);
        if (LOGGER.isInfoEnabled() && result != ProjectionFiltrationTypeUtil.EMPTY_TYPE) {
            SimpleStringBuilderForIATypeVisitor schemaPrinter = new SimpleStringBuilderForIATypeVisitor();
            StringBuilder builder = new StringBuilder();
            result.accept((IATypeVisitor)schemaPrinter, (Object)builder);
            LOGGER.info("Upsert previous tuple schema: {}", (Object)LogRedactionUtil.userData((String)builder.toString()));
        }
        return result;
    }

    public static IOperatorDescriptor createDummyKeyProviderOp(JobSpecification spec, Dataset dataset, MetadataProvider metadataProvider) throws AlgebricksException {
        PartitioningProperties partitioningProperties = metadataProvider.getPartitioningProperties(dataset);
        AlgebricksPartitionConstraint primaryPartitionConstraint = partitioningProperties.getConstraints();
        IOperatorDescriptor dummyKeyProviderOp = DatasetUtil.createDummyKeyProviderOp(spec);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)dummyKeyProviderOp, (AlgebricksPartitionConstraint)primaryPartitionConstraint);
        return dummyKeyProviderOp;
    }

    public static IOperatorDescriptor createCorrelatedDummyKeyProviderOp(JobSpecification spec, AlgebricksPartitionConstraint apc) throws AlgebricksException {
        IOperatorDescriptor dummyKeyProviderOp = DatasetUtil.createDummyKeyProviderOp(spec);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)dummyKeyProviderOp, (AlgebricksPartitionConstraint)apc);
        return dummyKeyProviderOp;
    }

    private static IOperatorDescriptor createDummyKeyProviderOp(JobSpecification spec) throws AlgebricksException {
        ArrayTupleBuilder tb = new ArrayTupleBuilder(1);
        DataOutput dos = tb.getDataOutput();
        tb.reset();
        try {
            IntegerSerializerDeserializer.INSTANCE.serialize(Integer.valueOf(0), dos);
        }
        catch (HyracksDataException e) {
            throw new AsterixException((Throwable)e);
        }
        tb.addFieldEndOffset();
        ISerializerDeserializer[] keyRecDescSers = new ISerializerDeserializer[]{IntegerSerializerDeserializer.INSTANCE};
        RecordDescriptor keyRecDesc = new RecordDescriptor(keyRecDescSers);
        ConstantTupleSourceOperatorDescriptor keyProviderOp = new ConstantTupleSourceOperatorDescriptor((IOperatorDescriptorRegistry)spec, keyRecDesc, tb.getFieldEndOffsets(), tb.getByteArray(), tb.getSize());
        return keyProviderOp;
    }

    public static String getFullyQualifiedDisplayName(Dataset dataset) {
        return DatasetUtil.getFullyQualifiedDisplayName(dataset.getDataverseName(), dataset.getDatasetName());
    }

    public static String getFullyQualifiedDisplayName(DataverseName dataverseName, String datasetName) {
        return MetadataUtil.getFullyQualifiedDisplayName((DataverseName)dataverseName, (String)datasetName);
    }

    public static String getFullyQualifiedDisplayName(String databaseName, DataverseName dataverseName, String datasetName) {
        return MetadataUtil.getFullyQualifiedDisplayName((String)databaseName, (DataverseName)dataverseName, (String)datasetName);
    }

    public static String createNodeGroupForNewDataset(String databaseName, DataverseName dataverseName, String datasetName, Set<String> ncNames, MetadataProvider metadataProvider) throws Exception {
        return DatasetUtil.createNodeGroupForNewDataset(databaseName, dataverseName, datasetName, 0L, ncNames, metadataProvider);
    }

    public static String createNodeGroupForNewDataset(String databaseName, DataverseName dataverseName, String datasetName, long rebalanceCount, Set<String> ncNames, MetadataProvider metadataProvider) throws Exception {
        ICcApplicationContext appCtx = metadataProvider.getApplicationContext();
        boolean useDb = metadataProvider.getNamespaceResolver().isUsingDatabase();
        String nodeGroup = (String)(useDb ? databaseName + "." : "") + dataverseName.getCanonicalForm() + "." + datasetName + (String)(rebalanceCount == 0L ? "" : "_" + rebalanceCount);
        MetadataTransactionContext mdTxnCtx = metadataProvider.getMetadataTxnContext();
        appCtx.getMetadataLockManager().acquireNodeGroupWriteLock(metadataProvider.getLocks(), nodeGroup);
        NodeGroup ng = MetadataManager.INSTANCE.getNodegroup(mdTxnCtx, nodeGroup);
        if (ng != null) {
            nodeGroup = nodeGroup + "_" + UUID.randomUUID();
            appCtx.getMetadataLockManager().acquireNodeGroupWriteLock(metadataProvider.getLocks(), nodeGroup);
        }
        MetadataManager.INSTANCE.addNodegroup(mdTxnCtx, NodeGroup.createOrdered(nodeGroup, ncNames));
        return nodeGroup;
    }

    public static String getDatasetTypeDisplayName(DatasetConfig.DatasetType datasetType) {
        return datasetType == DatasetConfig.DatasetType.VIEW ? "view" : IdentifierUtil.dataset();
    }

    public static boolean isNotView(Dataset dataset) {
        return dataset.getDatasetType() != DatasetConfig.DatasetType.VIEW;
    }

    public static boolean isFieldAccessPushdownSupported(Dataset dataset) {
        DatasetConfig.DatasetType datasetType = dataset.getDatasetType();
        if (datasetType == DatasetConfig.DatasetType.INTERNAL) {
            return dataset.getDatasetFormatInfo().getFormat() == DatasetConfig.DatasetFormat.COLUMN;
        }
        if (datasetType == DatasetConfig.DatasetType.EXTERNAL) {
            ExternalDatasetDetails edd = (ExternalDatasetDetails)dataset.getDatasetDetails();
            return ExternalDataUtils.supportsPushdown(edd.getProperties());
        }
        return false;
    }

    public static boolean isFilterPushdownSupported(Dataset dataset) {
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
            return dataset.getDatasetFormatInfo().getFormat() == DatasetConfig.DatasetFormat.COLUMN;
        }
        return true;
    }

    public static boolean isRangeFilterPushdownSupported(Dataset dataset) {
        return dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL && dataset.getDatasetFormatInfo().getFormat() == DatasetConfig.DatasetFormat.COLUMN;
    }
}

