/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.io.DataOutput;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataUtil;
import org.apache.asterix.metadata.bootstrap.FeedEntity;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.AUnorderedList;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class FeedTupleTranslator
extends AbstractTupleTranslator<Feed> {
    private final FeedEntity feedEntity;

    protected FeedTupleTranslator(boolean getTuple, FeedEntity feedEntity) {
        super(getTuple, feedEntity.getIndex(), feedEntity.payloadPosition());
        this.feedEntity = feedEntity;
    }

    @Override
    protected Feed createMetadataEntityFromARecord(ARecord feedRecord) throws AlgebricksException {
        String dataverseCanonicalName = ((AString)feedRecord.getValueByPos(this.feedEntity.dataverseNameIndex())).getStringValue();
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)dataverseCanonicalName);
        int databaseNameIndex = this.feedEntity.databaseNameIndex();
        String databaseName = databaseNameIndex >= 0 ? ((AString)feedRecord.getValueByPos(databaseNameIndex)).getStringValue() : MetadataUtil.databaseFor((DataverseName)dataverseName);
        String feedName = ((AString)feedRecord.getValueByPos(this.feedEntity.feedNameIndex())).getStringValue();
        AUnorderedList feedConfig = (AUnorderedList)feedRecord.getValueByPos(this.feedEntity.adapterConfigIndex());
        IACursor cursor = feedConfig.getCursor();
        HashMap<String, String> adaptorConfiguration = new HashMap<String, String>();
        while (cursor.next()) {
            ARecord field = (ARecord)cursor.get();
            String key = ((AString)field.getValueByPos(0)).getStringValue();
            String value = ((AString)field.getValueByPos(1)).getStringValue();
            adaptorConfiguration.put(key, value);
        }
        return new Feed(databaseName, dataverseName, feedName, adaptorConfiguration);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(Feed feed) throws HyracksDataException {
        String dataverseCanonicalName = feed.getDataverseName().getCanonicalForm();
        this.tupleBuilder.reset();
        if (this.feedEntity.databaseNameIndex() >= 0) {
            this.aString.setValue(feed.getDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
            this.tupleBuilder.addFieldEndOffset();
        }
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(feed.getFeedName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(this.feedEntity.getRecordType());
        if (this.feedEntity.databaseNameIndex() >= 0) {
            this.fieldValue.reset();
            this.aString.setValue(feed.getDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField(this.feedEntity.databaseNameIndex(), (IValueReference)this.fieldValue);
        }
        this.fieldValue.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.feedEntity.dataverseNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(feed.getFeedName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.feedEntity.feedNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.writeFeedAdaptorField(this.recordBuilder, feed, this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(Calendar.getInstance().getTime().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.feedEntity.timestampIndex(), (IValueReference)this.fieldValue);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }

    private void writeFeedAdaptorField(IARecordBuilder recordBuilder, Feed feed, ArrayBackedValueStorage fieldValueBuffer) throws HyracksDataException {
        UnorderedListBuilder listBuilder = new UnorderedListBuilder();
        ArrayBackedValueStorage listEleBuffer = new ArrayBackedValueStorage();
        listBuilder.reset((AbstractCollectionType)((AUnorderedListType)this.feedEntity.getRecordType().getFieldTypes()[this.feedEntity.adapterConfigIndex()]));
        for (Map.Entry<String, String> property : feed.getConfiguration().entrySet()) {
            String name = property.getKey();
            String value = property.getValue();
            listEleBuffer.reset();
            this.writePropertyTypeRecord(name, value, listEleBuffer.getDataOutput());
            listBuilder.addItem((IValueReference)listEleBuffer);
        }
        listBuilder.write(fieldValueBuffer.getDataOutput(), true);
        recordBuilder.addField(this.feedEntity.adapterConfigIndex(), (IValueReference)fieldValueBuffer);
    }

    private void writePropertyTypeRecord(String name, String value, DataOutput out) throws HyracksDataException {
        RecordBuilder propertyRecordBuilder = new RecordBuilder();
        ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
        propertyRecordBuilder.reset(MetadataRecordTypes.DATASOURCE_ADAPTER_PROPERTIES_RECORDTYPE);
        AMutableString aString = new AMutableString("");
        fieldValue.reset();
        aString.setValue(name);
        this.stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        propertyRecordBuilder.addField(0, (IValueReference)fieldValue);
        fieldValue.reset();
        aString.setValue(value);
        this.stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        propertyRecordBuilder.addField(1, (IValueReference)fieldValue);
        propertyRecordBuilder.write(out, true);
    }
}

