/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.api.IMetadataEntity;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.om.utils.ProjectionFiltrationTypeUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.job.profiling.IndexStats;
import org.apache.hyracks.util.OptionalBoolean;

public class Index
implements IMetadataEntity<Index>,
Comparable<Index> {
    private static final long serialVersionUID = 4L;
    public static final int RECORD_INDICATOR = 0;
    public static final int META_RECORD_INDICATOR = 1;
    private final String databaseName;
    private final DataverseName dataverseName;
    private final String datasetName;
    private final String indexName;
    private final DatasetConfig.IndexType indexType;
    private final IIndexDetails indexDetails;
    private final boolean isPrimaryIndex;
    private final boolean isEnforced;
    private int pendingOp;

    public Index(String databaseName, DataverseName dataverseName, String datasetName, String indexName, DatasetConfig.IndexType indexType, IIndexDetails indexDetails, boolean isEnforced, boolean isPrimaryIndex, int pendingOp) {
        boolean categoryOk;
        boolean bl = categoryOk = indexType == null && indexDetails == null || IndexCategory.of(Objects.requireNonNull(indexType)) == ((AbstractIndexDetails)Objects.requireNonNull(indexDetails)).getIndexCategory();
        if (!categoryOk) {
            throw new IllegalArgumentException();
        }
        this.databaseName = Objects.requireNonNull(databaseName);
        this.dataverseName = Objects.requireNonNull(dataverseName);
        this.datasetName = Objects.requireNonNull(datasetName);
        this.indexName = Objects.requireNonNull(indexName);
        this.indexType = indexType;
        this.indexDetails = indexDetails;
        this.isPrimaryIndex = isPrimaryIndex;
        this.isEnforced = isEnforced;
        this.pendingOp = pendingOp;
    }

    @Deprecated
    public Index(String database, DataverseName dataverseName, String datasetName, String indexName, DatasetConfig.IndexType indexType, List<List<String>> keyFieldNames, List<Integer> keyFieldSourceIndicators, List<IAType> keyFieldTypes, boolean overrideKeyFieldTypes, boolean isEnforced, boolean isPrimaryIndex, int pendingOp, OptionalBoolean excludeUnknownKey) {
        this(database, dataverseName, datasetName, indexName, indexType, Index.createSimpleIndexDetails(indexType, keyFieldNames, keyFieldSourceIndicators, keyFieldTypes, overrideKeyFieldTypes, excludeUnknownKey), isEnforced, isPrimaryIndex, pendingOp);
    }

    public static Index createPrimaryIndex(String database, DataverseName dataverseName, String datasetName, List<List<String>> keyFieldNames, List<Integer> keyFieldSourceIndicators, List<IAType> keyFieldTypes, int pendingOp) {
        return new Index(database, dataverseName, datasetName, datasetName, DatasetConfig.IndexType.BTREE, new ValueIndexDetails(keyFieldNames, keyFieldSourceIndicators, keyFieldTypes, false, OptionalBoolean.empty(), OptionalBoolean.empty(), null, null, null), false, true, pendingOp);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public DataverseName getDataverseName() {
        return this.dataverseName;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public DatasetConfig.IndexType getIndexType() {
        return this.indexType;
    }

    public boolean isPrimaryIndex() {
        return this.isPrimaryIndex;
    }

    public IIndexDetails getIndexDetails() {
        return this.indexDetails;
    }

    public boolean isEnforced() {
        return this.isEnforced;
    }

    public int getPendingOp() {
        return this.pendingOp;
    }

    public void setPendingOp(int pendingOp) {
        this.pendingOp = pendingOp;
    }

    public boolean isSampleIndex() {
        return this.indexType == DatasetConfig.IndexType.SAMPLE;
    }

    public boolean isSecondaryIndex() {
        return !this.isPrimaryIndex();
    }

    public boolean isPrimaryKeyIndex() {
        return this.indexType == DatasetConfig.IndexType.BTREE && ((ValueIndexDetails)this.indexDetails).keyFieldNames.isEmpty();
    }

    public static Pair<IAType, Boolean> getNonNullableType(IAType keyType) {
        boolean nullable = false;
        IAType actualKeyType = keyType;
        if (NonTaggedFormatUtil.isOptional((IAType)keyType)) {
            actualKeyType = ((AUnionType)keyType).getActualType();
            nullable = true;
        }
        return new Pair((Object)actualKeyType, (Object)nullable);
    }

    public static Pair<IAType, Boolean> getNonNullableOpenFieldType(Index index, IAType fieldType, List<String> fieldName, ARecordType recType) throws AlgebricksException {
        if (IndexUtil.castDefaultNull(index)) {
            Pair<IAType, Boolean> nonNullableType = Index.getNonNullableType(fieldType);
            nonNullableType.second = true;
            return nonNullableType;
        }
        Pair<IAType, Boolean> keyPairType = null;
        ARecordType subType = recType;
        boolean nullable = false;
        for (int i = 0; i < fieldName.size(); ++i) {
            if (subType instanceof AUnionType) {
                nullable = nullable || ((AUnionType)subType).isUnknownableType();
                subType = ((AUnionType)subType).getActualType();
            }
            if (!(subType instanceof ARecordType)) {
                throw AsterixException.create((ErrorCode)ErrorCode.COMPILATION_ILLEGAL_STATE, (Serializable[])new Serializable[]{"Unexpected type " + fieldType});
            }
            subType = subType.getFieldType(fieldName.get(i));
            if (subType != null) continue;
            keyPairType = Index.getNonNullableType(fieldType);
            break;
        }
        if (subType != null) {
            keyPairType = Index.getNonNullableKeyFieldType(fieldName, recType);
        }
        keyPairType.second = (Boolean)keyPairType.second != false || nullable;
        return keyPairType;
    }

    public static Pair<IAType, Boolean> getNonNullableKeyFieldType(List<String> expr, ARecordType recType) throws AlgebricksException {
        IAType keyType = Index.keyFieldType(expr, recType);
        Pair<IAType, Boolean> pair = Index.getNonNullableType(keyType);
        pair.second = (Boolean)pair.second != false || recType.isSubFieldNullable(expr);
        return pair;
    }

    private static IAType keyFieldType(List<String> expr, ARecordType recType) throws AlgebricksException {
        return recType.getSubFieldType(expr);
    }

    public int hashCode() {
        return Objects.hash(this.indexName, this.datasetName, this.dataverseName, this.databaseName);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Index)) {
            return false;
        }
        Index otherIndex = (Index)other;
        if (!this.indexName.equals(otherIndex.getIndexName())) {
            return false;
        }
        if (!this.datasetName.equals(otherIndex.getDatasetName())) {
            return false;
        }
        return Objects.equals(this.databaseName, otherIndex.databaseName) && this.dataverseName.equals((Object)otherIndex.getDataverseName());
    }

    @Override
    public Index addToCache(MetadataCache cache) {
        return cache.addIndexIfNotExists(this);
    }

    @Override
    public Index dropFromCache(MetadataCache cache) {
        return cache.dropIndex(this);
    }

    @Override
    public int compareTo(Index otherIndex) {
        if (this.isPrimaryIndex && !otherIndex.isPrimaryIndex) {
            return -1;
        }
        if (!this.isPrimaryIndex && otherIndex.isPrimaryIndex) {
            return 1;
        }
        if (this.indexType == DatasetConfig.IndexType.BTREE && otherIndex.indexType != DatasetConfig.IndexType.BTREE) {
            return -1;
        }
        if (this.indexType != DatasetConfig.IndexType.BTREE && otherIndex.indexType == DatasetConfig.IndexType.BTREE) {
            return 1;
        }
        if (this.indexType == DatasetConfig.IndexType.RTREE && otherIndex.indexType != DatasetConfig.IndexType.RTREE) {
            return -1;
        }
        if (this.indexType != DatasetConfig.IndexType.RTREE && otherIndex.indexType == DatasetConfig.IndexType.RTREE) {
            return 1;
        }
        int result = this.indexName.compareTo(otherIndex.getIndexName());
        if (result != 0) {
            return result;
        }
        result = this.datasetName.compareTo(otherIndex.getDatasetName());
        if (result != 0) {
            return result;
        }
        result = this.dataverseName.compareTo(otherIndex.getDataverseName());
        if (result != 0) {
            return result;
        }
        return this.databaseName.compareTo(otherIndex.getDatabaseName());
    }

    public byte resourceType() throws CompilationException {
        switch (this.indexType) {
            case ARRAY: 
            case BTREE: 
            case SAMPLE: {
                return 0;
            }
            case RTREE: {
                return 1;
            }
            case LENGTH_PARTITIONED_NGRAM_INVIX: 
            case LENGTH_PARTITIONED_WORD_INVIX: 
            case SINGLE_PARTITION_NGRAM_INVIX: 
            case SINGLE_PARTITION_WORD_INVIX: {
                return 2;
            }
        }
        throw new CompilationException(ErrorCode.COMPILATION_UNKNOWN_INDEX_TYPE, new Serializable[]{this.indexType});
    }

    public String toString() {
        return this.dataverseName + "." + this.datasetName + "." + this.indexName;
    }

    @Deprecated
    private static IIndexDetails createSimpleIndexDetails(DatasetConfig.IndexType indexType, List<List<String>> keyFieldNames, List<Integer> keyFieldSourceIndicators, List<IAType> keyFieldTypes, boolean overrideKeyFieldTypes, OptionalBoolean excludeUnknownKey) {
        if (indexType == null) {
            return null;
        }
        switch (IndexCategory.of(indexType)) {
            case VALUE: {
                return new ValueIndexDetails(keyFieldNames, keyFieldSourceIndicators, keyFieldTypes, overrideKeyFieldTypes, excludeUnknownKey, OptionalBoolean.empty(), null, null, null);
            }
            case TEXT: {
                if (excludeUnknownKey.isPresent()) {
                    throw new IllegalArgumentException("excludeUnknownKey");
                }
                return new TextIndexDetails(keyFieldNames, keyFieldSourceIndicators, keyFieldTypes, overrideKeyFieldTypes, -1, null);
            }
        }
        throw new IllegalArgumentException(String.valueOf(indexType));
    }

    public static enum IndexCategory {
        VALUE,
        TEXT,
        ARRAY,
        SAMPLE;


        public static IndexCategory of(DatasetConfig.IndexType indexType) {
            switch (indexType) {
                case BTREE: 
                case RTREE: {
                    return VALUE;
                }
                case LENGTH_PARTITIONED_NGRAM_INVIX: 
                case LENGTH_PARTITIONED_WORD_INVIX: 
                case SINGLE_PARTITION_NGRAM_INVIX: 
                case SINGLE_PARTITION_WORD_INVIX: {
                    return TEXT;
                }
                case ARRAY: {
                    return ARRAY;
                }
                case SAMPLE: {
                    return SAMPLE;
                }
            }
            throw new IllegalArgumentException(String.valueOf(indexType));
        }
    }

    static abstract class AbstractIndexDetails
    implements IIndexDetails {
        private static final long serialVersionUID = 1L;

        AbstractIndexDetails() {
        }

        abstract IndexCategory getIndexCategory();
    }

    public static interface IIndexDetails
    extends Serializable {
        public boolean isOverridingKeyFieldTypes();
    }

    public static final class ValueIndexDetails
    extends AbstractIndexDetails {
        private static final long serialVersionUID = 1L;
        private final List<List<String>> keyFieldNames;
        private final List<Integer> keyFieldSourceIndicators;
        private final List<IAType> keyFieldTypes;
        private final boolean overrideKeyFieldTypes;
        private final Boolean excludeUnknownKey;
        private final Boolean castDefaultNull;
        private final String castDatetimeFormat;
        private final String castDateFormat;
        private final String castTimeFormat;

        public ValueIndexDetails(List<List<String>> keyFieldNames, List<Integer> keyFieldSourceIndicators, List<IAType> keyFieldTypes, boolean overrideKeyFieldTypes, OptionalBoolean excludeUnknownKey, OptionalBoolean castDefaultNull, String castDatetimeFormat, String castDateFormat, String castTimeFormat) {
            this.keyFieldNames = keyFieldNames;
            this.keyFieldSourceIndicators = keyFieldSourceIndicators;
            this.keyFieldTypes = keyFieldTypes;
            this.overrideKeyFieldTypes = overrideKeyFieldTypes;
            this.excludeUnknownKey = excludeUnknownKey.isEmpty() ? null : Boolean.valueOf(excludeUnknownKey.get());
            this.castDefaultNull = castDefaultNull.isEmpty() ? null : Boolean.valueOf(castDefaultNull.get());
            this.castDatetimeFormat = castDatetimeFormat;
            this.castDateFormat = castDateFormat;
            this.castTimeFormat = castTimeFormat;
        }

        @Override
        IndexCategory getIndexCategory() {
            return IndexCategory.VALUE;
        }

        public List<List<String>> getKeyFieldNames() {
            return this.keyFieldNames;
        }

        public List<Integer> getKeyFieldSourceIndicators() {
            return this.keyFieldSourceIndicators;
        }

        public List<IAType> getKeyFieldTypes() {
            return this.keyFieldTypes;
        }

        public OptionalBoolean getExcludeUnknownKey() {
            return OptionalBoolean.ofNullable((Boolean)this.excludeUnknownKey);
        }

        public OptionalBoolean getCastDefaultNull() {
            return OptionalBoolean.ofNullable((Boolean)this.castDefaultNull);
        }

        public String getCastDatetimeFormat() {
            return this.castDatetimeFormat;
        }

        public String getCastDateFormat() {
            return this.castDateFormat;
        }

        public String getCastTimeFormat() {
            return this.castTimeFormat;
        }

        @Override
        public boolean isOverridingKeyFieldTypes() {
            return this.overrideKeyFieldTypes;
        }

        public ARecordType getIndexExpectedType() throws AlgebricksException {
            return ProjectionFiltrationTypeUtil.getRecordType(this.getKeyFieldNames());
        }
    }

    public static final class TextIndexDetails
    extends AbstractIndexDetails {
        private static final long serialVersionUID = 1L;
        private final List<List<String>> keyFieldNames;
        private final List<Integer> keyFieldSourceIndicators;
        private final List<IAType> keyFieldTypes;
        private final boolean overrideKeyFieldTypes;
        private final String fullTextConfigName;
        private final int gramLength;

        public TextIndexDetails(List<List<String>> keyFieldNames, List<Integer> keyFieldSourceIndicators, List<IAType> keyFieldTypes, boolean overrideKeyFieldTypes, int gramLength, String fullTextConfigName) {
            this.keyFieldNames = keyFieldNames;
            this.keyFieldTypes = keyFieldTypes;
            this.keyFieldSourceIndicators = keyFieldSourceIndicators;
            this.overrideKeyFieldTypes = overrideKeyFieldTypes;
            this.gramLength = gramLength;
            this.fullTextConfigName = fullTextConfigName;
        }

        @Override
        IndexCategory getIndexCategory() {
            return IndexCategory.TEXT;
        }

        public List<List<String>> getKeyFieldNames() {
            return this.keyFieldNames;
        }

        public List<Integer> getKeyFieldSourceIndicators() {
            return this.keyFieldSourceIndicators;
        }

        public List<IAType> getKeyFieldTypes() {
            return this.keyFieldTypes;
        }

        @Override
        public boolean isOverridingKeyFieldTypes() {
            return this.overrideKeyFieldTypes;
        }

        public int getGramLength() {
            return this.gramLength;
        }

        public String getFullTextConfigName() {
            return this.fullTextConfigName;
        }
    }

    public static class SampleIndexDetails
    extends AbstractIndexDetails {
        private static final long serialVersionUID = 1L;
        private final List<List<String>> keyFieldNames;
        private final List<Integer> keyFieldSourceIndicators;
        private final List<IAType> keyFieldTypes;
        private final int sampleCardinalityTarget;
        private final long sourceCardinality;
        private final int sourceAvgItemSize;
        private final long sampleSeed;
        private final Map<String, IndexStats> indexesStats;

        public SampleIndexDetails(List<List<String>> keyFieldNames, List<Integer> keyFieldSourceIndicators, List<IAType> keyFieldTypes, int sampleCardinalityTarget, long sourceCardinality, int sourceAvgItemSize, long sampleSeed, Map<String, IndexStats> indexesStats) {
            this.keyFieldNames = keyFieldNames;
            this.keyFieldSourceIndicators = keyFieldSourceIndicators;
            this.keyFieldTypes = keyFieldTypes;
            this.sampleCardinalityTarget = sampleCardinalityTarget;
            this.sourceCardinality = sourceCardinality;
            this.sourceAvgItemSize = sourceAvgItemSize;
            this.sampleSeed = sampleSeed;
            this.indexesStats = indexesStats;
        }

        @Override
        IndexCategory getIndexCategory() {
            return IndexCategory.SAMPLE;
        }

        public List<List<String>> getKeyFieldNames() {
            return this.keyFieldNames;
        }

        public List<Integer> getKeyFieldSourceIndicators() {
            return this.keyFieldSourceIndicators;
        }

        public List<IAType> getKeyFieldTypes() {
            return this.keyFieldTypes;
        }

        @Override
        public boolean isOverridingKeyFieldTypes() {
            return false;
        }

        public int getSampleCardinalityTarget() {
            return this.sampleCardinalityTarget;
        }

        public long getSourceCardinality() {
            return this.sourceCardinality;
        }

        public int getSourceAvgItemSize() {
            return this.sourceAvgItemSize;
        }

        public long getSampleSeed() {
            return this.sampleSeed;
        }

        public Map<String, IndexStats> getIndexesStats() {
            return this.indexesStats;
        }
    }

    public static final class ArrayIndexElement
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<List<String>> unnestList;
        private final List<List<String>> projectList;
        private final List<IAType> typeList;
        private final int sourceIndicator;

        public ArrayIndexElement(List<List<String>> unnestList, List<List<String>> projectList, List<IAType> typeList, int sourceIndicator) {
            this.unnestList = unnestList != null ? unnestList : Collections.emptyList();
            this.projectList = projectList;
            this.typeList = typeList;
            this.sourceIndicator = sourceIndicator;
        }

        public List<List<String>> getUnnestList() {
            return this.unnestList;
        }

        public List<List<String>> getProjectList() {
            return this.projectList;
        }

        public List<IAType> getTypeList() {
            return this.typeList;
        }

        public int getSourceIndicator() {
            return this.sourceIndicator;
        }
    }

    public static class ArrayIndexDetails
    extends AbstractIndexDetails {
        private static final long serialVersionUID = 1L;
        private final List<ArrayIndexElement> elementList;
        private final boolean overrideKeyFieldTypes;

        public ArrayIndexDetails(List<ArrayIndexElement> elementList, boolean overrideKeyFieldTypes) {
            this.elementList = elementList;
            this.overrideKeyFieldTypes = overrideKeyFieldTypes;
        }

        @Override
        IndexCategory getIndexCategory() {
            return IndexCategory.ARRAY;
        }

        public List<ArrayIndexElement> getElementList() {
            return this.elementList;
        }

        @Override
        public boolean isOverridingKeyFieldTypes() {
            return this.overrideKeyFieldTypes;
        }

        public ARecordType getIndexExpectedType() throws AlgebricksException {
            ArrayList<ARecordType> types = new ArrayList<ARecordType>();
            for (ArrayIndexElement element : this.elementList) {
                types.add(ProjectionFiltrationTypeUtil.getRecordType(element.getUnnestList(), element.getProjectList()));
            }
            return ProjectionFiltrationTypeUtil.merge(types);
        }
    }
}

